<?php
/**
 * MMP Price List
 *
 * @package Lower Price|Entity.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_List' ) ) {

	/**
	 * MMP_List Class.
	 */
	class MMP_List extends MMP_Post {

		/**
		 * Post Type
		 *
		 * @var String
		 */
		protected $post_type = MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE;

		/**
		 * Post Status
		 *
		 * @var String
		 */
		protected $post_status = 'publish';

		/**
		 * MMP User
		 *
		 * @var String
		 */
		protected $user;

		/**
		 * MMP User Type
		 *
		 * @var String
		 */
		protected $mmp_user_type;

		/**
		 * MMP Product Data
		 *
		 * @var String
		 */
		protected $mmp_product_data;

		/**
		 * MMP Coupon Data
		 *
		 * @var String
		 */
		protected $mmp_coupon_data;

		/**
		 * Name
		 *
		 * @var String
		 */
		protected $name;

		/**
		 * User Name
		 *
		 * @var String
		 */
		protected $mmp_name;

		/**
		 * User Mail
		 *
		 * @var String
		 */
		protected $mmp_mail;

		/**
		 * User Description
		 *
		 * @var String
		 */
		protected $mmp_description;

		/**
		 * Preferred Price
		 *
		 * @var String
		 */
		protected $mmp_pref_price;

		/**
		 * Comments
		 *
		 * @var String
		 */
		protected $mmp_comments;

		/**
		 * Mobile Number
		 *
		 * @var String
		 */
		protected $mmp_number;

		/**
		 * Submitted Date
		 *
		 * @var String
		 */
		protected $mmp_date;

		/**
		 * Product ID
		 *
		 * @var Integer
		 */
		protected $mmp_pro_id;

		/**
		 * Original Price
		 *
		 * @var String
		 */
		protected $mmp_org_price;

		/**
		 * Offer Price
		 *
		 * @var String
		 */
		protected $mmp_off_price;

		/**
		 * Coupon Title
		 *
		 * @var String
		 */
		protected $mmp_coupon_tilte;

		/**
		 * Coupon Used Order ID
		 *
		 * @var Integer
		 */
		protected $mmp_coupon_used_order_id;

		/**
		 * Last Activity
		 *
		 * @var String
		 */
		protected $mmp_lst_activity;

		/**
		 * Reject Reason
		 *
		 * @var String
		 */
		protected $mmp_reject_reason;

		/**
		 * Request Type
		 *
		 * @var String
		 */
		protected $mmp_request_type;

		/**
		 * Additional Notes
		 *
		 * @var String
		 */
		protected $mmp_additional_notes;

		/**
		 * Submitted Date
		 *
		 * @var String
		 */
		protected $mmp_submitted_date;

		/**
		 * Accepted Date
		 *
		 * @var String
		 */
		protected $mmp_accepted_date;

		/**
		 * Accepted Date
		 *
		 * @var String
		 */
		protected $mmp_viewed_once;

		/**
		 * Meta data keys
		 *
		 * @var Array
		 */
		protected $meta_data_keys = array(
			'mmp_name'                 => '',
			'mmp_mail'                 => '',
			'mmp_description'          => '',
			'mmp_pref_price'           => '',
			'mmp_comments'             => '',
			'mmp_number'               => '',
			'mmp_date'                 => '',
			'mmp_pro_id'               => '',
			'mmp_org_price'            => '',
			'mmp_off_price'            => '',
			'mmp_coupon_tilte'         => '',
			'mmp_coupon_used_order_id' => '',
			'mmp_request_type'         => '',
			'mmp_lst_activity'         => '',
			'mmp_reject_reason'        => '',
			'mmp_additional_notes'     => '',
			'mmp_submitted_date'       => '',
			'mmp_accepted_date'        => '',
			'mmp_user_type'            => '',
			'mmp_viewed_once'          => '',
		);

		/**
		 * Prepare extra post data
		 */
		protected function load_extra_postdata() {
			$this->name        = $this->post->post_title;
			$this->post_parent = $this->post->post_parent;
			$this->post_author = $this->post->post_author;
		}

		/**
		 * Get User Id.
		 */
		public function get_user_id() {
			return $this->post->post_author;
		}

		/**
		 * Get User.
		 */
		public function get_user() {

			$this->user = get_userdata( $this->get_user_id() );

			return $this->user;
		}

		/**
		 * Get User.
		 */
		public function get_user_mail() {
			return $this->get_user()->user_email;
		}

		/**
		 * Get User.
		 */
		public function get_user_name() {
			return $this->get_user()->display_name;
		}

		/**
		 * Get Product Data.
		 */
		public function get_product_data() {

			$this->mmp_product_data = wc_get_product( $this->get_pro_id() );

			return $this->mmp_product_data;
		}

		/**
		 * Get Coupon Data.
		 *
		 * @since 1.0
		 * @param String $coupon_title Coupon Code.
		 * @return Object
		 */
		public function get_coupon_data( $coupon_title ) {
			$this->mmp_coupon_data = new WC_Coupon( $coupon_title );

			return $this->mmp_coupon_data;
		}

		/**
		 * Get formatted Activity datetime
		 *
		 * @since 1.0
		 */
		public function get_formatted_activity_date() {
			return MMP_Date_Time::get_date_object_format_datetime( $this->get_lst_activity() );
		}

		/**
		 * Get formatted Submitted datetime
		 *
		 * @since 1.0
		 */
		public function get_formatted_submitted_date() {
			if ( empty( $this->get_submitted_date() ) ) {
				return '-';
			}

			return MMP_Date_Time::get_date_object_format_datetime( $this->get_submitted_date() );
		}

		/**
		 * Get formatted Accepted datetime
		 *
		 * @since 1.0
		 */
		public function get_formatted_accepted_date() {
			return MMP_Date_Time::get_date_object_format_datetime( $this->get_accepted_date() );
		}

		/**
		 * Setters and Getters
		 */

		/**
		 * Set Name
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_name( $value ) {
			$this->mmp_name = $value;
		}

		/**
		 * Set Mail
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_mail( $value ) {
			$this->mmp_mail = $value;
		}

		/**
		 * Set Description
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_description( $value ) {
			$this->mmp_description = $value;
		}

		/**
		 * Set pref Price
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_pref_price( $value ) {
			$this->mmp_pref_price = $value;
		}

		/**
		 * Set Comments
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_comments( $value ) {
			$this->mmp_comments = $value;
		}

		/**
		 * Set Number
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_number( $value ) {
			$this->mmp_number = $value;
		}

		/**
		 * Set Date
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_date( $value ) {
			$this->mmp_date = $value;
		}

		/**
		 * Set Pro ID
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_pro_id( $value ) {
			$this->mmp_pro_id = $value;
		}

		/**
		 * Set Org Price
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_org_price( $value ) {
			$this->mmp_org_price = $value;
		}

		/**
		 * Set Off Price
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_off_price( $value ) {
			$this->mmp_off_price = $value;
		}

		/**
		 * Set Coupon Title
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_coupon_tilte( $value ) {
			$this->mmp_coupon_tilte = $value;
		}

		/**
		 * Set User ID
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_coupon_used_order_id( $value ) {
			$this->mmp_coupon_used_order_id = $value;
		}

		/**
		 * Set Request Type
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_request_type( $value ) {
			$this->mmp_request_type = $value;
		}

		/**
		 * Set Last Activity
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_lst_activity( $value ) {
			$this->mmp_lst_activity = $value;
		}

		/**
		 * Set Reject Reason
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_reject_reason( $value ) {
			$this->mmp_reject_reason = $value;
		}

		/**
		 * Set additional Notes
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_additional_notes( $value ) {
			$this->mmp_additional_notes = $value;
		}

		/**
		 * Set Submitted Date
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_submitted_date( $value ) {
			$this->mmp_submitted_date = $value;
		}

		/**
		 * Set Accepted Date
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_accepted_date( $value ) {
			$this->mmp_accepted_date = $value;
		}

		/**
		 * Set User Type
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_user_type( $value ) {
			$this->mmp_user_type = $value;
		}

		/**
		 * Set Viewed Once
		 *
		 * @since 1.0
		 * @param String $value The Value to set metadata.
		 */
		public function set_viewed_once( $value ) {
			$this->mmp_viewed_once = $value;
		}

		/**
		 * Get Product Link
		 */
		public function get_product_title_link() {

			return '<a target="blank" href="' . get_permalink( $this->get_pro_id() ) . '">' . $this->get_product_data()->get_name() . '</a>';
		}

		/**
		 * Get Product Name
		 */
		public function get_name() {

			return mmp_is_empty_check( $this->mmp_name );
		}

		/**
		 * Get Product Mail
		 */
		public function get_mail() {

			return $this->mmp_mail;
		}

		/**
		 * Get Status Formated
		 */
		public function get_status_formatted() {
			// for support old entry status recover
			if ( 'mmp_coupon_expired' == get_post_status( $this->id ) && mmp_is_coupon_valid( $this->get_coupon_expiry() ) ) {
				mmp_update_entry( $this->id, array( 'mmp_lst_activity' => current_time( 'mysql', true ) ), array( 'post_status' => 'mmp_coupon_sent' ) );
				return 'mmp_coupon_sent';
			}

			if ( ( 'mmp_coupon_sent' == $this->get_status() && '' != $this->mmp_coupon_tilte ) ) {
				if ( ! mmp_is_coupon_valid( $this->get_coupon_expiry() ) ) {
					mmp_update_entry( $this->id, array( 'mmp_lst_activity' => current_time( 'mysql', true ) ), array( 'post_status' => 'mmp_coupon_expired' ) );
					return 'mmp_coupon_expired';
				}
			}

			return $this->get_status();
		}

		/**
		 * Get Description
		 */
		public function get_description() {

			return mmp_is_empty_check( $this->mmp_description );
		}

		/**
		 * Get Pref Price
		 */
		public function get_pref_price() {

			return mmp_is_empty_check( $this->mmp_pref_price );
		}

		/**
		 * Get Comments
		 */
		public function get_comments() {

			return mmp_is_empty_check( $this->mmp_comments );
		}

		/**
		 * Get Number
		 */
		public function get_number() {

			return mmp_is_empty_check( $this->mmp_number );
		}

		/**
		 * Get Date
		 */
		public function get_date() {

			return mmp_is_empty_check( $this->mmp_date );
		}

		/**
		 * Get Pro ID
		 */
		public function get_pro_id() {
			return $this->mmp_pro_id;
		}

		/**
		 * Get Org Price
		 */
		public function get_org_price() {
			return $this->mmp_org_price;
		}

		/**
		 * Get Off Price
		 */
		public function get_off_price() {
			return $this->mmp_off_price;
		}

		/**
		 * Get Coupon Title
		 */
		public function get_coupon_title() {
			if ( empty( $this->mmp_coupon_tilte ) ) {
				return '-';
			}

			return $this->mmp_coupon_tilte;
		}

		/**
		 * Get Coupon Used Order ID
		 */
		public function get_coupon_used_order_id() {
			return $this->mmp_coupon_used_order_id;
		}

		/**
		 * Get Req Mode
		 */
		public function get_req_mode() {
			if ( 'mmp_feedback' == $this->get_request_type() ) {
				return esc_html__( 'Feedback', 'lower-price-for-woocommerce' );
			} elseif ( 'mmp_coupon_send' == $this->get_request_type() ) {
				return esc_html__( 'Send Coupon', 'lower-price-for-woocommerce' );
			} else {
				return esc_html__( 'Auto Apply Coupon', 'lower-price-for-woocommerce' );
			}
		}

		/**
		 * Get Coupon Amount
		 */
		public function get_coupon_amount() {

			if ( empty( $this->mmp_coupon_tilte ) ) {
				return '-';
			}

			$get_amount = $this->get_coupon_data( $this->mmp_coupon_tilte )->get_amount();
			return $get_amount;
		}

		/**
		 * Get Price Formatted
		 */
		public function get_off_price_formatted() {

			if ( empty( $this->mmp_off_price ) ) {
				return '-';
			}

			return mmp_price( $this->get_off_price(), false );
		}

		/**
		 * Get Coupon Formatted
		 */
		public function get_coupon_amount_formatted() {

			if ( empty( $this->mmp_coupon_tilte ) ) {
				return '-';
			}

			return mmp_price( $this->get_coupon_amount(), false );
		}

		/**
		 * Get Coupon Expiry
		 */
		public function get_coupon_expiry() {

			if ( empty( $this->mmp_coupon_tilte ) ) {
				return false;
			}

			$expiry_date = $this->get_coupon_data( $this->mmp_coupon_tilte )->get_date_expires();

			if ( $expiry_date ) {
				return MMP_Date_Time::get_date_object_format_datetime( $expiry_date );
			}

			return false;
		}

		/**
		 * Get Request Type
		 */
		public function get_request_type() {
			return $this->mmp_request_type;
		}

		/**
		 * Get Last Activity
		 */
		public function get_lst_activity() {

			return $this->mmp_lst_activity;
		}

		/**
		 * Get Reject Reason
		 */
		public function get_reason() {
			return mmp_is_empty_check( $this->mmp_reject_reason );
		}

		/**
		 * Get Additional Notes
		 */
		public function get_additional_notes() {
			return mmp_is_empty_check( $this->mmp_additional_notes );
		}

		/**
		 * Get Submitted Date
		 */
		public function get_submitted_date() {

			return $this->mmp_submitted_date;
		}

		/**
		 * Get Accepted Date
		 */
		public function get_accepted_date() {

			return $this->mmp_accepted_date;
		}

		/**
		 * Get Accepted Date
		 */
		public function get_user_type() {
			return $this->mmp_user_type;
		}

		/**
		 * Get Accepted Date
		 */
		public function get_viewed_once() {
			return $this->mmp_viewed_once;
		}
	}

}
