<?php
/*
 * MMP Compliance.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Privacy' ) ) :

	/**
	 * MMP_Privacy class.
	 */
	class MMP_Privacy {

		/**
		 * MMP_Privacy constructor.
		 */
		public function __construct() {
			$this->init_hooks() ;
		}

		/**
		 * Register plugin.
		 */
		public function init_hooks() {
			//This hook registers Booking System privacy content.
			add_action( 'admin_init' , array( __CLASS__, 'register_privacy_content' ) , 20 ) ;
		}

		/**
		 * Register Privacy Content.
		 */
		public static function register_privacy_content() {
			if ( ! function_exists( 'wp_add_privacy_policy_content' ) ) {
				return ;
			}

			$content = self::get_privacy_message() ;
			if ( $content ) {
				wp_add_privacy_policy_content( esc_html__( 'Lower Price For Woocommerce', 'lower-price-for-woocommerce' ) , $content ) ;
			}
		}

		/**
		 * Prepare Privacy Content.
		 */
		public static function get_privacy_message() {

			return self::get_privacy_message_html() ;
		}

		/**
		 * Get Privacy Content.
		 */
		public static function get_privacy_message_html() {
			ob_start() ;
			?>
			<p><?php esc_html_e( 'This includes the basics of what personal data your store may be collecting, storing and sharing. Depending on what settings are enabled and which additional plugins are used, the specific information shared by your store will vary.' , 'lower-price-for-woocommerce' ); ?></p>
			<h2><?php esc_html_e( 'What the Plugin Does?' , 'lower-price-for-woocommerce' ) ; ?></h2>
			<p><?php esc_html_e( 'Using this plugin, you can allow your users to notify lower price for products which they have found in other sites/shops. The price can be matched by sending a coupon.' , 'lower-price-for-woocommerce' ) ; ?> </p>
			<h2><?php esc_html_e( 'What We Collect and Store?' , 'lower-price-for-woocommerce' ) ; ?></h2>
			<h4><?php esc_html_e( 'Email Id, Userid, Mobile Number' , 'lower-price-for-woocommerce' ) ; ?></h4>
			<ul>
				<li>
					<p><?php esc_html_e( 'Used for identifying the users', 'lower-price-for-woocommerce' ) ; ?></p>
					<p><?php esc_html_e( 'Sending emails to users', 'lower-price-for-woocommerce' ) ; ?></p>
				</li>
			</ul>
			<?php
			$contents = ob_get_contents() ;
			ob_end_clean() ;

			return $contents ;
		}
	}

	new MMP_Privacy() ;

endif;
