<?php
/**
 * Admin Custom Field.
 *
 * @package Lower Price/Admin
 * */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Admin_Custom_Field' ) ) {

	/**
	 * MMP_Admin_Custom_Field Class.
	 * */
	class MMP_Admin_Custom_Field {

		/**
		 * Class initialization.
		 * */
		public static function init() {
			// Add Custom Field.
			add_action( 'admin_footer', __CLASS__ . '::custom_field_preview_template' );
			add_action( 'admin_footer', __CLASS__ . '::add_custom_field_template' );
			add_action( 'admin_footer', __CLASS__ . '::edit_custom_field_template' );
		}

		/**
		 * Output Fund Page.
		 *
		 * @since 3.3.0
		 * */
		public static function output() {
			global $current_action;

			switch ( $current_action ) {
				case 'add_new_custom_field':
					self::render_new_custom_field();
					break;
				case 'view':
					self::render_view_custom_field( $custom_field_id );
					break;
				default:
					self::render_custom_field();
					break;
			}
		}

		/**
		 * Output the Add New Custom Field.
		 *
		 * @since 3.3.0
		 * */
		public static function render_new_custom_field() {
			include_once MMP_ABSPATH . 'inc/admin/menu/views/html-admin-add-custom-field.php';
		}

		/**
		 * Output the Fund WP List Table.
		 *
		 * @since 3.3.0
		 * */
		public static function render_custom_field() {
			if ( ! class_exists( 'MMP_Admin_List_Table_Custom_Field' ) ) {
				require_once MMP_PLUGIN_PATH . '/inc/admin/list-tables/class-mmp-admin-list-table-custom-field.php';
			}

			$post_table = new MMP_Admin_List_Table_Custom_Field();
			$post_table->prepare_items();

			include_once MMP_PLUGIN_PATH . '/inc/admin/menu/views/html-custom-field.php';
		}

		/**
		 * Add Custom Field Template
		 *
		 * @since 3.3.0
		 */
		public static function add_custom_field_template() {
			?>
			<script type="text/template" id="tmpl-mmp-modal-add-custom-field">
				<?php include_once MMP_ABSPATH . 'inc/admin/menu/views/html-admin-add-custom-field.php'; ?>
			</script>
			<?php
		}

		/**
		 * Edit Custom Field Template
		 *
		 * @since 3.3.0
		 */
		public static function edit_custom_field_template() {
			?>
			<script type="text/template" id="tmpl-mmp-modal-edit-custom-field">
				<?php include_once MMP_ABSPATH . 'inc/admin/menu/views/html-admin-edit-custom-field.php'; ?>
			</script>
			<?php
		}

		/**
		 * Returns the HTML for the order preview template.
		 *
		 * @since 3.3.0
		 */
		public static function custom_field_preview_template() {
			?>
			<script type="text/template" id="tmpl-mmp-modal-view-custom-field"> 
				<?php include_once MMP_ABSPATH . 'inc/admin/menu/views/html-admin-custom-field-preview.php'; ?>
			</script> 
			<?php
		}
	}

	MMP_Admin_Custom_Field::init();
}
