<?php
/**
 * Edit Custom Field
 *
 * @package Multi-Vendor for WooCommerce/custom field
 * */

defined( 'ABSPATH' ) || exit;
?>
<div class="wc-backbone-modal mmp-modal-edit-custom-field-wrapper">
	<div class="wc-backbone-modal-content">
		<section class="wc-backbone-modal-main" role="main">
			<header class="wc-backbone-modal-header">
				<h1><?php esc_html_e( 'Edit Field', 'lower-price-for-woocommerce' ); ?></h1>
			</header>
			<article>
				<p class="mmp-fields">
					<label for="_custom_field_type"><?php esc_html_e( 'Field Type:', 'lower-price-for-woocommerce' ); ?></label>
					<select class="mmp-custom-field-type" name="_custom_field_type" id="_custom_field_type">
							<option value="dropdown" <# if ( data.field_data.field_type == 'dropdown' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Select Box', 'lower-price-for-woocommerce' ); ?></option> 
							<option value="text" <# if ( data.field_data.field_type == 'text' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Text', 'lower-price-for-woocommerce' ); ?></option> 
							<option value="email" <# if ( data.field_data.field_type == 'email' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Email', 'lower-price-for-woocommerce' ); ?></option> 
							<option value="number" <# if ( data.field_data.field_type == 'number' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Number', 'lower-price-for-woocommerce' ); ?></option> 
							<option value="radio" <# if ( data.field_data.field_type == 'radio' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Radio', 'lower-price-for-woocommerce' ); ?></option> 
							<option value="checkbox" <# if ( data.field_data.field_type == 'checkbox' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Checkbox', 'lower-price-for-woocommerce' ); ?></option> 
							<option value="textarea" <# if ( data.field_data.field_type == 'textarea' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Textarea', 'lower-price-for-woocommerce' ); ?></option> 
					</select>
				</p>

				<p class="mmp-fields">
					<label for="_label"><?php esc_html_e( 'Label:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_label" name="_label" rows="4" cols="50" class="mmp-label-field mmp-required-field">{{ data.field_data.label }}</textarea>
				</p>

				<p class="mmp-default-custom-field mmp-fields">
					<label for="_name"><?php esc_html_e( 'Name:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="text" class="mmp-name-field input-text mmp-required-field" name="_name" id="_name" value="{{ data.field_data.name }}"/>
				</p>

				<p class="mmp-fields">
					<label for="_id_attr"><?php esc_html_e( 'ID:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="text" class="mmp-id-field input-text" name="_id_attr" id="_id_attr" value="{{ data.field_data.id_attr }}"/>
				</p>

				<p class="mmp-fields">
					<label for="_class_attr"><?php esc_html_e( 'Class:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_class_attr" name="_class_attr" rows="4" cols="50" class="mmp-class-field input-text">{{ data.field_data.class_attr }}</textarea>
				</p>

				<p class="mmp-fields">
					<label for="_default"><?php esc_html_e( 'Default Value:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="text" class="mmp-default-field input-text" name="_default" id="_default" value="{{ data.field_data.default }}"/>
				</p>

				<p class="mmp-add-custom-fields mmp-number-field mmp-fields">
					<label for="_min"><?php esc_html_e( 'Minimum:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-min-field input-text" name="_min" id="_min" value="{{ data.field_data.min }}"/>
				</p>

				<p class="mmp-add-custom-fields mmp-number-field mmp-fields">
					<label for="_max"><?php esc_html_e( 'Maximum:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-max-field input-text" name="_max" id="_max" value="{{ data.field_data.max }}"/>
				</p>

				<p class="mmp-add-custom-fields mmp-number-field mmp-fields">
					<label for="_step"><?php esc_html_e( 'Step:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-step-field input-text" name="_step" id="_step" min="0" value="{{ data.field_data.step }}"/>
				</p>

				<p class="mmp-add-custom-fields mmp-text-area-field mmp-fields">
					<label for="_rows"><?php esc_html_e( 'Rows:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-rows-field input-text" name="_rows" id="_rows" min="0" value="{{ data.field_data.rows }}"/>
				</p>

				<p class="mmp-add-custom-fields mmp-text-area-field mmp-fields">
					<label for="_cols"><?php esc_html_e( 'Cols:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-cols-field input-text" name="_cols" id="_cols" min="0" value="{{ data.field_data.cols }}"/>
				</p>

				<p class="mmp-add-custom-fields mmp-dropdown-field mmp-checkbox-field mmp-radio-field mmp-fields">
					<label for="_options"><?php esc_html_e( 'Options:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_options" name="_options" rows="4" cols="50" class="mmp-options-field mmp-required-field">{{ data.options_attr }}</textarea>
					<span class="description"><?php esc_html_e( 'One option per line & use "|" for separate id and value "e.g." (id|value)', 'lower-price-for-woocommerce' ); ?></span>
				</p>

				<p class="mmp-add-custom-fields mmp-dropdown-field mmp-fields">
					<label for="_multiple"><?php esc_html_e( 'Allow Multiple Selection', 'lower-price-for-woocommerce' ); ?></label>
					<input type="checkbox" name="_multiple" name="_multiple" class="mmp-dropdown-field mmp-multiple-field input-text" <# if ( data.field_data.multiple == 'yes' ) { #> checked="checked" <# } #>>
				</p>

				<p class="mmp-fields">
					<label for="_required"><?php esc_html_e( 'Required', 'lower-price-for-woocommerce' ); ?></label>
					<input type="checkbox" name="_required" name="_required" class="mmp-required-attr-field input-text" <# if ( data.field_data.required == 'yes' ) { #> checked="checked" <# } #>>
				</p>

				<p class="mmp-fields">
					<label for="_placeholder"><?php esc_html_e( 'Placeholder:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_placeholder" name="_placeholder" rows="4" cols="50" class="mmp-placeholder-field">{{ data.field_data.placeholder }}</textarea>
				</p>

				<p class="mmp-fields">
					<label for="_tool_tip"><?php esc_html_e( 'Tool Tip:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_tool_tip" name="_tool_tip" rows="4" cols="50" class="mmp-tool-tip-field">{{ data.field_data.tool_tip }}</textarea>
				</p>

				<p class="mmp-fields">
					<label for="_data_attr"><?php esc_html_e( 'Data Attribute:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_data_attr" name="_data_attr" rows="4" cols="50" class="mmp-data-attr-field">{{ data.data_attr }}</textarea>
					<span class="description"><?php esc_html_e( 'One option per line & use "|" for separate key and value "e.g." (key|value)', 'lower-price-for-woocommerce' ); ?></span>
				</p>

				<p class="mmp-fields">
					<label for="_status"><?php esc_html_e( 'Status:', 'lower-price-for-woocommerce' ); ?></label>
					<select name="_status" id="_status" class="mmp-custom-field-status">
						<option value="mmp_enabled" <# if ( data.status == 'enabled' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Enable', 'lower-price-for-woocommerce' ); ?></option>
						<option value="mmp_disabled" <# if ( data.status == 'disabled' ) { #> selected="selected" <# } #>><?php esc_html_e( 'Disable', 'lower-price-for-woocommerce' ); ?></option>
					</select>
				</p>

				<span class="mmp-inside"></span>
				<span class="mmp-error" style="font-weight:bold;"></span>
			</article>
			<footer>                
				<div class="inner">
					<input type="hidden" name="_custom_field_id" class="mmp-custom-field-id" value="{{ data.custom_field_id }}">
					<input type="hidden" name="_mmp_field_type" class="mmp-c-field-type" value="{{ data.field_data.source_from }}">
					<input type="hidden" name="_mmp_field_name" class="mmp-c-field-name" value="{{ data.field_data.name }}">
					<button class="mmp-update-custom-field button button-primary" style="display:none;"><?php esc_html_e( 'Update Field', 'lower-price-for-woocommerce' ); ?></button>
					<a href="<?php echo esc_url( mmp_get_custom_field_page_url() ); ?>" class="mmp-cancel-custom-field-adding button"><?php esc_html_e( 'Cancel', 'lower-price-for-woocommerce' ); ?></a>
				</div>
			</footer>
		</section>
	</div>
</div>
<div class="wc-backbone-modal-backdrop"></div>
