<?php

/**
 * Register Custom Post Status.
 *
 * @package
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Register_Post_Status' ) ) {

	/**
	 * MMP_Register_Post_Status Class.
	 */
	class MMP_Register_Post_Status {

		/**
		 * Class initialization.
		 */
		public static function init() {
			add_action( 'init', array( __CLASS__, 'register_custom_post_status' ) );
		}

		/**
		 * Register Custom Post Status.
		 */
		public static function register_custom_post_status() {
			$custom_post_statuses = array(
				'mmp_new_req'        => array( 'MMP_Register_Post_Status', 'new_req_post_status_args' ),
				'mmp_coupon_sent'    => array( 'MMP_Register_Post_Status', 'coupon_sent_post_status_args' ),
				'mmp_coupon_used'    => array( 'MMP_Register_Post_Status', 'coupon_used_post_status_args' ),
				'mmp_coupon_expired' => array( 'MMP_Register_Post_Status', 'coupon_expired_post_status_args' ),
				'mmp_rejected'       => array( 'MMP_Register_Post_Status', 'coupon_rejected_post_status_args' ),
				'mmp_disabled'       => array( 'MMP_Register_Post_Status', 'form_fields_disabled' ),
				'mmp_enabled'        => array( 'MMP_Register_Post_Status', 'form_fields_enabled' ),
			);
			/**
			 * Add custom post args.
			 *
			 * @since 1.0
			 */
			$custom_post_statuses = apply_filters( 'mmp_add_custom_post_status', $custom_post_statuses );

			// return if no post status to register.
			if ( ! mmp_check_is_array( $custom_post_statuses ) ) {
				return;
			}

			foreach ( $custom_post_statuses as $post_status => $args_function ) {

				$args = array();
				if ( $args_function ) {
					$args = call_user_func_array( $args_function, array() );
				}

				// Register post status.
				register_post_status( $post_status, $args );
			}
		}

		/**
		 * Request Received Custom Post Status arguments.
		 */
		public static function new_req_post_status_args() {
			/**
			 * New req custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_new_req_post_status_args',
				array(
					'label'                     => esc_html_x( 'Request Received', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Request Received Custom Post Status arguments.
		 */
		public static function coupon_send_post_status_args() {
			/**
			 * Coupon send custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_coupon_send_post_status_args',
				array(
					'label'                     => esc_html_x( 'Request Received', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Request Received Custom Post Status arguments.
		 */
		public static function coupon_auto_apply_post_status_args() {
			/**
			 * Auto apply custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_coupon_auto_apply_status_args',
				array(
					'label'                     => esc_html_x( 'Request Received', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Coupon Sent Custom Post Status arguments.
		 */
		public static function coupon_sent_post_status_args() {
			/**
			 * Coupon sent custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_coupon_sent_post_status_args',
				array(
					'label'                     => esc_html_x( 'Coupon Sent', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Coupon Used Custom Post Status arguments.
		 */
		public static function coupon_used_post_status_args() {
			/**
			 * Used sent custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_coupon_used_post_status_args',
				array(
					'label'                     => esc_html_x( 'Coupon Used', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Coupon Expired Custom Post Status arguments.
		 */
		public static function coupon_expired_post_status_args() {
			/**
			 * Used sent custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_coupon_expired_post_status_args',
				array(
					'label'                     => esc_html_x( 'Coupon Expired', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Rejected Custom Post Status arguments.
		 */
		public static function coupon_rejected_post_status_args() {
			/**
			 * Rejected custom post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_coupon_rejected_post_status_args',
				array(
					'label'                     => esc_html_x( 'Rejected', 'lower-price-for-woocommerce' ),
					'public'                    => false,
					'exclude_from_search'       => true,
					'show_in_admin_all_list'    => false,
					'show_in_admin_status_list' => false,
				)
			);

			return $args;
		}

		/**
		 * Disabled Custom Post Status arguments.
		 */
		public static function form_fields_disabled() {
			/**
			 * Form field disabled post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_form_fields_disabled',
				array(
					'label'                     => esc_html_x( 'Disabled', 'lower-price-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: count */
					'label_count'               => _n_noop( 'Disabled <span class="count">(%s)</span>', 'Disabled <span class="count">(%s)</span>', 'lower-price-for-woocommerce' ),
				)
			);

			return $args;
		}

		/**
		 * Enabled Custom Post Status arguments.
		 */
		public static function form_fields_enabled() {
			/**
			 * Form field enabled post args.
			 *
			 * @since 1.0
			 */
			$args = apply_filters(
				'mmp_form_fields_enabled',
				array(
					'label'                     => esc_html_x( 'Enabled', 'lower-price-for-woocommerce' ),
					'public'                    => true,
					'exclude_from_search'       => false,
					'show_in_admin_all_list'    => true,
					'show_in_admin_status_list' => true,
					/* translators: %s: count */
					'label_count'               => _n_noop( 'Enabled <span class="count">(%s)</span>', 'Enabled <span class="count">(%s)</span>', 'lower-price-for-woocommerce' ),
				)
			);

			return $args;
		}
	}

	MMP_Register_Post_Status::init();
}
