<?php

/**
 * Enqueue Frontend Assets Files.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! class_exists( 'MMP_Frontend_Assets' ) ) {

	/**
	 * MMP_Frontend_Assets Class.
	 */
	class MMP_Frontend_Assets {

		/**
		 * Suffix.
		 */
		private static $suffix;

		/**
		 * MMP_Frontend_Assets Class Initialization.
		 */
		public static function init() {
			self::$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'external_js_files' ) );
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'external_css_files' ) );
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_js_files() {
			// Lightcase.
			wp_enqueue_script( 'lightcase', MMP_PLUGIN_URL . '/assets/js/frontend/lightcase' . self::$suffix . '.js', array( 'jquery' ), MMP_VERSION );

			// Enhanced lightcase.
			wp_enqueue_script( 'mmp-lightcase', MMP_PLUGIN_URL . '/assets/js/frontend/mmp-lightcase-enhanced.js', array( 'jquery', 'wc-jquery-blockui', 'lightcase' ), MMP_VERSION );
			wp_register_script( 'mmp_scripts', MMP_PLUGIN_URL . '/assets/js/frontend/frontend.js', array( 'jquery', 'wc-jquery-blockui', 'jquery-ui-datepicker' ), MMP_VERSION );

			wp_localize_script(
				'mmp_scripts',
				'mmp_frontend_params',
				array(
					'mmp_form_nonce'   => wp_create_nonce( 'mmp-form-nonce' ),
					'ajaxurl'          => MMP_ADMIN_AJAX_URL,
					'link_var_display' => get_option( 'mmp_general_display_var_show' ),
					'decimal_point'    => wc_get_price_decimal_separator(),
					/* translators: %s: price decimal separator */
					'decimal_error'    => sprintf( __( 'Please enter a value with one monetary decimal point (%s) without thousand separators and currency symbols.', 'woocommerce' ), wc_get_price_decimal_separator() ),
				)
			);

			wp_enqueue_script( 'mmp_scripts' );

			wp_enqueue_script( 'mmp_table_pagination', MMP_PLUGIN_URL . '/assets/js/frontend/pagination.js', array( 'jquery', 'wc-jquery-blockui' ), MMP_VERSION );
			wp_localize_script(
				'mmp_table_pagination',
				'mmp_pagination_params',
				array(
					'mmp_list_pagination_nonce' => wp_create_nonce( 'mmp-list-pagination' ),
					'ajaxurl'                   => MMP_ADMIN_AJAX_URL,
					'current_user'              => get_current_user_id(),
					'is_logged_in'              => is_user_logged_in() ? true : false,
					'current_page_url'          => get_permalink(),
				)
			);
		}

		/**
		 * Enqueue external css files.
		 */
		public static function external_css_files() {
			wp_enqueue_style( 'mmp_list_styles', MMP_PLUGIN_URL . '/assets/css/frontend/mmp_styles.css', array(), MMP_VERSION );
			// Lightcase.
			wp_enqueue_style( 'lightcase', MMP_PLUGIN_URL . '/assets/css/frontend/lightcase' . self::$suffix . '.css', array(), MMP_VERSION );
			// Add inline style.
			self::add_inline_style();
		}


		/**
		 * Add Inline style
		 */
		public static function add_inline_style() {
			$contents = get_option( 'mmp_advanced_custom_css', '' );

			if ( ! $contents ) {
				return;
			}

			// Add custom css as inline style.
			wp_add_inline_style( 'mmp_list_styles', $contents );
		}
	}

	MMP_Frontend_Assets::init();
}
