<?php

if ( ! function_exists( 'mmp_check_is_array' ) ) {

	/**
	 * Check if resource is array.
	 *
	 * @return bool
	 */
	function mmp_check_is_array( $array ) {
		return ( is_array( $array ) && ! empty( $array ) );
	}
}

if ( ! function_exists( 'mmp_page_screen_ids' ) ) {

	/**
	 * Get page screen IDs.
	 *
	 * @return array
	 */
	function mmp_page_screen_ids() {
		/**
		 * Display restriction.
		 *
		 * @since 3.1.0
		 */
		if ( apply_filters( 'mmp_display_unseen_count_in_menu', true ) && mmp_get_product_list_count() > 0 ) {
			/**
			 * Unseen Count
			 *
			 * @since 3.1.0
			 */
			$unseen_count = apply_filters( 'mmp_product_list_count', mmp_get_product_list_count() );
			$menu_name    = esc_html__( 'Lower Price', 'lower-price-for-woocommerce' ) . ' <span class="mmp-unseen-count-wrap awaiting-mod update-plugins count-' . esc_attr( $unseen_count ) . '" data-count="' . esc_attr( $unseen_count ) . '"><span class="mmp-unseen-count processing-count">' . number_format_i18n( $unseen_count ) . '</span></span>';
		} else {
			$menu_name = esc_html__( 'Lower Price', 'lower-price-for-woocommerce' );
		}

		$screen_id = sanitize_title( $menu_name );

		/**
		 * Screen ids.
		 *
		 * @since 1.0
		 */
		return apply_filters(
			'mmp_page_screen_ids',
			array(
				$screen_id . '_page_mmp_settings',
				$screen_id . '_page_mmp_form_fields',
				MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE,
			)
		);
	}
}

if ( ! function_exists( 'mmp_get_wc_categories' ) ) {

	/**
	 * Get WC Categories.
	 *
	 * @return array
	 */
	function mmp_get_wc_categories() {
		$categories    = array();
		$wc_categories = get_terms( 'product_cat' );

		if ( ! mmp_check_is_array( $wc_categories ) ) {
			return $categories;
		}

		foreach ( $wc_categories as $category ) {
			$categories[ $category->term_id ] = $category->name;
		}

		return $categories;
	}
}

if ( ! function_exists( 'mmp_get_user_roles' ) ) {

	/**
	 * Get WordPress User Roles.
	 *
	 * @return array
	 */
	function mmp_get_user_roles() {
		global $wp_roles;
		$user_roles = array();

		if ( ! isset( $wp_roles->roles ) || ! mmp_check_is_array( $wp_roles->roles ) ) {
			return $user_roles;
		}

		foreach ( $wp_roles->roles as $slug => $role ) {
			$user_roles[ $slug ] = $role['name'];
		}

		return $user_roles;
	}
}

if ( ! function_exists( 'mmp_get_settings_page_url' ) ) {

	/**
	 * Function to get event page URL
	 *
	 * @return array
	 */
	function mmp_get_settings_page_url( $args = array() ) {

		$url = admin_url( 'admin.php?page=mmp_settings' );

		if ( mmp_check_is_array( $args ) ) {
			$url = add_query_arg( $args, $url );
		}
		return $url;
	}
}

if ( ! function_exists( 'mmp_get_custom_field_page_url' ) ) {

	/**
	 * Function to get event page URL
	 *
	 * @return array
	 */
	function mmp_get_custom_field_page_url( $args = array() ) {

		$url = admin_url( 'admin.php?page=mmp_form_fields' );

		if ( mmp_check_is_array( $args ) ) {
			$url = add_query_arg( $args, $url );
		}
		return $url;
	}
}

if ( ! function_exists( 'mmp_get_product_variation_id' ) ) {

	/**
	 * Get product/variation id.
	 *
	 * @return int
	 */
	function mmp_get_product_variation_id( $product ) {
		$product_id = $product['product_id'];

		$whole_product = wc_get_product( $product_id );
		if ( is_object( $whole_product ) ) {
			$product_id = $whole_product->is_type( 'variable' ) ? $product['variation_id'] : $product['product_id'];
		}

		return $product_id;
	}
}

if ( ! function_exists( 'mmp_get_args_added_url' ) ) {

	/**
	 * Get product/variation id.
	 *
	 * @return int
	 */
	function mmp_get_args_added_url( $url, $args ) {

		return esc_url( add_query_arg( $args, $url ) );
	}
}

if ( ! function_exists( 'mmp_get_cart_url' ) ) {

	/**
	 * Function to get Cart page URL
	 *
	 * @return array
	 */
	function mmp_get_cart_url() {

		return function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : WC()->cart->get_cart_url();
	}
}

if ( ! function_exists( 'mmp_get_base_url' ) ) {

	/**
	 * Function to get base URL
	 *
	 * @return array
	 */
	function mmp_get_base_url( $post_id, $action ) {

		return add_query_arg(
			array(
				array(
					'post'   => $post_id,
					'action' => $action,
				),
			),
			admin_url( 'post.php' )
		);
	}
}

if ( ! function_exists( 'mmp_get_allowed_setting_tabs' ) ) {

	/**
	 * Get setting tabs
	 *
	 * @return array
	 */
	function mmp_get_allowed_setting_tabs() {
		/**
		 * Tabs array.
		 *
		 * @since 1.0
		 */
		return apply_filters( 'mmp_settings_tabs_array', array() );
	}
}

if ( ! function_exists( 'mmp_code_generation' ) ) {

	/**
	 * Create Code Generation
	 */
	function mmp_code_generation() {
		$random_code       = '';
		$mmp_coupon_prefix = get_option( 'mmp_general_coupon_preffix' );
		$mmp_coupon_suffix = get_option( 'mmp_general_coupon_suffix' );
		$length            = get_option( 'mmp_general_coupon_length' );

		$alpha_numeric = ( 1 == get_option( 'mmp_general_coupon_type' ) ) ? array_merge( range( 'a', 'z' ), range( '0', '9' ) ) : range( '0', '9' );
		while ( $length-- ) {
			$random_numbers = array_rand( $alpha_numeric );
			$random_code   .= $alpha_numeric[ $random_numbers ];
		}

		$mmp_code_pre_suff = $mmp_coupon_prefix . $random_code . $mmp_coupon_suffix;
		return $mmp_code_pre_suff;
	}
}

if ( ! function_exists( 'mmp_is_get_request_by_value_display' ) ) {

	/**
	 * Get Request By Value
	 */
	function mmp_is_get_request_by_value_display( $mail_id ) {

		$post_args = array(
			'post_type'   => MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE,
			'post_status' => array( 'mmp_new_req', 'mmp_coupon_sent', 'mmp_coupon_used', 'mmp_coupon_expired', 'mmp_rejected' ),
			'fields'      => 'ids',
			'numberposts' => -1,
			'meta_key'    => 'mmp_mail',
			'meta_value'  => $mail_id,
			'orderby'     => 'date',
			'order'       => 'DESC',
		);

		$mmp_requests = get_posts( $post_args );

		if ( mmp_check_is_array( $mmp_requests ) ) {
			return $mmp_requests;
		}

		return false;
	}
}

if ( ! function_exists( 'mmp_is_get_request_by_coupon_title' ) ) {

	/**
	 * Get Request By Coupon Title
	 */
	function mmp_is_get_request_by_coupon_title( $coupon_title ) {

		$post_args = array(
			'post_type'   => MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE,
			'post_status' => array( 'mmp_coupon_sent' ),
			'fields'      => 'ids',
			'numberposts' => -1,
			'meta_key'    => 'mmp_coupon_tilte',
			'meta_value'  => $coupon_title,
			'orderby'     => 'date',
			'order'       => 'ASC',
		);

		$mmp_requests = get_posts( $post_args );

		if ( mmp_check_is_array( $mmp_requests ) ) {
			return $mmp_requests[0];
		}

		return false;
	}
}

if ( ! function_exists( 'mmp_is_get_request_by_value' ) ) {

	/**
	 * Get Request By Value
	 */
	function mmp_is_get_request_by_value( $mail_id ) {

		$post_args = array(
			'post_type'   => MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE,
			'fields'      => 'ids',
			'post_status' => array( 'mmp_new_req', 'mmp_coupon_sent', 'mmp_coupon_used', 'mmp_coupon_expired', 'mmp_rejected' ),
			'numberposts' => -1,
			'meta_query'  => array(
				array(
					'key'     => 'mmp_mail',
					'value'   => $mail_id,
					'compare' => '=',
				),
			),
			'orderby'     => 'date',
			'order'       => 'ASC',
		);

		$mmp_requests = get_posts( $post_args );

		if ( mmp_check_is_array( $mmp_requests ) ) {
			return $mmp_requests;
		}

		return false;
	}
}

if ( ! function_exists( 'mmp_is_per_count_check' ) ) {

	/**
	 * Get Request Per Count
	 */
	function mmp_is_per_count_check( $mail_id, $pro_id, $status = 'active' ) {

		if ( 'active' == $status ) {
			$pass_status = array( 'mmp_coupon_send', 'mmp_auto_apply' );
			$post_status = array( 'mmp_new_req' );
		} elseif ( 'accept' == $status ) {
			$pass_status = array( 'mmp_coupon_send', 'mmp_auto_apply' );
			$post_status = array( 'mmp_coupon_sent' );
		} else {
			$pass_status = array( 'mmp_coupon_send', 'mmp_auto_apply' );
			$post_status = array( 'mmp_new_req', 'mmp_coupon_used', 'mmp_coupon_expired', 'mmp_rejected' );
		}

		$post_args = array(
			'post_type'   => MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE,
			'fields'      => 'ids',
			'post_status' => $post_status,
			'meta_query'  => array(
				array(
					'key'     => 'mmp_mail',
					'value'   => $mail_id,
					'compare' => '=',
				),
				array(
					'key'     => 'mmp_pro_id',
					'value'   => $pro_id,
					'compare' => '=',
				),
				array(
					'key'     => 'mmp_request_type',
					'value'   => $pass_status,
					'compare' => 'IN',
				),
			),
			'numberposts' => -1,
		);

		$mmp_requests = get_posts( $post_args );

		if ( mmp_check_is_array( $mmp_requests ) ) {
			return count( $mmp_requests );
		}
		return false;
	}
}

if ( ! function_exists( 'mmp_is_empty_check' ) ) {

	/**
	 * Is Empty Check
	 */
	function mmp_is_empty_check( $value ) {
		return ! empty( $value ) ? $value : '-';
	}
}

if ( ! function_exists( 'mmp_customize_array_position' ) ) {

	/**
	 * Get customize position of my-account menu
	 *
	 * @return array
	 * */
	function mmp_customize_array_position( $array, $key, $new_value ) {
		$keys  = array_keys( $array );
		$index = array_search( $key, $keys );
		$pos   = false === $index ? count( $array ) : $index + 1;

		$new_value = is_array( $new_value ) ? $new_value : array( $new_value );

		return array_merge( array_slice( $array, 0, $pos ), $new_value, array_slice( $array, $pos ) );
	}
}

if ( ! function_exists( 'mmp_is_coupon_valid' ) ) {

	/**
	 * Is Expired Or Not
	 * */
	function mmp_is_coupon_valid( $expiry_date ) {
		$current_date = MMP_Date_Time::get_date_object_format_datetime( current_time( 'mysql', true ) );

		if ( $expiry_date ) {
			if ( strtotime( $expiry_date ) < strtotime( $current_date ) ) {
				return false;
			}
		}

		return true;
	}
}


if ( ! function_exists( 'mmp_get_display_product_price' ) ) {
	/**
	 * Is Expired Or Not
	 *
	 * @since 1.0
	 * @param Object $product Product Object.
	 * */
	function mmp_get_display_product_price( $product ) {
		if ( $product->is_on_sale() ) {
			$price = wc_get_price_to_display( $product, array( 'price' => $product->get_price() ) );
		} else {
			$price = wc_get_price_to_display( $product );
		}

		/**
		 * Lower Price Product Original Price
		 *
		 * @since 3.0.0
		 */
		$price = apply_filters( 'mmp_product_original_price', $price, $product );

		return $price;
	}
}

if ( ! function_exists( 'mmp_get_tax_based_price' ) ) {

	/**
	 * Get tax based price
	 *
	 * @since 1.0
	 * @param Integer $product_id Product ID.
	 * @return int/HTML
	 */
	function mmp_get_tax_based_price( $product_id ) {
		$product = wc_get_product( $product_id );

		/**
		 * Filter for Tax Price
		 *
		 * @since 1.0
		 */
		return apply_filters( 'mmp_tax_based_price', wc_get_price_including_tax( $product ) );
	}
}

if ( ! function_exists( 'mmp_get_product_list_count' ) ) {
	/**
	 * Get Product List Count
	 *
	 * @since 2.3
	 * @return Integer
	 */
	function mmp_get_product_list_count() {
		$post_args = array(
			'post_type'   => MMP_Register_Post_Types::MMP_PRODUCT_POSTTYPE,
			'post_status' => 'mmp_new_req',
			'fields'      => 'ids',
			'numberposts' => -1,
			'meta_query'  => array(
				array(
					'key'     => 'mmp_viewed_once',
					'value'   => 'no',
					'compare' => '==',
				),
			),
		);

		$posts = get_posts( $post_args );
		return count( $posts );
	}
}

if ( ! function_exists( 'mmp_insert_row_query' ) ) {
	/**
	 * Insert Row Query
	 *
	 * @since 3.3.0
	 * @param String $table_name Table name.
	 * @param Array  $data Data array.
	 * @param Array  $format Data format.
	 * @return Integer
	 */
	function mmp_insert_row_query( $table_name, $data, $format ) {
		global $wpdb;

		$wpdb_ref = &$wpdb;

		if ( $wpdb_ref->get_var( "SHOW TABLES LIKE '{$table_name}'" ) ) {
			$wpdb_ref->insert(
				$table_name,
				$data,
				$format
			);

			return $wpdb_ref->insert_id;
		} else {
			/* translators: %s Database Table Name */
			return new WP_Error( 'invalid-table', sprintf( esc_html__( '%s not found in database', 'lower-price-for-woocommerce' ), esc_html( $table_name ) ) );
		}
	}
}

if ( ! function_exists( 'mmp_update_row_query' ) ) {
	/**
	 * Update Row Query
	 *
	 * @since 3.3.0
	 * @param String $table_name Table name.
	 * @param Array  $data Data array.
	 * @param Array  $values Values array.
	 * @param Array  $where Condition.
	 * @return Integer
	 */
	function mmp_update_row_query( $table_name, $data, $values, $where ) {
		global $wpdb;

		$wpdb_ref = &$wpdb;

		if ( $wpdb_ref->get_var( "SHOW TABLES LIKE '{$table_name}'" ) ) {
			$columns = array();

			foreach ( $data as $key => $place_holder ) {
				$columns[] = '`' . $key . '` = ' . "{$place_holder}";
			}

			$column_clause = implode( ', ', $columns );
			$id            = $wpdb_ref->query(
				$wpdb_ref->prepare( "UPDATE $table_name SET $column_clause WHERE $where", array_values( $values ) )
			);

			return $id;
		} else {
			/* translators: %s Database Table Name */
			return new WP_Error( 'invalid-table', sprintf( esc_html__( '%s not found in database', 'lower-price-for-woocommerce' ), esc_html( $table_name ) ) );
		}
	}
}

if ( ! function_exists( 'mmp_trim_post_status' ) ) {
	/**
	 * Trim our post status without prefix.
	 *
	 * @since 3.3.0
	 * @param String $status Status.
	 * @return String
	 */
	function mmp_trim_post_status( $status ) {
		$status = ( 'mmp_' === substr( $status, 0, 4 ) ) ? substr( $status, 4 ) : $status;

		return $status;
	}
}
