<?php

if ( ! function_exists( 'mmp_create_entry' ) ) {

	/**
	 * Create New MMP
	 *
	 * @return integer/string
	 */
	function mmp_create_entry( $meta_args, $post_args = array() ) {

		$object = new MMP_List();
		$id     = $object->create( $meta_args, $post_args );

		return $id;
	}
}

if ( ! function_exists( 'mmp_get_entry' ) ) {

	/**
	 * Get MMP object
	 *
	 * @return object
	 */
	function mmp_get_entry( $id ) {

		$object = new MMP_List( $id );

		return $object;
	}
}

if ( ! function_exists( 'mmp_update_entry' ) ) {

	/**
	 * Update MMP
	 *
	 * @return object
	 */
	function mmp_update_entry( $id, $meta_args, $post_args = array() ) {

		$object = new MMP_List( $id );
		$object->update( $meta_args, $post_args );

		return $object;
	}
}

if ( ! function_exists( 'mmp_delete_entry' ) ) {

	/**
	 * Delete Rule
	 *
	 * @return bool
	 */
	function mmp_delete_entry( $id, $force = true ) {

		wp_delete_post( $id, $force );

		return true;
	}
}

if ( ! function_exists( 'mmp_create_fields_entry' ) ) {

	/**
	 * Create New MMP Form Field
	 *
	 * @return integer/string
	 */
	function mmp_create_fields_entry( $meta_args, $post_args = array() ) {

		$object = new MMP_Form_Fields_List();
		$id     = $object->create( $meta_args, $post_args );

		return $id;
	}
}

if ( ! function_exists( 'mmp_get_fields_entry' ) ) {

	/**
	 * Get MMP Form Field object
	 *
	 * @return object
	 */
	function mmp_get_fields_entry( $id ) {

		$object = new MMP_Form_Fields_List( $id );

		return $object;
	}
}

if ( ! function_exists( 'mmp_update_fields_entry' ) ) {

	/**
	 * Update MMP Form Field
	 *
	 * @return object
	 */
	function mmp_update_fields_entry( $id, $meta_args, $post_args = array() ) {

		$object = new MMP_Form_Fields_List( $id );
		$object->update( $meta_args, $post_args );

		return $object;
	}
}

if ( ! function_exists( 'mmp_delete_fields_entry' ) ) {

	/**
	 * Delete Rule
	 *
	 * @return bool
	 */
	function mmp_delete_fields_entry( $id, $force = true ) {

		wp_delete_post( $id, $force );

		return true;
	}
}
