<?php
/**
 * Customer Admin Ack.
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/emails/admin-ack.php.
 *
 * @package Lower Price
 */

defined( 'ABSPATH' ) || exit;

/**
 * Email header.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<p>
	<?php
	printf( wp_kses_post( __( 'Hi,<br/> You have received a request where this product has found at the lowest price on another site. You can accept this request by sending a coupon or reject it based on your enquiry.', 'lower-price-for-woocommerce' ) ) );
	/**
	 * Get pro table.
	 *
	 * @since 1.0.0
	 */
	do_action( 'mmp_get_pro_table', $list_obj, $mmp_pro_id );
	?>
</p>

<br/>

<p>
	<?php
	/* translators: 1: Email */
	printf( wp_kses_post( __( 'Email: %s' ) ), esc_html( $list_obj->get_mail() ) );
	?>
</p>

<p>
	<?php
	/* translators: 1: Description */
	printf( wp_kses_post( __( 'Description: %s' ) ), esc_html( $list_obj->get_description() ) );
	?>
</p>

<p style="margin:15px 0;">
	<?php
	/* translators: 1: Request Link */
	printf( wp_kses_post( __( 'Click %s to view the request.' ) ), '<a target="blank" href="' . esc_url( admin_url( 'post.php?post=' . absint( $list_id ) . '&action=edit' ) ) . '">' . wp_kses_post( __( 'Here', 'lower-price-for-woocommerce' ) ) . '</a>' );
	?>
</p>

<p><?php esc_html_e( 'Thanks.', 'lower-price-for-woocommerce' ); ?></p>

<?php
/**
 * Email footer.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_footer', $email );
?>
