<?php
/**
 * Customer Coupon Apply.
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/emails/customer-coupon-apply.php.
 *
 * @package Lower Price
 */

defined( 'ABSPATH' ) || exit;

/**
 * Email header.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<p style="margin:15px 0;">
	<?php
	/* translators: 1: user name 2: Product name  */
	printf( wp_kses_post( __( 'Hi <b>%1$s</b>, <br>We have accepted your lower price request for the <b>%2$2s</b> you have notified. Make use of the below link to get a discount before it gets expired. Please check the below details,', 'lower-price-for-woocommerce' ) ), esc_html( $user_name ), '<a target="blank" href="' . esc_attr( get_permalink( $mmp_pro_id ) ) . '">' . wp_kses_post( wc_get_product( $mmp_pro_id )->get_name() ) . '</a>' );

	/**
	 * Get request table.
	 *
	 * @since 1.0
	 */
	do_action( 'mmp_get_request_table', $list_obj, $mmp_pro_id );
	?>
</p>

<p style="margin:15px 0;">
	<?php
	if ( '-' !== $list_obj->get_reason() ) {
		/* translators: %s: Reason */
		printf( wp_kses_post( __( '<b>Reason:</b> %s <br>', 'lower-price-for-woocommerce' ) ), esc_attr( $list_obj->get_reason() ) );
	}
	?>
</p>

<p style="margin:15px 0;">
	<?php

	/* translators: 1: Site link */
	printf( wp_kses_post( __( 'Click %s to purchase the product with the offered price. ' ) ), '<a target="blank" href="' . esc_attr( add_query_arg( array( 'auto_apply' => $list_id ), wc_get_cart_url() ) ) . '">' . wp_kses_post( __( 'Here', 'lower-price-for-woocommerce' ) ) . '</a>' );
	?>
</p>

<p><?php esc_html_e( 'Thanks.', 'lower-price-for-woocommerce' ); ?></p>

<?php
/**
 * Email footer.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_footer', $email ); ?>
