<?php
/**
 * This template displays contents inside form fields
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/lower-price-for-woocommerce.php
 *
 * To maintain compatibility, Lower Price for WooCommerce will update the template files and you have to copy the updated files to your theme
 *
 * @package Lower Price/Form Fields
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<a class="mmp_min_price_link"><?php echo esc_html( get_option( 'mmp_messages_link_msg' ) ); ?></a>

<div class="mmp_popup_overall_wrapper mmp_hide" id="mmp_popup_overall_wrapper">
	<div class="mmp_popup_form_wrapper" id="mmp_popup_form_wrapper">
			<p class="mmp_popup_title"><?php echo esc_html( get_option( 'mmp_localization_form_title' ) ); ?></p>
			<p class="mmp_popup_desc"><?php echo esc_html( get_option( 'mmp_localization_form_description' ) ); ?></p>
			<div id='mmp_error'></div>
		<?php
		foreach ( $custom_fields_obj->custom_fields as $custom_field_obj ) {
			if ( 'mmp_mail' === $custom_field_obj->get_name() && $customer_email ) {
				?>
				<input type="hidden" id="<?php echo esc_attr( $custom_field_obj->get_name() ); ?>" class="mmp-form-fields <?php echo esc_attr( $custom_field_obj->get_class_attr() ); ?>" name="<?php echo esc_attr( $custom_field_obj->get_name() ); ?>" value="<?php echo esc_attr( $customer_email ); ?>">
				<?php
			} elseif ( 'mmp_name' === $custom_field_obj->get_name() && $customer_name ) {
				?>
				<input type="hidden" id="<?php echo esc_attr( $custom_field_obj->get_name() ); ?>" class="mmp-form-fields <?php echo esc_attr( $custom_field_obj->get_class_attr() ); ?>" name="<?php echo esc_attr( $custom_field_obj->get_name() ); ?>" value="<?php echo esc_attr( $customer_name ); ?>">
				<?php
			} else {
				mmp_output_custom_fields( $custom_field_obj );
			}
		}
		?>
		<input type='hidden' name='mmp_post_id' class="mmp-form-fields" value="<?php echo esc_attr( $post_id ); ?>">
		<input type="button" id="mmp_form_save" name="mmp_form_save" value="<?php echo esc_html( get_option( 'mmp_localization_form_submit', 'Submit' ) ); ?>">
	</div>
</div>
<?php
