/* global mmp_settings_params */

jQuery(function ($) {

	var MMP_Settings = {
		init: function () {
			this.trigger_on_page_load();
			//General Settings
			$(document).on('change', '#mmp_general_form_position', this.changeSPFPosition)
				.find('#mmp_general_form_position').change();
			$(document).on('change', '#mmp_general_form_position_variable', this.changeVPFPosition)
				.find('#mmp_general_form_position_variable').change();

			$(document).on('change', '#mmp_general_product_category', this.trigger_product_category);
			$(document).on('change', '#mmp_general_mode_of_operaton', this.mode_of_operaton);
			$(document).on('change', '#mmp_general_coupon_type', this.coupon_type);
			//Advance Settings
			$(document).on('change', '#mmp_advanced_user_roles_users', this.trigger_user_roles_users);
			$(document).on('change', '#mmp_advanced_overall_product_restriction', this.trigger_overall_product_restriction);
			//Delete Confirmation 
			$(document).on('click', '.mmp_entry_delete', this.trigger_entry_delete);

			//Reject Confirmation 
			$(document).on('click', '#mmp_reson_reject', this.trigger_reson_reject);
			$(document).on('click', '#mmp_accept_mail', this.trigger_accept_mail);


		},

		trigger_on_page_load: function () {
			this.triggerViewedOnceAction();
			this.toggle_product_category('#mmp_general_product_category');
			this.toggle_mode_of_operaton('#mmp_general_mode_of_operaton');
			this.toggle_coupon_type('#mmp_general_coupon_type');
			this.toggle_user_roles_users('#mmp_advanced_user_roles_users');
			this.toggle_overall_product_restriction('#mmp_advanced_overall_product_restriction');
		},

		changeSPFPosition(e) {
			e.preventDefault();

			if ('custom' === $(this).val()) {
				$('#mmp_general_form_position_custom_hook').closest('tr').show();
			} else {
				$('#mmp_general_form_position_custom_hook').closest('tr').hide();
			}
		},

		changeVPFPosition(e) {
			e.preventDefault();

			if ('custom' === $(this).val()) {
				$('#mmp_general_form_position_variable_custom_hook').closest('tr').show();
			} else {
				$('#mmp_general_form_position_variable_custom_hook').closest('tr').hide();
			}
		},

		triggerViewedOnceAction() {
			if ($('.mmp-viewed-count').length > 0) {
				$val = $('.mmp-viewed-count').val();

				if ('' !== $val) {
					var data = ({
						action: 'mmp_update_viewed_once',
						post_id: $val,
						mmp_security: mmp_settings_params.viewed_once_nonce,
					});
					$.post(ajaxurl, data, function (res) {
						if (true === res.success) {
							if ($('.mmp-unseen-count-wrap').length > 0) {
								let $prev_count = $('.mmp-unseen-count-wrap').data('count');

								if (0 === res.data.unseen_count) {
									$('.mmp-unseen-count').closest('.mmp-unseen-count-wrap').remove();
								} else {
									$('.mmp-unseen-count').closest('.mmp-unseen-count-wrap').removeClass('count-' + $prev_count);
									$('.mmp-unseen-count').closest('.mmp-unseen-count-wrap').addClass('count-' + res.data.unseen_count);
									$('.mmp-unseen-count-wrap').data('count', res.data.unseen_count);
									$('.mmp-unseen-count').html(res.data.unseen_count);
								}
							}
						} else {
							alert(res.data.error);
						}
					});
				}
			}
		},

		trigger_accept_mail: function (event) {
			if ('' == $('#mmp_offered_price').val()) {
				alert(mmp_settings_params.accept_validation_message);
				event.preventDefault();
			}
		},

		trigger_entry_delete: function (event) {
			if (!confirm(mmp_settings_params.delete_confirm_message)) {
				event.preventDefault();
			}
		},
		trigger_reson_reject: function (event) {
			if (!confirm(mmp_settings_params.reject_confirm_message)) {
				event.preventDefault();
			}
		},

		trigger_product_category: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);
			MMP_Settings.toggle_product_category($this);
		},
		toggle_product_category: function ($this) {
			$('.mmp_product_cat_search_fields').closest('tr').hide();

			if ($($this).val() == 2) {
				$('#mmp_general_included_product').closest('tr').show();
			} else if ($($this).val() == 3) {
				$('#mmp_general_exclude_product').closest('tr').show();
			} else if ($($this).val() == 5) {
				$('#mmp_general_included_category').closest('tr').show();
			} else if ($($this).val() == 6) {
				$('#mmp_general_exclude_category').closest('tr').show();
			}
		},
		mode_of_operaton: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);
			MMP_Settings.toggle_mode_of_operaton($this);
		},
		toggle_mode_of_operaton: function ($this) {
			if ($($this).val() != 'mmp_feedback') {
				$('#mmp_general_coupon_validity').closest('tr').show();
			} else {
				$('#mmp_general_coupon_validity').closest('tr').hide();
			}
		},
		coupon_type: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);
			MMP_Settings.toggle_coupon_type($this);
		},
		toggle_coupon_type: function ($this) {
			if ($($this).val() == 1) {
				$('#mmp_general_coupon_name_type').closest('tr').show();
			} else {
				$('#mmp_general_coupon_name_type').closest('tr').hide();
			}
		},
		trigger_overall_product_restriction: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);
			MMP_Settings.toggle_overall_product_restriction($this);
		},
		toggle_overall_product_restriction: function ($this) {
			$('#mmp_advanced_pro_restriction_val').closest('tr').hide();
			if ($($this).is(":checked")) {
				$('#mmp_advanced_pro_restriction_val').closest('tr').show();
			}
		},

		trigger_user_roles_users: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);
			MMP_Settings.toggle_user_roles_users($this);
		},
		toggle_user_roles_users: function ($this) {
			$('.mmp_customers_roles_search').closest('tr').hide();
			if ($($this).val() == 2) {
				$('#mmp_advanced_included_user').closest('tr').show();
			} else if ($($this).val() == 3) {
				$('#mmp_advanced_exclude_user').closest('tr').show();
			} else if ($($this).val() == 4) {
				$('#mmp_advanced_included_user_role').closest('tr').show();
			} else if ($($this).val() == 5) {
				$('#mmp_advanced_excluded_user_role').closest('tr').show();
			}
		},


	};
	MMP_Settings.init();
});
