/* global mmp_frontend_params */

/* MMP Settings */
jQuery(function ($) {

	var MMP_Frontend = {
		init: function () {
			//Form Save
			$(document).on('click', '#mmp_form_save', this.form_save);
			$(document).on('found_variation.wc-variation-form', { variationForm: this }, this.onFoundVariation);
			if ('yes' == mmp_frontend_params.link_var_display) {
				$(document).on('change.wc-variation-form', '.variations select', { variationForm: this }, this.onNoneVariation);
			}
		},
		form_save: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget),
				wrapper = $($this).closest('div.mmp_popup_overall_wrapper');

			if (wrapper.length > 0) {
				MMP_Frontend.block('#mmp_popup_overall_wrapper');

				var data = ({
					action: 'mmp_form_fields_save',
					popup_form_data: wrapper.find("#mmp_popup_form_wrapper").find("textarea, input").serialize(),
					mmp_email: wrapper.find("#mmp_mail").val(),
					mmp_description: wrapper.find("#mmp_description").val(),
					mmp_security: mmp_frontend_params.mmp_form_nonce,
				});
				$.post(mmp_frontend_params.ajaxurl, data, function (res) {
					if (true === res.success) {
						wrapper.find('#mmp_popup_form_wrapper').remove();
						wrapper.html(res.data.layout);
					} else {
						wrapper.find('#mmp_error').html(res.data.error);
					}

					MMP_Frontend.unblock('#mmp_popup_overall_wrapper');
				});
			}
		},
		onNoneVariation: function (event) {
			var variation_id = $('input[name=variation_id]').val();

			if (variation_id == '0' || variation_id == '' || variation_id == undefined) {
				$(".mmp_variation_datas").html('');
				MMP_Frontend.block(".variations_form");
				//                $ ( ".mmp_simple_datas" ).show () ;
				var data = {
					action: "mmp_get_form_fields",
					mmp_post_id: mmp_frontend_params.post_id,
					mmp_security: mmp_frontend_params.mmp_form_nonce,
				}
				$.post(mmp_frontend_params.ajaxurl, data, function (response) {
					if (response.success) {
						$(".mmp_simple_datas").html(response.content);
						$('.mmp_min_price_link').lightcase({
							href: '#mmp_popup_overall_wrapper',
							onStart: {
								onstart_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'block');
								}
							},
							onCleanup: {
								onclose_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'none');
								}
							},
						});
					}
					MMP_Frontend.unblock(".variations_form");
				});

			}
		},

		onFoundVariation: function (event, variation_form) {
			MMP_Frontend.wcpa_variation_change(variation_form.variation_id, event);
		},
		wcpa_var_field_display: function ($event) {
			var variation_id = $('input[name=variation_id]').val(),
				product_id = $('input[name=product_id]').val();
			MMP_Frontend.wcpa_variation_change(variation_id, $event);
		},
		wcpa_variation_change: function (variation_id, event) {
			$(".mmp_variation_datas").html('');
			$(".mmp_simple_datas").html('');
			$(".mmp_simple_datas").attr("disabled", "disabled");

			if (variation_id != '0' && variation_id != '' && variation_id != undefined) {
				MMP_Frontend.block(".variations_form");
				var data = {
					action: "mmp_get_form_fields",
					mmp_post_id: variation_id,
					popup_form_data: $("#mmp_popup_form_wrapper").find("textarea, input").serialize(),
					mmp_security: mmp_frontend_params.mmp_form_nonce,
				}
				$.post(mmp_frontend_params.ajaxurl, data, function (response) {
					if (response.success) {
						$(".mmp_variation_datas").html(response.content);
						$('.mmp_min_price_link').lightcase({
							href: '#mmp_popup_overall_wrapper',
							onStart: {
								onstart_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'block');
								}
							},
							onCleanup: {
								onclose_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'none');
								}
							},
						});
					}
					MMP_Frontend.unblock(".variations_form");
				});
			}
		},
		block: function (id) {
			$(id).block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.7
				}
			});
		}, unblock: function (id) {
			$(id).unblock({
				message: 'Form having Error',
			});
		},
	};
	MMP_Frontend.init();
});
