<?php

/**
 * Enqueue Admin Assets Files.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! class_exists( 'MMP_Admin_Assets' ) ) {

	/**
	 * MMP_Admin_Assets Class.
	 */
	class MMP_Admin_Assets {

		/**
		 * MMP_Admin_Assets Class Initialization.
		 */
		public static function init() {
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'external_js_files' ) );
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'external_css_files' ) );
		}

		/**
		 * Enqueue external css files.
		 */
		public static function external_css_files() {
			$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

			$screen_ids   = mmp_page_screen_ids();
			$newscreenids = get_current_screen();
			$screenid     = str_replace( 'edit-', '', $newscreenids->id );

			if ( ! in_array( $screenid, $screen_ids ) ) {
				return;
			}
			wp_enqueue_style( 'mmp_admin_styles', MMP_PLUGIN_URL . '/assets/css/admin/admin.css', array(), MMP_VERSION );
		}

		/**
		 * Enqueue Admin end required JS files.
		 */
		public static function external_js_files() {

			$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

			$screen_ids = mmp_page_screen_ids();

			$newscreenids  = get_current_screen();
			$screenid      = str_replace( 'edit-', '', $newscreenids->id );
			$enqueue_array = array(
				'mmp-select2'  => array(
					'callable' => array( 'MMP_Admin_Assets', 'select2' ),
					'restrict' => in_array( $screenid, $screen_ids ),
				),
				'mmp-settings' => array(
					'callable' => array( 'MMP_Admin_Assets', 'settings_scripts' ),
					'restrict' => in_array( $screenid, $screen_ids ),
				),
				'mmp-sortable' => array(
					'callable' => array( 'MMP_Admin_Assets', 'settings_sortable' ),
					'restrict' => in_array( $screenid, $screen_ids ),
				),
			);
			/**
			 * Admin scripts.
			 *
			 * @since 1.0
			 */
			$enqueue_array = apply_filters( 'mmp_admin_enqueue_scripts', $enqueue_array );
			if ( ! mmp_check_is_array( $enqueue_array ) ) {
				return;
			}

			foreach ( $enqueue_array as $key => $enqueue ) {
				if ( ! mmp_check_is_array( $enqueue ) ) {
					continue;
				}

				if ( $enqueue['restrict'] ) {
					call_user_func_array( $enqueue['callable'], array( $suffix ) );
				}
			}
			/**
						 * After enqueue JS.
						 *
						 * @since 1.0
						 */
			do_action( 'mmp_admin_after_enqueue_js' );
		}

		/**
		 * Enqueue select2 scripts.
		 */
		public static function select2( $suffix ) {

			wp_enqueue_script( 'mmp-enhanced', MMP_PLUGIN_URL . '/assets/js/mmp-enhanced.js', array( 'jquery', 'select2', 'jquery-ui-datepicker' ), MMP_VERSION );
			wp_localize_script(
				'mmp-enhanced',
				'mmp_enhanced_select_params',
				array(
					'search_nonce' => wp_create_nonce( 'mmp-search-nonce' ),
					'ajaxurl'      => MMP_ADMIN_AJAX_URL,
				)
			);
		}

		/**
		 * Enqueue Admin Settings scripts.
		 */
		public static function settings_scripts() {
			wp_enqueue_script( 'mmp-settings', MMP_PLUGIN_URL . '/assets/js/admin/mmp-settings.js', array( 'jquery' ), MMP_VERSION );
			wp_localize_script(
				'mmp-settings',
				'mmp_settings_params',
				array(
					'accept_validation_message' => esc_html__( 'Please Enter the Offer Price Value', 'lower-price-for-woocommerce' ),
					'delete_confirm_message'    => esc_html__( 'Are you sure you want to delete it?', 'lower-price-for-woocommerce' ),
					'reject_confirm_message'    => esc_html__( 'Are you sure you want to proceed?', 'lower-price-for-woocommerce' ),
					'viewed_once_nonce'         => wp_create_nonce( 'mmp-viewed-once-nonce' ),
				)
			);
		}

		/**
		 * Enqueue Admin Post Table Scripts.
		 */
		public static function settings_sortable() {
			wp_enqueue_script( 'mmp-form-fields', MMP_PLUGIN_URL . '/assets/js/admin/mmp-form-fields.js', array( 'jquery', 'jquery-ui-sortable' ), MMP_VERSION );
			wp_localize_script(
				'mmp-form-fields',
				'mmp_form_fields_params',
				array(
					'field_sort_nonce' => wp_create_nonce( 'mmp-field-sort-nonce' ),
				)
			);
		}
	}

	MMP_Admin_Assets::init();
}
