<?php
/**
 * Admin Acknowledge Email.
 *
 * @package Lower Price for Woocommerce
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WC_MMP_Admin_Ack', false ) ) {

	/**
	 * Account Admin Ack Email.
	 *
	 * @class WC_MMP_Admin_Ack
	 * @package class
	 * @extends WC_MMP_Abstract_Email
	 */
	class WC_MMP_Admin_Ack extends WC_MMP_Abstract_Email {

		/**
		 * List ID.
		 *
		 * @var Integer
		 */
		public $list_id;

		/**
		 * List Obj.
		 *
		 * @var Object
		 */
		public $list_obj;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = WC_MMP_PREFIX . 'admin_ack';
			$this->title          = __( 'Admin Ack', 'lower-price-for-woocommerce' );
			$this->template_html  = 'emails/admin-ack.php';
			$this->template_plain = 'emails/plain/admin-ack.php';
			$this->subject        = __( '{site_title} - Lower Price Request Received', 'lower-price-for-woocommerce' );
			$this->heading        = __( 'Admin Acknowledgement', 'lower-price-for-woocommerce' );
			$this->supports       = array( 'recipient' );
			$this->description    = __( 'Admin will receive an email notification when a user submits the lower price request.', 'lower-price-for-woocommerce' );

			// Triggers for this email.
			add_action( 'wc_mmp_admin_ack_notification', array( $this, 'trigger' ) );

			// Call parent constructor.
			parent::__construct();
		}

		/**
		 * Get content args.
		 *
		 * @since 1.0.0
		 * @return array
		 */
		public function get_content_args() {
			$content_args               = parent::get_content_args();
			$content_args['list_id']    = $this->list_id;
			$content_args['list_obj']   = $this->list_obj;
			$content_args['mmp_pro_id'] = $this->list_obj->get_pro_id();

			return $content_args;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @since 1.0.0
		 * @param Integer $entry_id Entry ID.
		 */
		public function trigger( $entry_id ) {
			$list_obj       = mmp_get_entry( $entry_id );
			$this->list_id  = $entry_id;
			$this->list_obj = $list_obj;

			$this->maybe_trigger();
		}
	}

}

return new WC_MMP_Admin_Ack();
