<?php

/**
 * MMP Restrictions Handling
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Restriction_Handler' ) ) {

	/**
	 * Main MMP_Restriction_Handler Class.
	 * */
	class MMP_Restriction_Handler {

		public static $mmp_product_id;

		public static function is_valid_for_mmp( $product_id ) {

			self::$mmp_product_id = $product_id;

			// user user roles
			if ( is_user_logged_in() && ! self::is_valid_user() ) {
				return false;
			}

			// product category
			if ( ! self::check_product_and_category_valid_to_mmp() ) {
				return false;
			}

			return true;
		}

		/**
		 * Check if ordered user is matched with selected user/user role for refund.
		 *
		 * @return bool
		 */
		public static function is_valid_user() {
			$user_type = get_option( 'mmp_advanced_user_roles_users' );
			if ( '2' == $user_type ) {
				$user_ids = get_option( 'mmp_advanced_included_user' );
				if ( ! mmp_check_is_array( $user_ids ) ) {
					return true;
				} elseif ( in_array( get_current_user_id(), $user_ids ) ) {
						return true;
				}
			} elseif ( '3' == $user_type ) {
				$user_ids = get_option( 'mmp_advanced_exclude_user' );
				if ( ! mmp_check_is_array( $user_ids ) ) {
					return true;
				} elseif ( ! in_array( get_current_user_id(), $user_ids ) ) {
						return true;
				}
			} elseif ( '4' == $user_type ) {
				$user_roles = get_option( 'mmp_advanced_included_user_role' );
				if ( ! mmp_check_is_array( $user_roles ) ) {
					return true;
				} else {
					return self::is_valid_user_role( get_current_user_id(), $user_roles );
				}
			} elseif ( '5' == $user_type ) {
				$user_roles = get_option( 'mmp_advanced_excluded_user_role' );

				if ( ! mmp_check_is_array( $user_roles ) ) {
					return true;
				} else {
					return self::is_valid_user_role( get_current_user_id(), $user_roles ) ? false : true;
				}
			} else {
				return true;
			}

			return false;
		}

		/**
		 * Check if corresponding user role is selected.
		 *
		 * @return bool
		 */
		public static function is_valid_user_role( $user_id, $selected_user_roles ) {
			$user_obj = get_userdata( $user_id );
			if ( ! mmp_check_is_array( $user_obj->roles ) ) {
				return false;
			}

			foreach ( $user_obj->roles as $role ) {
				if ( in_array( $role, $selected_user_roles ) ) {
					return true;
				}
			}

			return false;
		}

		/**
		 * Check if order has selected product/category.
		 *
		 * @return bool
		 */
		public static function check_product_and_category_valid_to_mmp() {
			$product_type = get_option( 'mmp_general_product_category' );

			if ( '2' == $product_type ) {
				$product_ids = get_option( 'mmp_general_included_product' );
				if ( ! mmp_check_is_array( $product_ids ) ) {
					return true;
				} else {
					return self::check_get_items( 'product', $product_ids );
				}
			} elseif ( '3' == $product_type ) {
				$product_ids = get_option( 'mmp_general_exclude_product' );
				if ( ! mmp_check_is_array( $product_ids ) ) {
					return true;
				} else {
					return ( self::check_get_items( 'product', $product_ids ) ) ? false : true;
				}
			} elseif ( '5' == $product_type ) {
				$category = get_option( 'mmp_general_included_category' );
				if ( ! mmp_check_is_array( $category ) ) {
					return true;
				} else {
					return self::check_get_items( 'category', $category );
				}
			} elseif ( '6' == $product_type ) {
				$category = get_option( 'mmp_general_exclude_category' );
				if ( ! mmp_check_is_array( $category ) ) {
					return true;
				} else {
					return ( self::check_get_items( 'category', $category ) ) ? false : true;
				}
			} else {
				return true;
			}

			return false;
		}

		/**
		 * Check if product/category/ is matched with selected value.
		 *
		 * @return bool
		 */
		public static function check_get_items( $post_type, $select_products ) {
			$bool = false;

			if ( 'product' == $post_type ) {
				$bool = self::is_selected_product( self::$mmp_product_id, $select_products );
			} elseif ( 'category' == $post_type ) {
				$bool = self::is_selected_category( self::$mmp_product_id, $select_products );
			}

			return $bool;
		}

		/**
		 * Check if corresponding product is selected.
		 *
		 * @return bool
		 */
		public static function is_selected_product( $product_id, $selected_products ) {
			$selected_products = mmp_check_is_array( $selected_products ) ? $selected_products : explode( ',', $selected_products );
			$product_obj       = wc_get_product( $product_id );

			if ( ! is_object( $product_obj ) ) {
				return false;
			}

			if ( 'simple' === $product_obj->get_type() ) {
				if ( in_array( $product_id, $selected_products ) ) {
					return true;
				}
			} elseif ( 'variation' === $product_obj->get_type() ) {
				$productid = $product_obj->get_parent_id();
				if ( in_array( $product_id, $selected_products ) || in_array( $productid, $selected_products ) ) {
					return true;
				}
			}

			return false;
		}

		/**
		 * Check if corresponding category is selected.
		 *
		 * @return bool
		 */
		public static function is_selected_category( $product_id, $selected_category ) {
			$selected_category = mmp_check_is_array( $selected_category ) ? $selected_category : explode( ',', $selected_category );
			$product_obj       = wc_get_product( $product_id );
			if ( ! is_object( $product_obj ) ) {
				return false;
			}

			$terms = get_the_terms( $product_id, 'product_cat' );
			if ( ! mmp_check_is_array( $terms ) ) {
				return false;
			}

			foreach ( $terms as $key => $term ) {
				if ( in_array( $term->term_id, $selected_category ) ) {
					return true;
				}
			}
			return false;
		}
	}

}
