<?php
/**
 * Plugin Name: Lower Price for WooCommerce
 * Description:  Your users can notify lower price for products which they have found in other sites/shops. The price can be matched by sending a coupon.
 * Version: 3.1.0
 * Author: Flintop
 * Author URI: https://woocommerce.com/vendor/flintop/
 * Text Domain: lower-price-for-woocommerce
 * Domain Path: /languages
 * Woo: 5678225:6e34b24aa47d4a8a20f86758648c6b02
 * Tested up to: 6.5
 * WC tested up to: 8.7.0
 * WC requires at least: 3.0
 * Copyright: © 2020 Flintop
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Requires Plugins: woocommerce
 *
 * @package Lower Price for WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/* Include once will help to avoid fatal error by load the files when you call init hook */
require_once ABSPATH . 'wp-admin/includes/plugin.php';

// Include main class file.
if ( ! class_exists( 'MMP_Guarntee_For_Woocommerce' ) ) {
	include_once 'inc/class-lower-price-for-woocommerce.php';
}

if ( ! function_exists( 'mmp_is_plugin_active' ) ) {

	/**
	 * Is plugin active?
	 *
	 * @return bool
	 */
	function mmp_is_plugin_active() {
		if ( mmp_is_valid_wordpress_version() && mmp_is_woocommerce_active() && mmp_is_valid_woocommerce_version() ) {
			return true;
		}

		add_action( 'admin_notices', 'mmp_display_warning_message' );

		return false;
	}
}

if ( ! function_exists( 'mmp_is_woocommerce_active' ) ) {

	/**
	 * Function to check whether WooCommerce is active or not.
	 *
	 * @return bool
	 */
	function mmp_is_woocommerce_active() {
		$return = true;
		// This condition is for multi site installation.
		if ( is_multisite() && ! is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) && ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$return = false;
			// This condition is for single site installation.
		} elseif ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$return = false;
		}

		return $return;
	}
}

if ( ! function_exists( 'mmp_is_valid_wordpress_version' ) ) {

	/**
	 * Is valid WordPress version?
	 *
	 * @return bool
	 */
	function mmp_is_valid_wordpress_version() {
		if ( version_compare( get_bloginfo( 'version' ), MMP_Guarntee_For_Woocommerce::$wp_minimum_version, '<' ) ) {
			return false;
		}

		return true;
	}
}

if ( ! function_exists( 'mmp_is_valid_woocommerce_version' ) ) {

	/**
	 * Is valid WooCommerce version?
	 *
	 * @return bool
	 */
	function mmp_is_valid_woocommerce_version() {
		if ( version_compare( get_option( 'woocommerce_version' ), MMP_Guarntee_For_Woocommerce::$wc_minimum_version, '<' ) ) {
			return false;
		}

		return true;
	}
}

if ( ! function_exists( 'mmp_display_warning_message' ) ) {

	/**
	 * Display the WooCommere is not active warning message.
	 *
	 * @since 1.0
	 */
	function mmp_display_warning_message() {
		$notice = '';

		if ( ! mmp_is_valid_wordpress_version() ) {
			$notice = sprintf( 'This version of Lower Price for WooCommerce requires WordPress %1s or newer.', MMP_Guarntee_For_Woocommerce::$wp_minimum_version );
		} elseif ( ! mmp_is_woocommerce_active() ) {
			$notice = 'Lower Price for WooCommerce Plugin will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin.';
		} elseif ( ! mmp_is_valid_woocommerce_version() ) {
			$notice = sprintf( 'This version of Lower Price for WooCommerce requires WooCommerce %1s or newer.', MMP_Guarntee_For_Woocommerce::$wc_minimum_version );
		}

		if ( $notice ) {
			echo '<div class="error">';
			echo '<p>' . wp_kses_post( $notice ) . '</p>';
			echo '</div>';
		}
	}
}

// Check WooCommerce plugin is active.
if ( ! mmp_is_plugin_active() ) {
	return;
}


add_action(
	'before_woocommerce_init',
	function () {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);

// Define constant.
if ( ! defined( 'MMP_PLUGIN_FILE' ) ) {
	define( 'MMP_PLUGIN_FILE', __FILE__ );
}

// Return Lower Price class object.
if ( ! function_exists( 'mmp' ) ) {
	/**
	 * Lower Price class
	 *
	 * @version 1.0.0
	 */
	function mmp() {
		return MMP_Guarntee_For_Woocommerce::instance();
	}
}

// initialize the plugin.
mmp();
