<?php
/**
 * This template displays contents inside form fields
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/lower-price-for-woocommerce.php
 *
 * To maintain compatibility, Lower Price for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}

switch ( $form_field->get_field_type() ) {

	case 'text':
	case 'email':
		if ( is_user_logged_in() && in_array( $form_field->get_field_name() , array( 'mmp_mail', 'mmp_name' )) ) {
			$user        = get_userdata( get_current_user_id() ) ;
			$customer_email  = $user->user_email ;
			$customer_name   = $user->display_name ;
			if ( 'mmp_mail' == $form_field->get_field_name() ) {
			
				?>
				<input type="hidden" id="<?php echo esc_attr($form_field->get_field_name()); ?>" class="<?php echo esc_attr($form_field->get_field_name()); ?>" name="<?php echo esc_attr($form_field->get_field_name()); ?>" value="<?php echo esc_attr($customer_email); ?>">
				<?php
			}
			if ( 'mmp_name' == $form_field->get_field_name() ) {
				?>
				 <input type="hidden" id="<?php echo esc_attr($form_field->get_field_name()); ?>" class="<?php echo esc_attr($form_field->get_field_name()); ?>" name="<?php echo esc_attr($form_field->get_field_name()); ?>" value="<?php echo esc_attr($customer_name); ?>">
				<?php
			} 
		} else {
			?>
		<p class="<?php echo esc_attr($class_name) ; ?>">
			<label for="<?php echo esc_attr($form_field->get_field_name()) ; ?>"><?php echo esc_attr($form_field->get_field_label()) ; ?>
				<?php 
				if ( 'yes' == $form_field->get_field_mandatory() ) {
					?>
					 <span class="required">*</span><?php } ?>
			</label>
			<input type="<?php echo esc_attr($form_field->get_field_type()) ; ?>"
				   class="input-text <?php echo esc_attr($form_field->get_field_name()); ?>" name="<?php echo esc_attr($form_field->get_field_name()) ; ?>" 
				   id="<?php echo esc_attr($form_field->get_field_name()) ; ?>"
				   placeholder="<?php echo esc_attr($form_field->get_field_placeholder()) ; ?>" />
		</p>
			<?php
		}
		break ;
	case 'number':
		?>
		 
		<p class="<?php echo esc_attr($class_name) ; ?>">
			<label for="<?php echo esc_attr($form_field->get_field_name()) ; ?>"><?php echo esc_attr($form_field->get_field_label()) ; ?>
				<?php 
				if ( 'yes' == $form_field->get_field_mandatory() ) {
					?>
					 <span class="required">*</span><?php } ?>
			</label>
			<?php 
			if ( 'mmp_pref_price' == $form_field->get_field_name() ) {
				echo wp_kses_post(get_woocommerce_currency_symbol());
			}
			?>
			<input type="<?php echo esc_attr($form_field->get_field_type()) ; ?>" min="0" step="0.01"
				   class="input-text" name="<?php echo esc_attr($form_field->get_field_name()) ; ?>" 
				   id="<?php echo esc_attr($form_field->get_field_name()) ; ?>"
				   placeholder="<?php echo esc_attr($form_field->get_field_placeholder()) ; ?>"  />
		</p>
		<?php
		break ;

	case 'textarea':
		?>
		<p class="<?php echo esc_attr($class_name) ; ?>">
			<label for="<?php echo esc_attr($form_field->get_field_name()) ; ?>"><?php echo esc_attr($form_field->get_field_label()) ; ?>
				<?php 
				if ( 'yes' == $form_field->get_field_mandatory() ) {
					?>
					 <span class="required">*</span><?php } ?>
			</label>
			<textarea class="input-text" name="<?php echo esc_attr( $form_field->get_field_name()) ; ?>"
					  id="<?php echo esc_attr($form_field->get_field_name()) ; ?>"
					  placeholder="<?php echo esc_attr($form_field->get_field_placeholder()) ; ?>" ></textarea>
		</p>
		<?php
}
