<?php
/**
 * This template displays contents inside Price table
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/lower-price-for-woocommerce.php
 *
 * To maintain compatibility, Lower Price for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
/**
 * Before product list.
 * 
 * @since 1.0
 */
do_action( 'mmp_before_product_list', $product_ids ) ;

$columns = array(
	get_option( 'mmp_localization_pro_name' ),
	get_option( 'mmp_localization_org_price' ),
	get_option( 'mmp_localization_report_price' ),
	get_option( 'mmp_localization_offered_price' ),
	get_option( 'mmp_localization_status' ),
	get_option( 'mmp_localization_coupon_code' ),
	get_option( 'mmp_localization_expiry_date' ),
	get_option( 'mmp_localization_lst_activity' ),
		) ;
?>
<h2><?php echo esc_html( get_option( 'mmp_localization_my_account_label' ) ) ; ?></h2>
<table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table mmp-price-list-table mmp-list-table" cellspacing="0">
	<thead>
		<tr> 
			<?php foreach ( $columns as $each_columns ) { ?>
				<th><?php echo esc_html( $each_columns ) ; ?></th>
			<?php } ?>
		</tr>
	</thead>
	<tbody>
		<?php mmp_get_template( 'mmp-price-list-data.php', array( 'product_ids' => $product_ids, 'permalink' => get_permalink() ) ) ; ?>
	</tbody>
	<?php if ( $pagination[ 'page_count' ] > 1 ) : ?>
		<tfoot>
			<tr>
				<td colspan="<?php echo esc_attr( count( $columns ) ) ; ?>" class="footable-visible">
					<?php mmp_get_template( 'pagination.php', $pagination ) ; ?>
				</td>
			</tr>
		</tfoot>
	<?php endif ; ?>
</table>

<?php
/**
 * After product list.
 * 
 * @since 1.0
 */
do_action( 'mmp_after_product_list', $product_ids ) ;
