<?php

/**
 * Advanced Tab.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( class_exists( 'MMP_Advanced_Tab' ) ) {
	return new MMP_Advanced_Tab() ;
}

/**
 * MMP_Advanced_Tab.
 */
class MMP_Advanced_Tab extends MMP_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'advanced' ;
		$this->label = esc_html__( 'Advanced', 'lower-price-for-woocommerce' ) ;

		parent::__construct() ;
	}

	/**
	 * Output the Advance Tab content.
	 */
	public function advanced_section_array() {

		return array(
			array(
				'type'   => 'title',
				'title'  => __( 'Restriction Settings', 'lower-price-for-woocommerce' ),
				'id'     => 'mmp_restriction_section',
			),
			array(
				'title'      => esc_html__( 'Show the Lower Price Notifier Link for', 'lower-price-for-woocommerce' ),
				'type'       => 'select',
				'options'    => array(
					'1'  => esc_html__( 'All user(s)', 'lower-price-for-woocommerce' ),
					'2'  => esc_html__( 'Included user(s)', 'lower-price-for-woocommerce' ),
					'3'  => esc_html__( 'Excluded user(s)', 'lower-price-for-woocommerce' ),
					'4'  => esc_html__( 'Included User Role(s)', 'lower-price-for-woocommerce' ),
					'5'  => esc_html__( 'Excluded User Role(s)', 'lower-price-for-woocommerce' ),
				),
				'desc_tip'   => true,
				'desc'       => esc_html__( 'The Lower Price Notifer Form will be displayed for the selected users/user roles', 'lower-price-for-woocommerce' ),
				'default'    => '1',
				'id'         => $this->get_option_key( 'user_roles_users' ),
			), array(
				'title'          => esc_html__( 'Select User(s) to Include', 'lower-price-for-woocommerce' ),
				'id'             => $this->get_option_key( 'included_user' ),
				'class'          => 'mmp_customers_roles_search',
				'action'         => 'mmp_customers_search',
				'type'           => 'mmp_custom_fields',
				'list_type'      => 'customers',
				'mmp_field'      => 'ajaxmultiselect',
				'placeholder'    => esc_html__( 'Select a User', 'lower-price-for-woocommerce' ),
				'allow_clear'    => true,
			),
			array(
				'title'          => esc_html__( 'Select User(s) to Exclude', 'lower-price-for-woocommerce' ),
				'id'             => $this->get_option_key( 'exclude_user' ),
				'class'          => 'mmp_customers_roles_search',
				'action'         => 'mmp_customers_search',
				'type'           => 'mmp_custom_fields',
				'list_type'      => 'customers',
				'mmp_field'      => 'ajaxmultiselect',
				'placeholder'    => esc_html__( 'Select a User', 'lower-price-for-woocommerce' ),
				'allow_clear'    => true,
			),
			array(
				'title'      => esc_html__( 'Select User role(s) to Include', 'lower-price-for-woocommerce' ),
				'type'       => 'multiselect',
				'class'      => 'mmp_select2 mmp_customers_roles_search',
				'options'    => mmp_get_user_roles(),
				'id'         => $this->get_option_key( 'included_user_role' ),
			),
			array(
				'title'      => esc_html__( 'Select User role(s) to Exclude', 'lower-price-for-woocommerce' ),
				'type'       => 'multiselect',
				'class'      => 'mmp_select2 mmp_customers_roles_search',
				'options'    => mmp_get_user_roles(),
				'id'         => $this->get_option_key( 'excluded_user_role' ),
			),
			array(
				'title'      => esc_html__( 'Hide Lower Price Notifier Link for Guest Users', 'lower-price-for-woocommerce' ),
				'type'       => 'checkbox',
				'id'         => $this->get_option_key( 'link_guest_hide' ),
				'default'    => 'no',
			),
			array(
				'title'      => esc_html__( 'Restrict Users to Notify Price Difference Once Per Product', 'lower-price-for-woocommerce' ),
				'type'       => 'checkbox',
				'id'         => $this->get_option_key( 'per_product_restriction' ),
				'desc_tip'   => true,
				'desc'       => esc_html__( ' When enabled, users will not be able to notify about a price difference for a product more than once.', 'lower-price-for-woocommerce' ),
			),
			array(
				'title'      => esc_html__( 'Enable Price Difference Notification Restriction Per User', 'lower-price-for-woocommerce' ),
				'type'       => 'checkbox',
				'id'         => $this->get_option_key( 'overall_product_restriction' ),
				'desc_tip'   => true,
				'desc'       => esc_html__( 'When enabled, your users will not be able to notify about a price difference more than the specified number of times.', 'lower-price-for-woocommerce' ),
			),
			array(
				'title'      => esc_html__( 'Restriction Count', 'lower-price-for-woocommerce' ),
				'type'       => 'text',
				'id'         => $this->get_option_key( 'pro_restriction_val' ),
				'desc_tip'   => true,
				'desc'       => esc_html__( ' Your users will not be able to notify about a price difference more than the specified number of times.', 'lower-price-for-woocommerce' ),
			),
			array(
				'type'   => 'sectionend',
				'id'     => 'mmp_restriction_section',
			),
			array(
				'type'   => 'title',
				'title'  => __( 'CSS Settings', 'lower-price-for-woocommerce' ),
				'id'     => 'mmp_css_section',
			),
			array(
				'title'      => __( 'Custom CSS', 'lower-price-for-woocommerce' ),
				'id'         => $this->get_option_key( 'custom_css' ),
				'type'       => 'textarea',
				'default'    => '',
			),
			array(
				'type'   => 'sectionend',
				'id'     => 'mmp_css_section',
			),
				) ;
	}
}

return new MMP_Advanced_Tab() ;
