<?php
/**
 * General Tab.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( class_exists( 'MMP_General_Tab' ) ) {
	return new MMP_General_Tab();
}

/**
 * MMP_General_Tab.
 */
class MMP_General_Tab extends MMP_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'general';
		$this->label = esc_html__( 'General', 'lower-price-for-woocommerce' );
		parent::__construct();
	}

	/**
	 * Output the General Tab content.
	 */
	public function general_section_array() {

		return array(
			array(
				'type'  => 'title',
				'title' => __( 'General Settings', 'lower-price-for-woocommerce' ),
				'id'    => 'mmp_general_section',
			),
			array(
				'title'    => esc_html__( 'Display Lower Price Notifier Link for Products', 'lower-price-for-woocommerce' ),
				'type'     => 'checkbox',
				'default'  => 'no',
				'id'       => $this->get_option_key( 'mmp_enable' ),
				'desc'     => esc_html__( 'When enabled, your customers will be presented with a link to the form on the Single Product Pages. From there, they can report about the lower price which they have found elsewhere.', 'lower-price-for-woocommerce' ),
				'desc_tip' => true,
			),
			array(
				'title'    => esc_html__( 'Lower Price Notifier Link will be displayed for', 'lower-price-for-woocommerce' ),
				'type'     => 'select',
				'options'  => array(
					'1' => esc_html__( 'All Product (s)', 'lower-price-for-woocommerce' ),
					'2' => esc_html__( 'Include Product(s)', 'lower-price-for-woocommerce' ),
					'3' => esc_html__( 'Exclude Product(s)', 'lower-price-for-woocommerce' ),
					'5' => esc_html__( 'Include Categories', 'lower-price-for-woocommerce' ),
					'6' => esc_html__( 'Exclude Categories', 'lower-price-for-woocommerce' ),
				),
				'desc_tip' => true,
				'desc'     => esc_html__( 'The Lower Price Notifier Link will be displayed for the selected products/Categories', 'lower-price-for-woocommerce' ),
				'default'  => '1',
				'id'       => $this->get_option_key( 'product_category' ),
			),
			array(
				'title'       => esc_html__( 'Select Product(s) to Include', 'lower-price-for-woocommerce' ),
				'id'          => $this->get_option_key( 'included_product' ),
				'class'       => 'mmp_product_cat_search_fields',
				'action'      => 'mmp_products_and_variations_search',
				'type'        => 'mmp_custom_fields',
				'list_type'   => 'products',
				'mmp_field'   => 'ajaxmultiselect',
				'desc_tip'    => true,
				'desc'        => esc_html__( 'You can also choose multiple products', 'lower-price-for-woocommerce' ),
				'placeholder' => esc_html__( 'Select a Product', 'lower-price-for-woocommerce' ),
				'allow_clear' => true,
				'default'     => array(),
			),
			array(
				'title'       => esc_html__( 'Select Product(s) to Exclude', 'lower-price-for-woocommerce' ),
				'id'          => $this->get_option_key( 'exclude_product' ),
				'class'       => 'mmp_product_cat_search_fields',
				'action'      => 'mmp_products_and_variations_search',
				'type'        => 'mmp_custom_fields',
				'list_type'   => 'products',
				'mmp_field'   => 'ajaxmultiselect',
				'desc_tip'    => true,
				'desc'        => esc_html__( 'You can also choose multiple products', 'lower-price-for-woocommerce' ),
				'placeholder' => esc_html__( 'Select a Product', 'lower-price-for-woocommerce' ),
				'allow_clear' => true,
				'default'     => array(),
			),
			array(
				'title'    => esc_html__( 'Select Categories to Include', 'lower-price-for-woocommerce' ),
				'type'     => 'multiselect',
				'multiple' => false,
				'class'    => 'mmp_select2 mmp_product_cat_search_fields',
				'options'  => mmp_get_wc_categories(),
				'id'       => $this->get_option_key( 'included_category' ),
				'default'  => array(),
			),
			array(
				'title'    => esc_html__( 'Select Categories to Exclude', 'lower-price-for-woocommerce' ),
				'type'     => 'multiselect',
				'multiple' => false,
				'class'    => 'mmp_select2 mmp_product_cat_search_fields',
				'options'  => mmp_get_wc_categories(),
				'id'       => $this->get_option_key( 'exclude_category' ),
				'default'  => array(),
			),
			array(
				'title'    => esc_html__( 'Mode of Operation', 'lower-price-for-woocommerce' ),
				'type'     => 'select',
				'options'  => array(
					'mmp_feedback'    => esc_html__( 'Feedback', 'lower-price-for-woocommerce' ),
					'mmp_coupon_send' => esc_html__( 'Send Coupon', 'lower-price-for-woocommerce' ),
					'mmp_auto_apply'  => esc_html__( 'Auto Apply Coupon', 'lower-price-for-woocommerce' ),
				),
				'default'  => 'mmp_feedback',
				'id'       => $this->get_option_key( 'mode_of_operaton' ),
				'desc_tip' => true,
				'desc'     => esc_html__(
					'*Feedback - The user will be sent an acknowledgement email about their intimation <br>
*Send Coupon - Site Admin can choose to send a coupon code to the user to purchase the product at a lesser price <br>
*Auto Apply Coupon - Site Admin can choose to send a link to the user which when clicked, the product along with the coupon will be added to the cart',
					'lower-price-for-woocommerce'
				),
			),
			array(
				'title'   => __( 'Coupon Validity in Days', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'coupon_validity' ),
				'type'    => 'text',
				'default' => 30,
			),
			array(
				'title'    => esc_html__( 'Lower Price Notifier Link for Variable Product', 'lower-price-for-woocommerce' ),
				'type'     => 'checkbox',
				'desc'     => esc_html__( 'By enabling this checkbox, you can display the link for variable products without selecting the variation.', 'lower-price-for-woocommerce' ),
				'desc_tip' => true,
				'default'  => '1',
				'id'       => $this->get_option_key( 'display_var_show' ),
			),
			array(
				'title'    => esc_html__( 'Lower Price Notifier Link Position for Simple Product', 'lower-price-for-woocommerce' ),
				'type'     => 'select',
				'options'  => array(
					'woocommerce_before_add_to_cart_form'  => esc_html__( 'Before Add to Cart Form', 'lower-price-for-woocommerce' ),
					'woocommerce_after_add_to_cart_form'   => esc_html__( 'After Add to Cart Form', 'lower-price-for-woocommerce' ),
					'woocommerce_before_add_to_cart_button' => esc_html__( 'Before Add to Cart Button', 'lower-price-for-woocommerce' ),
					'woocommerce_after_add_to_cart_button' => esc_html__( 'After Add to Cart Button', 'lower-price-for-woocommerce' ),
					'woocommerce_before_add_to_cart_quantity' => esc_html__( 'Before Add to Cart Quantity', 'lower-price-for-woocommerce' ),
					'woocommerce_after_add_to_cart_quantity' => esc_html__( 'After Add to Cart Quantity', 'lower-price-for-woocommerce' ),
					'woocommerce_single_product_summary'   => esc_html__( 'Single Product Summary', 'lower-price-for-woocommerce' ),
					'custom'                               => esc_html__( 'Custom Hook', 'lower-price-for-woocommerce' ),
				),
				'desc_tip' => true,
				'desc'     => esc_html__( 'Lower Price Notifier Link will be displayed based on the selected hook for Simple Product.', 'lower-price-for-woocommerce' ),
				'default'  => 'woocommerce_before_add_to_cart_form',
				'id'       => $this->get_option_key( 'form_position' ),
			),
			array(
				'title'   => __( 'Custom Hook for Simple Product', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'form_position_custom_hook' ),
				'type'    => 'text',
				'default' => 'woocommerce_before_add_to_cart_form',
			),
			array(
				'title'             => __( 'Hook Priority for Simple Product', 'lower-price-for-woocommerce' ),
				'id'                => $this->get_option_key( 'form_position_hook_priority' ),
				'type'              => 'number',
				'default'           => 10,
				'custom_attributes' => array( 'min' => 1 ),
			),
			array(
				'title'    => esc_html__( 'Lower Price Notifier Link Position for Variable Product', 'lower-price-for-woocommerce' ),
				'type'     => 'select',
				'options'  => array(
					'woocommerce_after_variations_table'  => esc_html__( 'After Variations Table', 'lower-price-for-woocommerce' ),
					'woocommerce_before_single_variation' => esc_html__( 'Before Single Variation', 'lower-price-for-woocommerce' ),
					'woocommerce_single_variation'        => esc_html__( 'Single Variation', 'lower-price-for-woocommerce' ),
					'woocommerce_after_single_variation'  => esc_html__( 'After Single Variation', 'lower-price-for-woocommerce' ),
					'woocommerce_after_variations_form'   => esc_html__( 'After Variations Form', 'lower-price-for-woocommerce' ),
					'custom'                              => esc_html__( 'Custom', 'lower-price-for-woocommerce' ),
				),
				'desc_tip' => true,
				'desc'     => esc_html__( 'Lower Price Notifier Link will be displayed based on the selected hook for Variable Product', 'lower-price-for-woocommerce' ),
				'default'  => 'woocommerce_single_variation',
				'id'       => $this->get_option_key( 'form_position_variable' ),
			),
			array(
				'title'   => __( 'Custom Hook for Variable Product', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'form_position_variable_custom_hook' ),
				'type'    => 'text',
				'default' => 'woocommerce_single_variation',
			),
			array(
				'title'             => __( 'Hook Priority for Variable Product', 'lower-price-for-woocommerce' ),
				'id'                => $this->get_option_key( 'form_position_variable_hook_priority' ),
				'type'              => 'number',
				'default'           => 10,
				'custom_attributes' => array( 'min' => 1 ),
			),
			array(
				'type' => 'sectionend',
				'id'   => 'mmp_general_section',
			),
			array(
				'type'  => 'title',
				'title' => __( 'Coupon Settings', 'lower-price-for-woocommerce' ),
				'id'    => 'mmp_coupon_section',
			),
			array(
				'title'   => __( 'Prefix', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'coupon_preffix' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'title'   => __( 'Suffix', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'coupon_suffix' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'title'   => esc_html__( 'Code Type', 'lower-price-for-woocommerce' ),
				'type'    => 'select',
				'options' => array(
					'1' => esc_html__( 'Alphanumeric', 'lower-price-for-woocommerce' ),
					'2' => esc_html__( 'Numeric', 'lower-price-for-woocommerce' ),
				),
				'default' => '1',
				'id'      => $this->get_option_key( 'coupon_type' ),
			),
			array(
				'title'    => __( 'Exclude Alphabets from Code Creation', 'lower-price-for-woocommerce' ),
				'id'       => $this->get_option_key( 'coupon_name_type' ),
				'type'     => 'text',
				'default'  => '',
				'desc_tip' => true,
				'desc'     => 'Enter Alphabets separated by comma(eg: i, j, k)',
			),
			array(
				'title'   => __( 'Coupon Code Length', 'lower-price-for-woocommerce' ),
				'id'      => $this->get_option_key( 'coupon_length' ),
				'type'    => 'text',
				'default' => '8',
			),
			array(
				'title'    => esc_html__( 'Individual Use Only', 'lower-price-for-woocommerce' ),
				'type'     => 'checkbox',
				'default'  => 'yes',
				'id'       => $this->get_option_key( 'indvidual_use' ),
				'desc'     => esc_html__( 'By enabling this checkbox, the coupon created by this plugin cannot be used in conjunction with other coupons.', 'lower-price-for-woocommerce' ),
				'desc_tip' => true,
			),

			array(
				'type' => 'sectionend',
				'id'   => 'mmp_coupon_customize_section',
			),
			array(
				'type' => 'sectionend',
				'id'   => 'mmp_coupon_section',
			),
		);
	}
}

	return new MMP_General_Tab();
