<?php
/**
 * Compatibility Instances Class.
 * 
 * @package Lower Price/Compatibility
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('MMP_Compatibility_Instances')) {

	/**
	 * Class MMP_Compatibility_Instances
	 */
	class MMP_Compatibility_Instances {

		/**
		 * Compatibilities.
		 * 
		 * @var array
		 * */
		private static $compatibilities;

		/**
		 * Get Compatibilities.
		 * 
		 * @since 3.2.0
		 * @return array
		 */
		public static function instance() {
			if (is_null(self::$compatibilities)) {
				self::$compatibilities = self::load_compatibilities();
			}

			return self::$compatibilities;
		}

		/**
		 * Load all Compatibilities.
		 * 
		 * @since 3.2.0
		 */
		public static function load_compatibilities() {
			if (!class_exists('MMP_Abstract_Compatibility')) {
				include MMP_PLUGIN_PATH . '/inc/abstracts/class-mmp-abstract-compatibility.php';
			}

			$default_compatibility_classes = array(
				'mmp-wpml' => 'MMP_WPML_Compatibility',
			);

			foreach ($default_compatibility_classes as $file_name => $compatibility_class) {
				// Include file.
				include 'class-' . $file_name . '.php';

				// Add compatibility.
				self::add_compatibility(new $compatibility_class());
			}
		}

		/**
		 * Add a Compatibility.
		 * 
		 * @since 3.2.0
		 */
		public static function add_compatibility( $compatibility ) {
			self::$compatibilities[$compatibility->get_id()] = $compatibility;

			return new self();
		}

		/**
		 * Get compatibility by id.
		 * 
		 * @since 3.2.0
		 * @return Object
		 */
		public static function get_compatibility_by_id( $module_id ) {
			$compatibilities = self::instance();

			return isset($compatibilities[$compatibility_id]) ? $compatibilities[$compatibility_id] : false;
		}
	}

}
