<?php
/*
 * MMP Form Filed List
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Form_Fields_List' ) ) {

	/**
	 * MMP_Form_Fields_List Class.
	 */
	class MMP_Form_Fields_List extends MMP_Post {

		/**
		 * Post Type
		 */
		protected $post_type = MMP_Register_Post_Types::MMP_FORM_FIELDS_POSTTYPE ;

		/**
		 * Post Status
		 */
		protected $post_status = 'publish' ;
		
		/**
		 * Field Title
		 */
		protected $name ;

		/**
		* Field Name
		 */
		protected $mmp_field_name ;

		/**
		* Field Type
		 */
		protected $mmp_field_type ;

		/**
		* Field Place Holder
		 */
		protected $mmp_field_placeholder ;

		/**
		* Field Mandatory
		 */
		protected $mmp_field_mandatory ;

		/**
		 * Meta data keys
		 */
		protected $meta_data_keys = array(  
			'mmp_field_name'         => '',
			'mmp_field_type'         => '',
			'mmp_field_placeholder'  => '',
			'mmp_field_mandatory'    => '',
		) ;

		/**
		 * Prepare extra post data
		 */
		protected function load_extra_postdata() {
			$this->name = $this->post->post_title ;
		}

		/**
		 * Setters and Getters
		 */

		/**
		 * Set Field Name
		 */
		public function set_field_name( $value ) {
			$this->mmp_field_name = $value ;
		}

		/**
		 * Set Field Type
		 */
		public function set_field_type( $value ) {
			$this->mmp_field_type = $value ;
		}

		/**
		 * Set Field Place Holder
		 */
		public function set_field_placeholder( $value ) {
			$this->mmp_field_placeholder = $value ;
		}

		/**
		 * Set Field Mandatory
		 */
		public function set_field_mandatory( $value ) {
			$this->mmp_field_mandatory = $value ;
		}

		/**
		 * Get Field Name
		 */
		public function get_field_name() {
			return $this->mmp_field_name ;
		}

		/**
		 * Set Field label
		 */
		public function get_field_label() {
			return $this->post->post_title;
		}

		/**
		 * Get Field Type
		 */
		public function get_field_type() {
			return $this->mmp_field_type ;
		}

		/**
		 * Get Field Place Holder
		 */
		public function get_field_placeholder() { 
			return $this->mmp_field_placeholder ;
		}

		/**
		 * Get Field Place Mandatory
		 */
		public function get_field_mandatory() { 
			return $this->mmp_field_mandatory ;
		}
	}
}
