/* global mmp_custom_field_params */

jQuery(
	function ($) {
		'use strict';

		function is_blocked($node) {
			return $node.is('.processing') || $node.parents('.processing').length;
		}

		function block($node) {
			$.blockUI.defaults.overlayCSS.cursor = 'wait';

			if (!is_blocked($node)) {
				$node.addClass('processing').block(
					{
						message: null,
						overlayCSS: {
							background: '#fff',
							opacity: 0.6
						}
					}
				);
			}
		}

		function unblock($node) {
			$node.removeClass('processing').unblock();
		}

		function formatUrl(url) {
			if (-1 === url.indexOf('https://') || -1 === url.indexOf('http://')) {
				return url;
			} else {
				return decodeURI(url);
			}
		}

		var customField = {
			init: function () {
				$(document).on('click', '.mmp-custom-field-preview', this.customFieldPreview);
				$(document).on('click', 'body.' + mmp_custom_field_params.mmp_screen_id + ' a.mmp-custom-field-add-btn', this.render);
				$(document).on('click', 'body.' + mmp_custom_field_params.mmp_screen_id + ' a.mmp-custom-field-edit-btn', this.renderEdit);
				$(document.body).on('wc_backbone_modal_loaded', this.backbone.init);
				//Delete Confirmation 
				$(document).on('click', '.mmp-delete-custom-field', this.deleteConfirmation);
			},
			deleteConfirmation(e) {
				if (!confirm(mmp_custom_field_params.delete_confirm_message)) {
					e.preventDefault();
				}
			},
			customFieldPreview(e) {
				e.preventDefault();
				var $previewButton = $(this),
					$customFieldId = $previewButton.data('custom_field_id');

				if ($previewButton.data('mmp-custom-field-data')) {
					$(this).WCBackboneModal(
						{
							template: 'mmp-modal-view-custom-field',
							variable: $previewButton.data('customFieldData')
						}
					);

					return false;
				} else {
					$previewButton.addClass('disabled');

					$.ajax(
						{
							type: 'GET',
							url: ajaxurl,
							dataType: 'json',
							data: {
								action: 'mmp_get_custom_field_details',
								custom_field_id: $customFieldId,
								security: mmp_custom_field_params.custom_field_preview_nonce
							},
							success(response) {
								$('.mmp-custom-field-preview').removeClass('disabled');

								if (response.success) {
									$previewButton.data('customFieldData', response.data);

									$(this).WCBackboneModal(
										{
											template: 'mmp-modal-view-custom-field',
											variable: response.data
										}
									);
								}
							}
						}
					);
				}
			},

			render(e) {
				e.preventDefault();

				$(this).WCBackboneModal(
					{
						template: 'mmp-modal-add-custom-field',
					}
				);

				return false;
			},

			renderEdit(e) {
				e.preventDefault();
				var $editButton = $(this),
					$customFieldId = $editButton.data('custom_field_id');

				if ($editButton.data('mmp-custom-field-data')) {
					$(this).WCBackboneModal(
						{
							template: 'mmp-modal-edit-custom-field',
							variable: $editButton.data('customFieldData')
						}
					);

					return false;
				} else {
					$editButton.addClass('disabled');

					$.ajax(
						{
							type: 'GET',
							url: ajaxurl,
							dataType: 'json',
							data: {
								action: 'mmp_get_custom_field_data',
								custom_field_id: $customFieldId,
								security: mmp_custom_field_params.custom_field_data_nonce
							},
							success(response) {
								$('.mmp-custom-field-edit-btn').removeClass('disabled');

								if (response.success) {
									$editButton.data('customFieldData', response.data);

									$(this).WCBackboneModal(
										{
											template: 'mmp-modal-edit-custom-field',
											variable: response.data
										}
									);
								}
							}
						}
					);
				}
			},

			backbone: {
				init(e, target) {
					if ($.inArray(target, ['mmp-modal-add-custom-field', 'mmp-modal-edit-custom-field']) !== -1) {
						$(document.body).trigger('mmp-enhanced-init');

						$('div.' + target + '-wrapper').on('input change', '.mmp-required-field', customField.backbone.validateRequiredField)
							.find('.mmp-required-field').change();

						$('div.' + target + '-wrapper').on('change', '.mmp-custom-field-type', customField.backbone.customFieldType)
							.find('.mmp-custom-field-type').change();

						$('div.' + target + '-wrapper').on('click', '.mmp-add-custom-field', customField.backbone.add);
						$('div.' + target + '-wrapper').on('click', '.mmp-update-custom-field', customField.backbone.update);
						customField.backbone.onLoad();
					}
				},

				onLoad() {
					var wrapper = $('.mmp-modal-edit-custom-field-wrapper'),
						fieldType = wrapper.find('.mmp-c-field-type').val(),
						fieldValue = wrapper.find('.mmp-c-field-name').val();

					if (wrapper.length > 0) {
						if ('default' === fieldType) {
							wrapper.find('p.mmp-fields').hide();

							if ('mmp_number' === fieldValue) {
								wrapper.find('.mmp-required-attr-field').closest('p').show();
								wrapper.find('.mmp-custom-field-status').closest('p').show();
							}

							wrapper.find('.mmp-placeholder-field').closest('p').show();
							wrapper.find('.mmp-label-field').closest('p').show();
						}
					}
				},

				validateRequiredField() {
					var display = false,
						wrapper = $('.mmp-modal-add-custom-field-wrapper'),
						button = wrapper.find('.mmp-add-custom-field');

					if (wrapper.length === 0) {
						wrapper = $('.mmp-modal-edit-custom-field-wrapper');
						button = wrapper.find('.mmp-update-custom-field');
					}

					wrapper.find('.mmp-required-field').filter(':visible').each(
						function () {
							if ('' === $(this).val() || null === $(this).val()) {
								display = false;
								return false;
							} else {
								display = true;
							}
						}
					);

				if (true === display) {
					button.show();
				} else {
					button.hide();
				}
				},

				customFieldType(e) {
					e.preventDefault();

					var $this = $(e.currentTarget),
						wrapper = $this.closest('.mmp-modal-add-custom-field-wrapper');

					if (wrapper.length === 0) {
						wrapper = $this.closest('.mmp-modal-edit-custom-field-wrapper');
					}

					wrapper.find('.mmp-error').html('');
					wrapper.find('p.mmp-add-custom-fields').hide();

					if ('dropdown' === $(this).val()) {
						wrapper.find('p.mmp-dropdown-field').show();
					} else if ('text' === $(this).val() || 'email' === $(this).val()) {
						wrapper.find('p.mmp-text-field').show();
					} else if ('number' === $(this).val()) {
						wrapper.find('p.mmp-number-field').show();
					} else if ('radio' === $(this).val()) {
						wrapper.find('p.mmp-radio-field').show();
					} else if ('checkbox' === $(this).val()) {
						wrapper.find('p.mmp-checkbox-field').show();
					} else if ('textarea' === $(this).val()) {
						wrapper.find('p.mmp-text-area-field').show();
					}

					customField.backbone.validateRequiredField();
				},

				add(e) {
					e.preventDefault();

					var $this = $(e.currentTarget),
						wrapper = $this.closest('.mmp-modal-add-custom-field-wrapper'),
						form_data = {
							label: wrapper.find('.mmp-label-field').val(),
							custom_field_type: wrapper.find('.mmp-custom-field-type').val(),
							name: wrapper.find('.mmp-name-field').val(),
							id_attr: wrapper.find('.mmp-id-field').val(),
							class_attr: wrapper.find('.mmp-class-field').val(),
							data_attr: wrapper.find('.mmp-data-attr-field').val(),
							default_attr: wrapper.find('.mmp-default-field').val(),
							option_attr: wrapper.find('.mmp-options-field').val(),
							multiple_attr: (true === wrapper.find('.mmp-multiple-field').is(':checked')) ? 'yes' : 'no',
							min_attr: wrapper.find('.mmp-min-field').val(),
							max_attr: wrapper.find('.mmp-max-field').val(),
							step_attr: wrapper.find('.mmp-step-field').val(),
							rows_attr: wrapper.find('.mmp-rows-field').val(),
							cols_attr: wrapper.find('.mmp-cols-field').val(),
							placeholder_attr: wrapper.find('.mmp-placeholder-field').val(),
							required: (true === wrapper.find('.mmp-required-attr-field').is(':checked')) ? 'yes' : 'no',
							tool_tip_attr: wrapper.find('.mmp-tool-tip-field').val()
					};

					block($this.closest('.wc-backbone-modal-content'));

					$.ajax(
						{
							type: 'POST',
							url: ajaxurl,
							dataType: 'json',
							data: {
								action: 'mmp_add_custom_field',
								security: mmp_custom_field_params.add_custom_field_nonce,
								form_data: form_data,
								status: wrapper.find('.mmp-custom-field-status').val(),
							},
							success: function (response) {
								if (response.success) {
									window.alert(mmp_custom_field_params.custom_field_created_msg);
									window.location = formatUrl(response.data.redirect);
								} else {
									window.alert(response.data.error);
								}
							},
							complete: function () {
								unblock($this.closest('.wc-backbone-modal-content'));
							}
						}
					);
				},

				update(e) {
					e.preventDefault();

					var $this = $(e.currentTarget),
						wrapper = $this.closest('.mmp-modal-edit-custom-field-wrapper'),
						form_data = {
							label: wrapper.find('.mmp-label-field').val(),
							custom_field_id: wrapper.find('.mmp-custom-field-id').val(),
							custom_field_type: wrapper.find('.mmp-custom-field-type').val(),
							name: wrapper.find('.mmp-name-field').val(),
							id_attr: wrapper.find('.mmp-id-field').val(),
							class_attr: wrapper.find('.mmp-class-field').val(),
							data_attr: wrapper.find('.mmp-data-attr-field').val(),
							default_attr: wrapper.find('.mmp-default-field').val(),
							option_attr: wrapper.find('.mmp-options-field').val(),
							multiple_attr: (true === wrapper.find('.mmp-multiple-field').is(':checked')) ? 'yes' : 'no',
							min_attr: wrapper.find('.mmp-min-field').val(),
							max_attr: wrapper.find('.mmp-max-field').val(),
							step_attr: wrapper.find('.mmp-step-field').val(),
							rows_attr: wrapper.find('.mmp-rows-field').val(),
							cols_attr: wrapper.find('.mmp-cols-field').val(),
							placeholder_attr: wrapper.find('.mmp-placeholder-field').val(),
							required: (true === wrapper.find('.mmp-required-attr-field').is(':checked')) ? 'yes' : 'no',
							tool_tip_attr: wrapper.find('.mmp-tool-tip-field').val(),
							source_from: wrapper.find('.mmp-c-field-type').val(),
					};

					block($this.closest('.wc-backbone-modal-content'));

					$.ajax(
						{
							type: 'POST',
							url: ajaxurl,
							dataType: 'json',
							data: {
								action: 'mmp_update_custom_field',
								security: mmp_custom_field_params.update_custom_field_nonce,
								form_data: form_data,
								status: wrapper.find('.mmp-custom-field-status').val(),
							},
							success: function (response) {
								if (response.success) {
									window.alert(mmp_custom_field_params.custom_field_updated_msg);
									window.location = formatUrl(response.data.redirect);
								} else {
									window.alert(response.data.error);
								}
							},
							complete: function () {
								unblock($this.closest('.wc-backbone-modal-content'));
							}
						}
					);
				}
			}
		};

		customField.init();
	}
);
