/* global mmp_frontend_params */

/* MMP Settings */
jQuery(function ($) {

	// Field validation error tips
	$( document.body )
	.on(
		'mmp_add_error_tip',
		function (e, element, error_type) {
			var offset = element.position();

			if (element.parent().find( '.mmp-error-tip' ).length === 0) {
				element.after( '<span class="mmp-error-tip ' + error_type + '">' + mmp_frontend_params[error_type] + '</span>' );
				element.parent().find( '.mmp-error-tip' )
				.css(
					'left',
					offset.left +
					element.width() -
					element.width() / 2 -
					$( '.mmp-error-tip' ).width() / 2
				)
					.css( 'top', offset.top + element.height() )
					.fadeIn( '100' );
			}
		}
	)

	.on(
		'mmp_remove_error_tip',
		function (e, element, error_type) {
			element.parent().find( '.mmp-error-tip.' + error_type )
			.fadeOut(
				'100',
				function () {
					$( this ).remove();
				}
			);
		}
	)

	.on(
		'click',
		function () {
			$( '.mmp-error-tip' ).fadeOut(
				'100',
				function () {
					$( this ).remove();
				}
			);
		}
	)

	.on(
		'blur',
		'.mmp-price',
		function () {
			$( '.mmp-error-tip' ).fadeOut(
				'100',
				function () {
					$( this ).remove();
				}
			);
		}
	)

	.on(
		'change',
		'.mmp-price',
		function () {
			var regex,
			decimalRegex,
			decimalPoint = mmp_frontend_params.decimal_point;

			regex        = new RegExp( '[^-0-9%\\' + decimalPoint + ']+', 'gi' );
			decimalRegex = new RegExp( '\\' + decimalPoint + '+', 'gi' );

			var value    = $( this ).val();
			var newValue = value.replace( regex, '' ).replace( decimalRegex, decimalPoint );

			if (value !== newValue) {
				$( this ).val( newValue );
			}
		}
	)

	.on(
		'keyup',
		'.mmp-price',
		function () {
			var checkDecimalNumbers = true,
			regex                   = new RegExp( '[^-0-9%\\' + mmp_frontend_params.decimal_point + ']+', 'gi' ),
			decimalRegex            = new RegExp( '[^\\' + mmp_frontend_params.decimal_point + ']', 'gi' ),
			value                   = $( this ).val(),
			newValue                = value.replace( regex, '' );

			// Check if newValue have more than one decimal point.
			if (checkDecimalNumbers && 1 < newValue.replace( decimalRegex, '' ).length) {
				newValue = newValue.replace( decimalRegex, '' );
			}

			if (value !== newValue) {
				$( document.body ).triggerHandler( 'mmp_add_error_tip', [$( this ), 'decimal_error',] );
			} else {
				$( document.body ).triggerHandler( 'mmp_remove_error_tip', [$( this ), 'decimal_error',] );
			}
		}
	)

	var MMP_Frontend = {
		init: function () {
			//Form Submit
			$(document).on('click', '#mmp_form_save', this.formSubmit);

			$(document).on('found_variation.wc-variation-form', { variationForm: this }, this.onFoundVariation);
			if ('yes' == mmp_frontend_params.link_var_display) {
				$(document).on('change.wc-variation-form', '.variations select', { variationForm: this }, this.onNoneVariation);
			}
		},

		formSubmit(e){
			e.preventDefault();

			var wrapper = $(this).closest('div.mmp_popup_overall_wrapper');

			MMP_Frontend.block(wrapper);

			$.ajax(
				{
					type: 'POST',
					url: mmp_frontend_params.ajaxurl,
					dataType: 'json',
					data: {
						action: 'mmp_form_fields_save',
						form_data: wrapper.find('.mmp-form-fields').serialize(),
						mmp_security: mmp_frontend_params.mmp_form_nonce,
					},
					success(res) {
						if (true === res.success) {
							wrapper.find('#mmp_popup_form_wrapper').remove();
							wrapper.html(res.data.layout);
						} else {
							wrapper.find('#mmp_error').html(res.data.error);
							$("div.mmp_popup_overall_wrapper").animate({ scrollTop: 0 }, 500);
						}

						MMP_Frontend.unblock(wrapper);
					},
				}
			);
		},

		onNoneVariation: function (event) {
			var variation_id = $('input[name=variation_id]').val();

			if (variation_id == '0' || variation_id == '' || variation_id == undefined) {
				$(".mmp_variation_datas").html('');
				MMP_Frontend.block(".variations_form");
				//                $ ( ".mmp_simple_datas" ).show () ;
				var data = {
					action: "mmp_get_form_fields",
					mmp_post_id: mmp_frontend_params.post_id,
					mmp_security: mmp_frontend_params.mmp_form_nonce,
				}
				$.post(mmp_frontend_params.ajaxurl, data, function (response) {
					if (response.success) {
						$(".mmp_simple_datas").html(response.content);
						$('.mmp_min_price_link').lightcase({
							href: '#mmp_popup_overall_wrapper',
							onStart: {
								onstart_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'block');
								}
							},
							onCleanup: {
								onclose_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'none');
								}
							},
						});
					}
					MMP_Frontend.unblock(".variations_form");
				});

			}
		},

		onFoundVariation: function (event, variation_form) {
			MMP_Frontend.wcpa_variation_change(variation_form.variation_id, event);
		},
		wcpa_var_field_display: function ($event) {
			var variation_id = $('input[name=variation_id]').val(),
				product_id = $('input[name=product_id]').val();
			MMP_Frontend.wcpa_variation_change(variation_id, $event);
		},
		wcpa_variation_change: function (variation_id, event) {
			$(".mmp_variation_datas").html('');
			$(".mmp_simple_datas").html('');
			$(".mmp_simple_datas").attr("disabled", "disabled");

			if (variation_id != '0' && variation_id != '' && variation_id != undefined) {
				MMP_Frontend.block(".variations_form");
				var data = {
					action: "mmp_get_form_fields",
					mmp_post_id: variation_id,
					popup_form_data: $("#mmp_popup_form_wrapper").find("textarea, input").serialize(),
					mmp_security: mmp_frontend_params.mmp_form_nonce,
				}
				$.post(mmp_frontend_params.ajaxurl, data, function (response) {
					if (response.success) {
						$(".mmp_variation_datas").html(response.content);
						$('.mmp_min_price_link').lightcase({
							href: '#mmp_popup_overall_wrapper',
							onStart: {
								onstart_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'block');
								}
							},
							onCleanup: {
								onclose_actions: function () {
									$('.mmp_popup_overall_wrapper').css('display', 'none');
								}
							},
						});
					}
					MMP_Frontend.unblock(".variations_form");
				});
			}
		},
		block: function (id) {
			$(id).block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.7
				}
			});
		}, unblock: function (id) {
			$(id).unblock({
				message: 'Form having Error',
			});
		},
	};
	MMP_Frontend.init();
});
