/* global mmp_pagination_params */

jQuery ( function ( $ ) {
	'use strict' ;

	var MMP_Frontend = {
		init : function ( ) {
			$ ( document ).on ( 'click' , '.mmp_pagination' , this.mmp_list_pagination ) ;
		} , mmp_list_pagination : function ( event ) {
			event.preventDefault ( ) ;
			var $this = $ ( event.currentTarget ) ,
					table = $this.closest ( 'table.mmp-list-table' ) ,
					table_body = table.find ( 'tbody' ) ,
					current_page = $this.data ( 'page' ) ;

			MMP_Frontend.block ( table_body ) ;

			var data = ( {
				action : 'mmp_list_pagination' ,
				page_number : current_page ,
				current_user : mmp_pagination_params.current_user , 
				is_logged_in : mmp_pagination_params.is_logged_in , 
				page_url : mmp_pagination_params.current_page_url ,
				mmp_security : mmp_pagination_params.mmp_list_pagination_nonce ,
			} ) ;
			$.post ( mmp_pagination_params.ajaxurl , data , function ( res ) {
				if ( true === res.success ) {
					table_body.html ( res.data.html ) ;

					table.find ( '.mmp_pagination' ).removeClass ( 'current' ) ;
					$ ( $this ).addClass ( 'current' ) ;

					table.find ( '.mmp_next_pagination' ).attr ( 'data-page' , current_page + 1 ) ;
					table.find ( '.mmp_prev_pagination' ).attr ( 'data-page' , current_page - 1 ) ;
				} else {
					alert ( res.data.error ) ;
				}

				MMP_Frontend.unblock ( table_body ) ;
			}
			) ;
		} , block : function ( id ) {
			$ ( id ).block ( {
				message : null ,
				overlayCSS : {
					background : '#fff' ,
					opacity : 0.7
				}
			} ) ;
		} , unblock : function ( id ) {
			$ ( id ).unblock () ;
		} ,
	} ;
	MMP_Frontend.init ( ) ;
} ) ;
