/* global mmp_enhanced_select_params */

jQuery( function ( $ ) {
	'use strict' ;
	try {
		$( document.body ).on( 'mmp-enhanced-init' , function () {
			if ( $( 'select.mmp_select2' ).length ) {
				//Select2 with customization
				$( 'select.mmp_select2' ).each( function () {
					var select2_args = {
						allowClear : $( this ).data( 'allow_clear' ) ? true : false ,
						placeholder : $( this ).data( 'placeholder' ) ,
						minimumResultsForSearch : 10 ,
					} ;
					$( this ).select2( select2_args ) ;
				} ) ;
			}
			if ( $( 'select.mmp_select2_search' ).length ) {
				//Multiple select with ajax search
				$( 'select.mmp_select2_search' ).each( function () {
					var select2_args = {
						allowClear : $( this ).data( 'allow_clear' ) ? true : false ,
						placeholder : $( this ).data( 'placeholder' ) ,
						minimumInputLength : $( this ).data( 'minimum_input_length' ) ? $( this ).data( 'minimum_input_length' ) : 3 ,
						escapeMarkup : function ( m ) {
							return m ;
						} ,
						ajax : {
							url : mmp_enhanced_select_params.ajaxurl ,
							dataType : 'json' ,
							delay : 250 ,
							data : function ( params ) {
								return {
									term : params.term ,
									action : $( this ).data( 'action' ) ? $( this ).data( 'action' ) : '' ,
									mmp_security : $( this ).data( 'nonce' ) ? $( this ).data( 'nonce' ) : mmp_enhanced_select_params.search_nonce ,
								} ;
							} ,
							processResults : function ( data ) {
								var terms = [ ] ;
								if ( data ) {
									$.each( data , function ( id , term ) {
										terms.push( {
											id : id ,
											text : term
										} ) ;
									} ) ;
								}
								return {
									results : terms
								} ;
							} ,
							cache : true
						}
					} ;

					$( this ).select2( select2_args ) ;
				} ) ;
			}

			if ( $( '.mmp_colorpicker' ).length ) {
				$( '.mmp_colorpicker' ).each( function ( ) {

					$( this ).iris( {
						change : function ( event , ui ) {
							$( this ).css( { backgroundColor : ui.color.toString( ) } ) ;
						} ,
						hide : true ,
						border : true
					} ) ;

					$( this ).css( 'background-color' , $( this ).val() ) ;
				} ) ;
			}
			
		} ) ;

		$( document.body ).trigger( 'mmp-enhanced-init' ) ;
	} catch ( err ) {
		window.console.log( err ) ;
	}

} ) ;
