<?php

/**
 * Enqueue Admin Assets Files.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! class_exists( 'MMP_Admin_Assets' ) ) {

	/**
	 * MMP_Admin_Assets Class.
	 */
	class MMP_Admin_Assets {

		/**
		 * MMP_Admin_Assets Class Initialization.
		 */
		public static function init() {
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'external_js_files' ) );
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'external_css_files' ) );
		}

		/**
		 * Enqueue external css files.
		 */
		public static function external_css_files() {
			$suffix         = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
			$screen_ids     = mmp_page_screen_ids();
			$new_screen_ids = get_current_screen();
			$screen_id      = str_replace( 'edit-', '', $new_screen_ids->id );

			if ( ! in_array( $screen_id, $screen_ids, true ) ) {
				return;
			}

			wp_enqueue_style( 'mmp_admin_styles', MMP_PLUGIN_URL . '/assets/css/admin/admin.css', array(), MMP_VERSION );
		}

		/**
		 * Enqueue Admin end required JS files.
		 */
		public static function external_js_files() {
			/**
			 * Display restriction.
			 *
			 * @since 3.1.0
			 */
			if ( apply_filters( 'mmp_display_unseen_count_in_menu', true ) && mmp_get_product_list_count() > 0 ) {
				/**
				 * Unseen Count
				 *
				 * @since 3.1.0
				 */
				$unseen_count = apply_filters( 'mmp_product_list_count', mmp_get_product_list_count() );
				$menu_name    = esc_html__( 'Lower Price', 'lower-price-for-woocommerce' ) . ' <span class="mmp-unseen-count-wrap awaiting-mod update-plugins count-' . esc_attr( $unseen_count ) . '" data-count="' . esc_attr( $unseen_count ) . '"><span class="mmp-unseen-count processing-count">' . number_format_i18n( $unseen_count ) . '</span></span>';
			} else {
				$menu_name = esc_html__( 'Lower Price', 'lower-price-for-woocommerce' );
			}

			$suffix         = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
			$screen_ids     = mmp_page_screen_ids();
			$new_screen_ids = get_current_screen();
			$screen_id      = str_replace( 'edit-', '', $new_screen_ids->id );
			$enqueue_array  = array(
				'mmp-select2'      => array(
					'callable' => array( 'MMP_Admin_Assets', 'select2' ),
					'restrict' => in_array( $screen_id, $screen_ids, true ),
				),
				'mmp-settings'     => array(
					'callable' => array( 'MMP_Admin_Assets', 'settings_scripts' ),
					'restrict' => in_array( $screen_id, $screen_ids, true ),
				),
				'mmp-sortable'     => array(
					'callable' => array( 'MMP_Admin_Assets', 'settings_sortable' ),
					'restrict' => in_array( $screen_id, $screen_ids, true ),
				),
				'mmp-custom-field' => array(
					'callable' => array( 'MMP_Admin_Assets', 'custom_field' ),
					'restrict' => in_array( $screen_id, array( sanitize_title( $menu_name ) . '_page_mmp_form_fields' ), true ),
				),
			);

			/**
			 * Admin scripts.
			 *
			 * @since 1.0
			 */
			$enqueue_array = apply_filters( 'mmp_admin_enqueue_scripts', $enqueue_array );

			if ( ! mmp_check_is_array( $enqueue_array ) ) {
				return;
			}

			foreach ( $enqueue_array as $key => $enqueue ) {
				if ( ! mmp_check_is_array( $enqueue ) ) {
					continue;
				}

				if ( $enqueue['restrict'] ) {
					call_user_func_array( $enqueue['callable'], array( $suffix ) );
				}
			}

			/**
			 * After enqueue JS.
			 *
			 * @since 1.0
			 */
			do_action( 'mmp_admin_after_enqueue_js' );
		}

		/**
		 * Enqueue select2 scripts.
		 */
		public static function select2( $suffix ) {
			wp_enqueue_script( 'mmp-enhanced', MMP_PLUGIN_URL . '/assets/js/mmp-enhanced.js', array( 'jquery', 'wc-select2', 'jquery-ui-datepicker' ), MMP_VERSION );
			wp_localize_script(
				'mmp-enhanced',
				'mmp_enhanced_select_params',
				array(
					'search_nonce' => wp_create_nonce( 'mmp-search-nonce' ),
					'ajaxurl'      => MMP_ADMIN_AJAX_URL,
				)
			);
		}

		/**
		 * Enqueue Admin Settings scripts.
		 */
		public static function settings_scripts() {
			wp_enqueue_script( 'mmp-settings', MMP_PLUGIN_URL . '/assets/js/admin/mmp-settings.js', array( 'jquery' ), MMP_VERSION );
			wp_localize_script(
				'mmp-settings',
				'mmp_settings_params',
				array(
					'accept_validation_message' => esc_html__( 'Please Enter the Offer Price Value', 'lower-price-for-woocommerce' ),
					'delete_confirm_message'    => esc_html__( 'Are you sure you want to delete it?', 'lower-price-for-woocommerce' ),
					'reject_confirm_message'    => esc_html__( 'Are you sure you want to proceed?', 'lower-price-for-woocommerce' ),
					'viewed_once_nonce'         => wp_create_nonce( 'mmp-viewed-once-nonce' ),
					'decimal_point'             => wc_get_price_decimal_separator(),
					/* translators: %s: price decimal separator */
					'decimal_error'             => sprintf( __( 'Please enter a value with one monetary decimal point (%s) without thousand separators and currency symbols.', 'woocommerce' ), wc_get_price_decimal_separator() ),
				)
			);
		}

		/**
		 * Enqueue Admin Post Table Scripts.
		 */
		public static function settings_sortable() {
			wp_enqueue_script( 'mmp-form-fields', MMP_PLUGIN_URL . '/assets/js/admin/mmp-form-fields.js', array( 'jquery', 'jquery-ui-sortable' ), MMP_VERSION );
			wp_localize_script(
				'mmp-form-fields',
				'mmp_form_fields_params',
				array(
					'field_sort_nonce' => wp_create_nonce( 'mmp-field-sort-nonce' ),
					'ajaxurl'          => MMP_ADMIN_AJAX_URL,
				)
			);
		}

		/**
		 * Custom Field.
		 *
		 * @since 3.3.0
		 * */
		public static function custom_field() {
			/**
			 * Display restriction.
			 *
			 * @since 3.1.0
			 */
			if ( apply_filters( 'mmp_display_unseen_count_in_menu', true ) && mmp_get_product_list_count() > 0 ) {
				/**
				 * Unseen Count
				 *
				 * @since 3.1.0
				 */
				$unseen_count = apply_filters( 'mmp_product_list_count', mmp_get_product_list_count() );
				$menu_name    = esc_html__( 'Lower Price', 'lower-price-for-woocommerce' ) . ' <span class="mmp-unseen-count-wrap awaiting-mod update-plugins count-' . esc_attr( $unseen_count ) . '" data-count="' . esc_attr( $unseen_count ) . '"><span class="mmp-unseen-count processing-count">' . number_format_i18n( $unseen_count ) . '</span></span>';
			} else {
				$menu_name = esc_html__( 'Lower Price', 'lower-price-for-woocommerce' );
			}

			$screen_id = sanitize_title( $menu_name ) . '_page_mmp_form_fields';

			wp_enqueue_script( 'mmp-custom-field', MMP_PLUGIN_URL . '/assets/js/admin/custom-field.js', array( 'jquery', 'wc-jquery-blockui', 'wc-admin-meta-boxes', 'wc-backbone-modal' ), MMP_VERSION, false );
			wp_localize_script(
				'mmp-custom-field',
				'mmp_custom_field_params',
				array(
					'add_custom_field_nonce'     => wp_create_nonce( 'mmp-add-custom-field' ),
					'update_custom_field_nonce'  => wp_create_nonce( 'mmp-update-custom-field' ),
					'custom_field_preview_nonce' => wp_create_nonce( 'mmp-preview-custom-field' ),
					'custom_field_data_nonce'    => wp_create_nonce( 'mmp-custom-field-data' ),
					'mmp_screen_id'              => $screen_id,
					'custom_field_created_msg'   => esc_html__( 'Field Added Successfully', 'lower-price-for-woocommerce' ),
					'custom_field_updated_msg'   => esc_html__( 'Field Updated Successfully', 'lower-price-for-woocommerce' ),
					'delete_confirm_message'     => esc_html__( 'Are you sure you want to delete?', 'lower-price-for-woocommerce' ),
				)
			);
		}
	}

	MMP_Admin_Assets::init();
}
