<?php
/**
 * Add Custom Field
 *
 * @package Lower Price/custom field
 * */

defined( 'ABSPATH' ) || exit;
?>
<div class="wc-backbone-modal mmp-modal-add-custom-field-wrapper">
	<div class="wc-backbone-modal-content">
		<section class="wc-backbone-modal-main" role="main">
			<header class="wc-backbone-modal-header">
				<h1><?php esc_html_e( 'Add Custom Field', 'lower-price-for-woocommerce' ); ?></h1>
			</header>
			<article>
				<p class="mmp-fields">
					<label for="_custom_field_type"><?php esc_html_e( 'Field Type:', 'lower-price-for-woocommerce' ); ?></label>
					<select class="mmp-custom-field-type" name="_custom_field_type" id="_custom_field_type">
						<?php
						$options = mmp_custom_field_types();

						foreach ( $options as $key => $value ) :
							?>
							<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></option> 
							<?php
						endforeach;
						?>
					</select>
				</p>

				<p class="mmp-fields">
					<label for="_label"><?php esc_html_e( 'Label:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_label" name="_label" rows="4" cols="50" class="mmp-label-field mmp-required-field"></textarea>
				</p>

				<p class="mmp-default-custom-field mmp-fields">
					<label for="_name"><?php esc_html_e( 'Name:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="text" class="mmp-name-field input-text mmp-required-field" name="_name" id="_name"/>
				</p>

				<p class="mmp-fields">
					<label for="_id_attr"><?php esc_html_e( 'ID:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="text" class="mmp-id-field input-text" name="_id_attr" id="_id_attr"/>
				</p>

				<p class="mmp-fields">
					<label for="_class_attr"><?php esc_html_e( 'Class:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_class_attr" name="_class_attr" rows="4" cols="50" class="mmp-class-field input-text"></textarea>
				</p>

				<p class="mmp-fields">
					<label for="_default"><?php esc_html_e( 'Default Value:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="text" class="mmp-default-field input-text" name="_default" id="_default"/>
				</p>

				<p class="mmp-add-custom-fields mmp-number-field mmp-fields">
					<label for="_min"><?php esc_html_e( 'Minimum:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-min-field input-text" name="_min" id="_min"/>
				</p>

				<p class="mmp-add-custom-fields mmp-number-field mmp-fields">
					<label for="_max"><?php esc_html_e( 'Maximum:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-max-field input-text" name="_max" id="_max"/>
				</p>

				<p class="mmp-add-custom-fields mmp-number-field mmp-fields">
					<label for="_step"><?php esc_html_e( 'Step:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-step-field input-text" name="_step" id="_step" min="0"/>
				</p>

				<p class="mmp-add-custom-fields mmp-text-area-field mmp-fields">
					<label for="_rows"><?php esc_html_e( 'Rows:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-rows-field input-text" name="_rows" id="_rows" min="0"/>
				</p>

				<p class="mmp-add-custom-fields mmp-text-area-field mmp-fields">
					<label for="_cols"><?php esc_html_e( 'Cols:', 'lower-price-for-woocommerce' ); ?></label>
					<input type="number" class="mmp-cols-field input-text" name="_cols" id="_cols" min="0"/>
				</p>

				<p class="mmp-add-custom-fields mmp-dropdown-field mmp-checkbox-field mmp-radio-field mmp-fields">
					<label for="_options"><?php esc_html_e( 'Options:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_options" name="_options" rows="4" cols="50" class="mmp-options-field mmp-required-field"></textarea>
					<span class="description"><?php esc_html_e( 'One option per line & use "|" for separate id and value "e.g." (id|value)', 'lower-price-for-woocommerce' ); ?></span>
				</p>

				<p class="mmp-add-custom-fields mmp-dropdown-field mmp-fields">
					<label for="_multiple"><?php esc_html_e( 'Allow Multiple Selection', 'lower-price-for-woocommerce' ); ?></label>
					<input type="checkbox" name="_multiple" name="_multiple" class="mmp-dropdown-field mmp-multiple-field input-text" value="">
				</p>

				<p class="mmp-fields">
					<label for="_required"><?php esc_html_e( 'Required', 'lower-price-for-woocommerce' ); ?></label>
					<input type="checkbox" name="_required" name="_required" class="mmp-required-attr-field input-text" value="yes">
				</p>

				<p class="mmp-fields">
					<label for="_placeholder"><?php esc_html_e( 'Placeholder:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_placeholder" name="_placeholder" rows="4" cols="50" class="mmp-placeholder-field"></textarea>
				</p>

				<p class="mmp-fields">
					<label for="_tool_tip"><?php esc_html_e( 'Tool Tip:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_tool_tip" name="_tool_tip" rows="4" cols="50" class="mmp-tool-tip-field"></textarea>
				</p>

				<p class="mmp-fields">
					<label for="_data_attr"><?php esc_html_e( 'Data Attribute:', 'lower-price-for-woocommerce' ); ?></label>
					<textarea id="_data_attr" name="_data_attr" rows="4" cols="50" class="mmp-data-attr-field"></textarea>
					<span class="description"><?php esc_html_e( 'One option per line & use "|" for separate key and value "e.g." (key|value)', 'lower-price-for-woocommerce' ); ?></span>
				</p>

				<p class="mmp-fields">
					<label for="_status"><?php esc_html_e( 'Status:', 'lower-price-for-woocommerce' ); ?></label>
					<select name="_status" id="_status" class="mmp-custom-field-status">
						<?php foreach ( mmp_get_custom_field_statuses() as $status_name => $status_label ) : ?>
							<option value="<?php echo esc_attr( $status_name ); ?>"><?php echo esc_html( $status_label ); ?></option>
						<?php endforeach; ?>
					</select>
				</p>

				<span class="mmp-inside"></span>
				<span class="mmp-error" style="font-weight:bold;"></span>
			</article>
			<footer>                
				<div class="inner">
					<button class="mmp-add-custom-field button button-primary" style="display:none;"><?php esc_html_e( 'Add Custom Field', 'lower-price-for-woocommerce' ); ?></button>
					<a href="<?php echo esc_url( mmp_get_custom_field_page_url() ); ?>" class="mmp-cancel-custom-field-adding button"><?php esc_html_e( 'Cancel', 'lower-price-for-woocommerce' ); ?></a>
				</div>
			</footer>
		</section>
	</div>
</div>
<div class="wc-backbone-modal-backdrop"></div>
