<?php
/**
 * Custom Field Preview.
 *
 * @package Lower Price/Custom Field Preview
 * */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<div class="wc-backbone-modal wc-order-preview mmp-custom-field-preview-tmpl">
	<div class="wc-backbone-modal-content">
		<section class="wc-backbone-modal-main" role="main">
			<header class="wc-backbone-modal-header">
				<mark class="order-status status-{{ data.status }}"><span>{{ data.status_name }}</span></mark>
				<?php /* translators: %s: order ID */ ?>
				<h1><?php echo esc_html( sprintf( esc_html__( 'Frontend Product Submission Form Field #%s', 'lower-price-for-woocommerce' ), '{{ data.custom_field_id }}' ) ); ?></h1>
				<button class="modal-close modal-close-link dashicons dashicons-no-alt">
					<span class="screen-reader-text"><?php esc_html_e( 'Close modal panel', 'lower-price-for-woocommerce' ); ?></span>
				</button>
			</header>
			<article>
				<?php
				/**
				 * Custom Field Preview Start.
				 *
				 * @since 3.3.0
				 */
				do_action( 'mmp_admin_custom_field_preview_start' );
				?>
				{{{ data.item_html }}}
				<?php
				/**
				 * Commissions Preview End.
				 *
				 * @since 3.3.0
				 */
				do_action( 'mmp_admin_custom_field_preview_end' );
				?>
			</article>
			<footer>
				<div class="inner">
					{{{ data.actions_html }}}
				</div>
			</footer>
		</section>
	</div>
</div>
<div class="wc-backbone-modal-backdrop modal-close"></div>
