<?php
/**
 * Custom Field Table.
 *
 * @package Multi-vendor/Admin
 * */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$add_new_custom_field_url = mmp_get_custom_field_page_url( array( 'action' => 'add_new_custom_field' ) );
$search_term              = isset( $_REQUEST['s'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['s'] ) ) : ''
?>
<div class = "wrap mmp-wrapper-cover woocommerce">
	<form method = "post" id="mmp_admin_custom_field_form" enctype = "multipart/form-data">
		<div class="mmp-table-wrap">
			<div class="mmp-custom-field-head-button">
				<h1 class="wp-heading-inline"><?php echo esc_html__( 'Frontend Product Submission Form Field', 'lower-price-for-woocommerce' ); ?></h1>
				<a class="page-title-action mmp-custom-field-add-btn" href=" <?php echo esc_url( $add_new_custom_field_url ); ?> "> <?php esc_html_e( 'Create New Field', 'lower-price-for-woocommerce' ); ?></a>
				<hr class="wp-header-end">
			</div>

			<?php
			if ( strlen( $search_term ) ) {
				/* translators: %s: search keywords */
				echo wp_kses_post( sprintf( '<span class="subtitle">' . esc_html__( 'Search results for &#8220;%s&#8221;', 'lower-price-for-woocommerce' ) . '</span>', esc_html( $search_term ) ) );
			}

			$post_table->views();
			$post_table->search_box( esc_html__( 'Search Field', 'lower-price-for-woocommerce' ), 'mmp_search' );
			wp_nonce_field( 'mmp-search_custom_field', '_mmp_nonce' );
			$post_table->display();
			?>
		</div>
	</form>
</div>
<?php
