<?php
/**
 * Initialize the Plugin.
 *
 * @package Lower Price
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Order_Update' ) ) {

	/**
	 * Main MMP_Order_Update Class.
	 * */
	class MMP_Order_Update {

		/**
		 * Initialize function
		 */
		public static function init() {
			foreach ( array( 'pending', 'on-hold', 'processing', 'completed' ) as $status ) {
				add_action( 'woocommerce_order_status_' . $status, array( __CLASS__, 'processing_coupon_used_order' ), 10, 1 );
			}
		}

		/**
		 * Used Coupons Post Update
		 *
		 * @since 1.0.0
		 * @param Integer $order_id Order ID.
		 */
		public static function processing_coupon_used_order( $order_id ) {
			$order        = wc_get_order( $order_id );
			$used_coupons = (float) WC()->version < (float) ( '3.7' ) ? $order->get_used_coupons() : $order->get_coupon_codes();

			if ( mmp_check_is_array( $used_coupons ) ) {
				foreach ( $used_coupons as $coupon_title ) {
					$list_id = mmp_is_get_request_by_coupon_title( $coupon_title );

					if ( $list_id ) {
						mmp_update_entry(
							$list_id,
							array(
								'mmp_coupon_used_order_id' => $order_id,
								'mmp_lst_activity'         => current_time(
									'mysql',
									true
								),
							),
							array( 'post_status' => 'mmp_coupon_used' )
						);
					}
				}
			}
		}
	}

	MMP_Order_Update::init();
}
