<?php

/**
 * Custom Post Type.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'MMP_Register_Post_Types' ) ) {

	/**
	 * MMP_Register_Post_Types Class.
	 */
	class MMP_Register_Post_Types {
		/*
		 *  List Post Type
		 */

		const MMP_PRODUCT_POSTTYPE = 'mmp-product-list';

		/**
		 * MMP_Register_Post_Types Class initialization.
		 */
		public static function init() {
			add_action( 'init', array( __CLASS__, 'register_custom_post_types' ) );
		}

		/**
		 * Register Custom Post types.
		 */
		public static function register_custom_post_types() {
			if ( ! is_blog_installed() ) {
				return;
			}

			$custom_post_types = array(
				self::MMP_PRODUCT_POSTTYPE => array( 'MMP_Register_Post_Types', 'mmp_post_type_args' ),
			);
			/**
			 * Custom post types.
			 *
			 * @since 1.0
			 */
			$custom_post_types = apply_filters( 'mmp_add_custom_post_types', $custom_post_types );

			// return if no post type to register.
			if ( ! mmp_check_is_array( $custom_post_types ) ) {
				return;
			}

			foreach ( $custom_post_types as $post_type => $args_function ) {

				$args = array();
				if ( $args_function ) {
					$args = call_user_func_array( $args_function, $args );
				}

				// Register custom post type.
				register_post_type( $post_type, $args );
			}
		}

		/**
		 * Prepare MMP Post type arguments.
		 */
		public static function mmp_post_type_args() {
			/**
			 * Product list.
			 *
			 * @since 1.0
			 */
			return apply_filters(
				'mmp_product_list_post_type_args',
				array(
					'labels'              => array(
						'name'               => esc_html__( 'Price List', 'lower-price-for-woocommerce' ),
						'singular_name'      => esc_html__( 'Price List', 'lower-price-for-woocommerce' ),
						'menu_name'          => esc_html__( 'Price List', 'lower-price-for-woocommerce' ),
						'add_new'            => esc_html__( 'Add New Price List', 'lower-price-for-woocommerce' ),
						'add_new_item'       => esc_html__( 'Add New Price List', 'lower-price-for-woocommerce' ),
						'edit'               => esc_html__( 'Edit Price List', 'lower-price-for-woocommerce' ),
						'edit_item'          => esc_html__( 'View Price List', 'lower-price-for-woocommerce' ),
						'new_item'           => esc_html__( 'New Price List', 'lower-price-for-woocommerce' ),
						'view'               => esc_html__( 'View Price List', 'lower-price-for-woocommerce' ),
						'view_item'          => esc_html__( 'View Price List', 'lower-price-for-woocommerce' ),
						'search_items'       => esc_html__( 'Search Products/Users', 'lower-price-for-woocommerce' ),
						'not_found'          => esc_html__( 'No Products/Users found', 'lower-price-for-woocommerce' ),
						'not_found_in_trash' => esc_html__( 'No Products/Users found in trash', 'lower-price-for-woocommerce' ),
					),
					'description'         => esc_html__( 'Here you can able to see list of Prices', 'lower-price-for-woocommerce' ),
					'public'              => true,
					'show_ui'             => true,
					'capability_type'     => 'post',
					'show_in_menu'        => 'mmp-product-list',
					'publicly_queryable'  => false,
					'exclude_from_search' => true,
					'hierarchical'        => false, // Hierarchical causes memory issues - WP loads all records!
					'show_in_nav_menus'   => false,
					'capabilities'        => array(
						'publish_posts'       => 'publish_posts',
						'edit_posts'          => 'edit_posts',
						'edit_others_posts'   => 'edit_others_posts',
						'delete_posts'        => 'delete_posts',
						'delete_others_posts' => 'delete_others_posts',
						'read_private_posts'  => 'read_private_posts',
						'edit_post'           => 'edit_post',
						'delete_post'         => 'delete_post',
						'read_post'           => 'read_post',
						'create_posts'        => 'do_not_allow',
					),
					'map_meta_cap'        => true,
				)
			);
		}

				/**
				 * Prepare MMP Post type arguments.
				 */
		public static function mmp_form_fields_post_type_args() {
			/**
			 * Form fields.
			 *
			 * @since 1.0
			 */
			return apply_filters(
				'mmp_form_fields_post_type_args',
				array(
					'labels'              => array(
						'name'               => esc_html__( 'Frontend Product Submission Form Field', 'lower-price-for-woocommerce' ),
						'singular_name'      => esc_html__( 'Frontend Product Submission Form Fields', 'lower-price-for-woocommerce' ),
						'menu_name'          => esc_html__( 'Frontend Form', 'lower-price-for-woocommerce' ),
						'add_new'            => esc_html__( 'Add New Frontend Form Field', 'lower-price-for-woocommerce' ),
						'add_new_item'       => esc_html__( 'Add New Frontend Form Field', 'lower-price-for-woocommerce' ),
						'edit'               => esc_html__( 'Edit Frontend Form Field', 'lower-price-for-woocommerce' ),
						'edit_item'          => esc_html__( 'View Frontend Form Field', 'lower-price-for-woocommerce' ),
						'new_item'           => esc_html__( 'New Frontend Form Field', 'lower-price-for-woocommerce' ),
						'view'               => esc_html__( 'View Frontend Form Field', 'lower-price-for-woocommerce' ),
						'view_item'          => esc_html__( 'View Frontend Form Field', 'lower-price-for-woocommerce' ),
						'not_found'          => esc_html__( 'No Frontend Form Fields found', 'lower-price-for-woocommerce' ),
						'not_found_in_trash' => esc_html__( 'No Frontend Form Fields found in trash', 'lower-price-for-woocommerce' ),
					),
					'description'         => esc_html__( 'Here you can able to see list of Frontend Form Field', 'lower-price-for-woocommerce' ),
					'public'              => true,
					'show_ui'             => true,
					'capability_type'     => 'post',
					'show_in_menu'        => 'mmp-product-list',
					'publicly_queryable'  => false,
					'exclude_from_search' => true,
					'hierarchical'        => false, // Hierarchical causes memory issues - WP loads all records!
					'show_in_nav_menus'   => false,
					'capabilities'        => array(
						'publish_posts'       => 'publish_posts',
						'edit_posts'          => 'edit_posts',
						'edit_others_posts'   => 'edit_others_posts',
						'delete_posts'        => 'delete_posts',
						'delete_others_posts' => 'delete_others_posts',
						'read_private_posts'  => 'read_private_posts',
						'edit_post'           => 'edit_post',
						'delete_post'         => 'delete_post',
						'read_post'           => 'read_post',
						'create_posts'        => 'do_not_allow',
					),
					'map_meta_cap'        => true,
				)
			);
		}
	}

	MMP_Register_Post_Types::init();
}
