<?php
/**
 * Customer Guest Acknowledge
 *
 * @package Lower Price
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WC_MMP_Customer_Ack_Guest', false ) ) {

	/**
	 * Account Customer Ack Guest Email.
	 *
	 * @class WC_MMP_Customer_Ack_Guest
	 * @package class
	 * @extends WC_MMP_Abstract_Email
	 */
	class WC_MMP_Customer_Ack_Guest extends WC_MMP_Abstract_Email {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id             = WC_MMP_PREFIX . 'customer_ack_guest';
			$this->customer_email = true;
			$this->title          = __( 'Customer Ack - Guest', 'lower-price-for-woocommerce' );
			$this->template_html  = 'emails/customer-ack-guest.php';
			$this->template_plain = 'emails/plain/customer-ack-guest.php';
			$this->subject        = __( '{site_title} - Lower Price Request Submitted', 'lower-price-for-woocommerce' );
			$this->heading        = __( 'Guest Acknowledgement', 'lower-price-for-woocommerce' );
			$this->description    = __( 'Guest Users will receive an email notification when they submit the lower price request & shows the requested details.', 'lower-price-for-woocommerce' );

			// Triggers for this email.
			add_action( 'wc_mmp_customer_ack_guest_notification', array( $this, 'trigger' ) );

			// Call parent constructor.
			parent::__construct();
		}

		/**
		 * Get content args.
		 *
		 * @return array
		 */
		public function get_content_args() {
			$content_args               = parent::get_content_args();
			$content_args['list_id']    = $this->list_id;
			$content_args['list_obj']   = $this->list_obj;
			$content_args['user_name']  = $this->list_obj->get_name();
			$content_args['mmp_pro_id'] = $this->list_obj->get_pro_id();

			return $content_args;
		}

		/**
		 * Trigger the sending of this email.
		 *
		 * @since 1.0.0
		 * @param Integer $entry_id Entry ID.
		 */
		public function trigger( $entry_id ) {
			$list_obj        = mmp_get_entry( $entry_id );
			$this->list_id   = $entry_id;
			$this->list_obj  = $list_obj;
			$this->recipient = $list_obj->get_mail();

			$this->maybe_trigger();
		}
	}

}

return new WC_MMP_Customer_Ack_Guest();
