<?php
/**
 * Customer Ack Guest.
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/emails/customer-ack-guest.php.
 *
 * @package Lower Price
 */

defined( 'ABSPATH' ) || exit;

/**
 * Email header.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<p style="margin:15px 0;">
	<?php
	/* translators: 1: user name  */
	printf( wp_kses_post( __( 'Hi <b>%s</b>,<br> You have submitted the lower price request for the below product,', 'lower-price-for-woocommerce' ) ), esc_html( $user_name ) );

	/**
	 * Get pro table.
	 *
	 * @since 1.0
	 */
	do_action( 'mmp_get_pro_table', $list_obj, $mmp_pro_id );
	?>
</p>

<p style="margin:15px 0;">
	<?php
	/**
	 * Guest table.
	 *
	 * @since 1.0
	 */
	do_action( 'mmp_get_guest_table', $list_obj, $mmp_pro_id );
	?>
</p>

<p><?php esc_html_e( 'Thanks.', 'lower-price-for-woocommerce' ); ?></p>

<?php
/**
 * Email footer.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_footer', $email );
?>
