<?php
/**
 * Customer Ack.
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/emails/customer-ack.php.
 *
 * @package Lower Price
 */

defined( 'ABSPATH' ) || exit;

/**
 * Email header.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<p>
	<?php
	/* translators: 1: user name  */
	printf( wp_kses_post( __( 'Hi <b>%s</b>,<br> You have submitted the lower price request for the below product.', 'lower-price-for-woocommerce' ) ), esc_html( $user_name ) );

	/**
	 * Get pro table.
	 *
	 * @since 1.0
	 */
	do_action( 'mmp_get_pro_table', $list_obj, $mmp_pro_id );
	?>
</p>

<p style="margin:15px 0;">
<?php
	/* translators: 1: Page Link  */
	printf( wp_kses_post( __( 'Click %s to view your request.', 'lower-price-for-woocommerce' ) ), '<a target="blank" href=' . esc_attr( wc_get_endpoint_url( 'mmp_price_list', '', wc_get_page_permalink( 'myaccount' ) ) ) . '>' . wp_kses_post( __( 'Here', 'lower-price-for-woocommerce' ) ) . '</a>' );
?>
</p>

<p><?php esc_html_e( 'Thanks.', 'lower-price-for-woocommerce' ); ?></p>

<?php
/**
 * Email footer.
 *
 * @since 1.0
 */
do_action( 'woocommerce_email_footer', $email ); ?>
