<?php
/**
 * This template displays contents inside Price table
 *
 * This template can be overridden by copying it to yourtheme/lower-price-for-woocommerce/lower-price-for-woocommerce.php
 *
 * To maintain compatibility, Lower Price for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}


foreach ( $product_ids as $each_id ) {
	$mmp_data = mmp_get_entry( $each_id ) ;

	$product_data = wc_get_product( $mmp_data->get_pro_id() ) ;
	?>
	<tr>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_pro_name' ) ) ; ?>">
			<?php echo wp_kses_post( $mmp_data->get_product_title_link() ) ; ?>
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_org_price' ) ) ; ?>">
			<?php
			mmp_price( mmp_get_tax_based_price( $mmp_data->get_pro_id() ) ) ;
			?>
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_report_price' ) ) ; ?>">
			<span><?php mmp_price( $mmp_data->get_pref_price() ) ; ?></span>
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_offered_price' ) ) ; ?>">
			<span><?php echo wp_kses_post( $mmp_data->get_off_price_formatted() ) ; ?></span>
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_status' ) ) ; ?>">
			<span><?php echo wp_kses_post( mmp_get_list_status( $mmp_data->get_status_formatted() ) ) ; ?></span>
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_coupon_code' ) ) ; ?>">
			<span><?php echo esc_html__( $mmp_data->get_coupon_title() ) ; ?></span>
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_expiry_date' ) ) ; ?>">
			<span>
				<?php
				if ( 'mmp_coupon_used' == $mmp_data->get_status() ) {
					echo wp_kses_post( '-' ) ;
				} else {
					echo esc_html__( $mmp_data->get_coupon_expiry() ) ;
				}
				?>
			</span>  
		</td>
		<td data-title="<?php echo esc_html( get_option( 'mmp_localization_lst_activity' ) ) ; ?>">
			<span><?php echo esc_html__( $mmp_data->get_formatted_activity_date() ) ; ?></span>
		</td>
	</tr>
	<?php
}
