<?php

class Noviship
{
    private $api_key = null;
    private $api_url = 'http://api.noviship.net/v1';

    public function __construct($key = null, $url = null)
    {
        if ($key)
        {
            $this->api_key = $key;
        }
        if ($url)
        {
            $this->api_url = $url;
        }
    }

    private function make_call($method, $data)
    {
        $data['key'] = $this->api_key;
        $request = array($method => $data);
        $json = json_encode($request);

        $ch = curl_init($this->api_url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($json),
        ));
        $result = curl_exec($ch);
        $output = json_decode($result, true);

        return $output;
    }

    public function GetQuotes($shipment, &$quotes, &$messages)
    {
        $output = $this->make_call('GetQuotes', array('shipment' => $shipment, 'flags' => array(array('name' => 'async', 'value' => '1'))));
        if ($output['result'] == 0)
        {
            $quotes = $output['quotes'];
            $messages = $output['messages'];
        }
        return $output['result'];
    }

    public function QuoteShipment($shipment_number, &$messages, &$quotes)
    {
        $output = $this->make_call('QuoteShipment', array('id' => $shipment_number));
        if ($output['result'] == 0)
        {
            $messages = $output['messages'];
            $quotes = $output['quotes'];
        }
        return $output['result'];
    }

    public function CreateShipment($shipment, &$messages, &$shipment_number)
    {
        $output = $this->make_call('CreateShipment', array('shipment' => $shipment));
        if ($output['result'] == 0)
        {
            $messages = $output['messages'];
            $shipment_number = $output['id'];
        }
        return $output['result'];
    }

    public function ReadShipment($shipment_number, &$messages, &$shipment)
    {
        $output = $this->make_call('ReadShipment', array('id' => $shipment_number));
        if ($output['result'] == 0)
        {
            $messages = $output['messages'];
            $shipment = $output['shipment'];
        }
        return $output['result'];
    }

    public function SubmitShipment($shipment_number, $quote_id, &$messages, &$documents)
    {
        $output = $this->make_call('SubmitShipment', array('id' => $shipment_number, 'quoteid' => $quote_id));
        if ($output['result'] == 0)
        {
            $documents = $output['documents'];
        }
        $messages = $output['messages'];
        return $output['result'];
    }

    public function ModifyShipment($shipment_number, $shipment, &$messages)
    {
        $output = $this->make_call('ModifyShipment', array('id' => $shipment_number, 'shipment' => $shipment));
        $messages = $output['messages'];
        return $output['result'];
    }
}

?>