import { PlayerProps } from '../../core/player/PlayerProps';
export declare class Scrim {
  /**
   * If this prop is defined, a dark gradient that smoothly fades out without being noticed will be
   * used instead of a set color. This prop also sets the direction in which the dark end of the
   * gradient should start. If the direction is set to `up`, the dark end of the gradient will
   * start at the bottom of the player and fade out to the center. If the direction is set to
   * `down`, the gradient will start at the top of the player and fade out to the center.
   */
  gradient?: 'up' | 'down';
  /**
   * @internal
   */
  isVideoView: PlayerProps['isVideoView'];
  /**
   * @internal
   */
  isControlsActive: PlayerProps['isControlsActive'];
  constructor();
  render(): any;
}
