export declare const IS_CLIENT: boolean;
export declare const UA: string;
export declare const IS_IOS: boolean;
export declare const IS_ANDROID: boolean;
export declare const IS_MOBILE: boolean;
export declare const IS_IPHONE: boolean;
export declare const IS_FIREFOX: boolean;
export declare const IS_CHROME: any;
export declare const IS_SAFARI: any;
export declare const ORIGIN: string | undefined;
export declare type WebKitPresentationMode = 'picture-in-picture' | 'inline' | 'fullscreen';
export declare const onTouchInputChange: (callback: (isTouch: boolean) => void) => () => void;
/**
 * Checks if a video player can enter fullscreen.
 *
 * @see https://developer.apple.com/documentation/webkitjs/htmlvideoelement/1633500-webkitenterfullscreen
 */
export declare const canFullscreenVideo: () => boolean;
/**
 * Checks if the screen orientation can be changed.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Screen/orientation
 */
export declare const canRotateScreen: () => false | ((orientation: OrientationLockType) => Promise<void>);
/**
 * Reduced motion iOS & MacOS setting.
 *
 * @see https://webkit.org/blog/7551/responsive-design-for-motion/
 */
export declare const isReducedMotionPreferred: () => boolean;
/**
 * Checks if the native HTML5 video player can play HLS.
 */
export declare const canPlayHLSNatively: () => boolean;
/**
 * Checks if the native HTML5 video player can enter picture-in-picture (PIP) mode when using
 * the Chrome browser.
 *
 * @see  https://developers.google.com/web/updates/2018/10/watch-video-using-picture-in-picture
 */
export declare const canUsePiPInChrome: () => boolean;
/**
 * Checks if the native HTML5 video player can enter picture-in-picture (PIP) mode when using
 * the desktop Safari browser, iOS Safari appears to "support" PiP through the check, however PiP
 * does not function.
 *
 * @see https://developer.apple.com/documentation/webkitjs/adding_picture_in_picture_to_your_safari_media_controls
 */
export declare const canUsePiPInSafari: () => boolean;
export declare const canUsePiP: () => boolean;
/**
 * To detect autoplay, we create a video element and call play on it, if it is `paused` after
 * a `play()` call, autoplay is supported. Although this unintuitive, it works across browsers
 * and is currently the lightest way to detect autoplay without using a data source.
 *
 * @see https://github.com/ampproject/amphtml/blob/9bc8756536956780e249d895f3e1001acdee0bc0/src/utils/video.js#L25
 */
export declare const canAutoplay: (muted?: boolean, playsinline?: boolean) => Promise<boolean>;
