<?php

class Oxygen_Shape_Divider extends OxyEl
{

    // Init function.
    function init()
    {
        
        $this->El->staticCSS(
            '
            .oxy-shape-divider {
                width: 0px;
                height: 0px;
                
            }
            
            .oxy_shape_divider svg {
                width: 100%;
            }
            '
        );

        add_action("ct_toolbar_component_settings", array( $this, "add_section_button") );
    }

    function afterInit() {
        $this->removeApplyParamsButton();
        $this->removeAddButton();
    }

    // Define the element's name.
    function name() {
        return __("Shape Divider","oxygen");
    }

    // Element options
    function options(){

        return array(
            //"wrapper_class" => $classes,
            "server_side_render" => true,
            "only_parent" => "ct_section"
        );

    }

    function add_section_button() { ?>

        <div class="oxygen-control-row"
            ng-show="isActiveName('ct_section')&&!hasOpenTabs('ct_section')">
            <div class="oxygen-control-wrapper">
                <div id="oxygen-add-another-row" class="oxygen-add-section-element"
                    ng-click="iframeScope.addComponent('oxy-shape-divider')">
                    <img src='<?php echo CT_FW_URI; ?>/toolbar/UI/oxygen-icons/add-icons/header.svg' />
                    <img src='<?php echo CT_FW_URI; ?>/toolbar/UI/oxygen-icons/add-icons/header-active.svg' />
                    <?php _e("Add Shape Divider","oxygen"); ?>
                </div>
            </div>
        </div>

    <?php }

    // Include the smart.video.style.css file.
    function defaultCSS() {
        return file_get_contents(__DIR__.'/shape-divider/shape.divider.styles.css');
    }

    function render( $options, $defaults, $content ){

        $classes = 'oxy_shape_divider';
        
        $svg_shape = $options['svg_shape'];

        switch ($svg_shape) {

            case 'Towers 1':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,288L0,192L36.9,192L36.9,32L73.8,32L73.8,224L110.8,224L110.8,128L147.7,128L147.7,224L184.6,224L184.6,64L221.5,64L221.5,160L258.5,160L258.5,128L295.4,128L295.4,96L332.3,96L332.3,224L369.2,224L369.2,32L406.2,32L406.2,64L443.1,64L443.1,0L480,0L480,224L516.9,224L516.9,160L553.8,160L553.8,192L590.8,192L590.8,128L627.7,128L627.7,64L664.6,64L664.6,64L701.5,64L701.5,128L738.5,128L738.5,288L775.4,288L775.4,192L812.3,192L812.3,32L849.2,32L849.2,224L886.2,224L886.2,192L923.1,192L923.1,192L960,192L960,224L996.9,224L996.9,96L1033.8,96L1033.8,224L1070.8,224L1070.8,288L1107.7,288L1107.7,192L1144.6,192L1144.6,288L1181.5,288L1181.5,160L1218.5,160L1218.5,64L1255.4,64L1255.4,256L1292.3,256L1292.3,96L1329.2,96L1329.2,128L1366.2,128L1366.2,128L1403.1,128L1403.1,224L1440,224L1440,320L1403.1,320L1403.1,320L1366.2,320L1366.2,320L1329.2,320L1329.2,320L1292.3,320L1292.3,320L1255.4,320L1255.4,320L1218.5,320L1218.5,320L1181.5,320L1181.5,320L1144.6,320L1144.6,320L1107.7,320L1107.7,320L1070.8,320L1070.8,320L1033.8,320L1033.8,320L996.9,320L996.9,320L960,320L960,320L923.1,320L923.1,320L886.2,320L886.2,320L849.2,320L849.2,320L812.3,320L812.3,320L775.4,320L775.4,320L738.5,320L738.5,320L701.5,320L701.5,320L664.6,320L664.6,320L627.7,320L627.7,320L590.8,320L590.8,320L553.8,320L553.8,320L516.9,320L516.9,320L480,320L480,320L443.1,320L443.1,320L406.2,320L406.2,320L369.2,320L369.2,320L332.3,320L332.3,320L295.4,320L295.4,320L258.5,320L258.5,320L221.5,320L221.5,320L184.6,320L184.6,320L147.7,320L147.7,320L110.8,320L110.8,320L73.8,320L73.8,320L36.9,320L36.9,320L0,320L0,320Z"></path></svg>';
            break;
            case 'Towers 2':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,160L0,32L36.9,32L36.9,96L73.8,96L73.8,224L110.8,224L110.8,224L147.7,224L147.7,192L184.6,192L184.6,32L221.5,32L221.5,64L258.5,64L258.5,256L295.4,256L295.4,288L332.3,288L332.3,32L369.2,32L369.2,128L406.2,128L406.2,96L443.1,96L443.1,0L480,0L480,288L516.9,288L516.9,64L553.8,64L553.8,64L590.8,64L590.8,192L627.7,192L627.7,256L664.6,256L664.6,160L701.5,160L701.5,32L738.5,32L738.5,96L775.4,96L775.4,192L812.3,192L812.3,288L849.2,288L849.2,96L886.2,96L886.2,160L923.1,160L923.1,96L960,96L960,32L996.9,32L996.9,288L1033.8,288L1033.8,0L1070.8,0L1070.8,192L1107.7,192L1107.7,64L1144.6,64L1144.6,192L1181.5,192L1181.5,288L1218.5,288L1218.5,96L1255.4,96L1255.4,0L1292.3,0L1292.3,96L1329.2,96L1329.2,224L1366.2,224L1366.2,192L1403.1,192L1403.1,32L1440,32L1440,320L1403.1,320L1403.1,320L1366.2,320L1366.2,320L1329.2,320L1329.2,320L1292.3,320L1292.3,320L1255.4,320L1255.4,320L1218.5,320L1218.5,320L1181.5,320L1181.5,320L1144.6,320L1144.6,320L1107.7,320L1107.7,320L1070.8,320L1070.8,320L1033.8,320L1033.8,320L996.9,320L996.9,320L960,320L960,320L923.1,320L923.1,320L886.2,320L886.2,320L849.2,320L849.2,320L812.3,320L812.3,320L775.4,320L775.4,320L738.5,320L738.5,320L701.5,320L701.5,320L664.6,320L664.6,320L627.7,320L627.7,320L590.8,320L590.8,320L553.8,320L553.8,320L516.9,320L516.9,320L480,320L480,320L443.1,320L443.1,320L406.2,320L406.2,320L369.2,320L369.2,320L332.3,320L332.3,320L295.4,320L295.4,320L258.5,320L258.5,320L221.5,320L221.5,320L184.6,320L184.6,320L147.7,320L147.7,320L110.8,320L110.8,320L73.8,320L73.8,320L36.9,320L36.9,320L0,320L0,320Z"></path></svg>';
            break;
            case 'Towers 3':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,32L0,288L38.9,288L38.9,96L77.8,96L77.8,160L116.8,160L116.8,160L155.7,160L155.7,128L194.6,128L194.6,192L233.5,192L233.5,32L272.4,32L272.4,128L311.4,128L311.4,224L350.3,224L350.3,128L389.2,128L389.2,160L428.1,160L428.1,224L467,224L467,256L505.9,256L505.9,256L544.9,256L544.9,288L583.8,288L583.8,32L622.7,32L622.7,224L661.6,224L661.6,64L700.5,64L700.5,160L739.5,160L739.5,256L778.4,256L778.4,64L817.3,64L817.3,288L856.2,288L856.2,64L895.1,64L895.1,288L934.1,288L934.1,32L973,32L973,128L1011.9,128L1011.9,160L1050.8,160L1050.8,224L1089.7,224L1089.7,64L1128.6,64L1128.6,0L1167.6,0L1167.6,96L1206.5,96L1206.5,256L1245.4,256L1245.4,192L1284.3,192L1284.3,0L1323.2,0L1323.2,192L1362.2,192L1362.2,128L1401.1,128L1401.1,192L1440,192L1440,320L1401.1,320L1401.1,320L1362.2,320L1362.2,320L1323.2,320L1323.2,320L1284.3,320L1284.3,320L1245.4,320L1245.4,320L1206.5,320L1206.5,320L1167.6,320L1167.6,320L1128.6,320L1128.6,320L1089.7,320L1089.7,320L1050.8,320L1050.8,320L1011.9,320L1011.9,320L973,320L973,320L934.1,320L934.1,320L895.1,320L895.1,320L856.2,320L856.2,320L817.3,320L817.3,320L778.4,320L778.4,320L739.5,320L739.5,320L700.5,320L700.5,320L661.6,320L661.6,320L622.7,320L622.7,320L583.8,320L583.8,320L544.9,320L544.9,320L505.9,320L505.9,320L467,320L467,320L428.1,320L428.1,320L389.2,320L389.2,320L350.3,320L350.3,320L311.4,320L311.4,320L272.4,320L272.4,320L233.5,320L233.5,320L194.6,320L194.6,320L155.7,320L155.7,320L116.8,320L116.8,320L77.8,320L77.8,320L38.9,320L38.9,320L0,320L0,320Z"></path></svg>';
            break;
            case 'Wavy 1':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,96L30,106.7C60,117,120,139,180,133.3C240,128,300,96,360,80C420,64,480,64,540,101.3C600,139,660,213,720,240C780,267,840,245,900,245.3C960,245,1020,267,1080,250.7C1140,235,1200,181,1260,176C1320,171,1380,213,1410,234.7L1440,256L1440,320L1410,320C1380,320,1320,320,1260,320C1200,320,1140,320,1080,320C1020,320,960,320,900,320C840,320,780,320,720,320C660,320,600,320,540,320C480,320,420,320,360,320C300,320,240,320,180,320C120,320,60,320,30,320L0,320Z"></path></svg>';
            break;
            case 'Wavy 2':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,224L48,240C96,256,192,288,288,256C384,224,480,128,576,80C672,32,768,32,864,69.3C960,107,1056,181,1152,176C1248,171,1344,85,1392,42.7L1440,0L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>';
            break;
            case 'Wavy 3':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,160L48,144C96,128,192,96,288,96C384,96,480,128,576,122.7C672,117,768,75,864,96C960,117,1056,203,1152,229.3C1248,256,1344,224,1392,208L1440,192L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>';
            break;
            case 'Angle 1':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,288L1440,0L1440,320L0,320Z"></path></svg>';
            break;
            case 'Angle 2':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,128L720,288L1440,64L1440,320L720,320L0,320Z"></path></svg>';
            break;
            case 'Angle 3':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,192L720,0L1440,160L1440,320L720,320L0,320Z"></path></svg>';
            break;
            case 'Valley 1':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,0L48,32C96,64,192,128,288,165.3C384,203,480,213,576,208C672,203,768,181,864,176C960,171,1056,181,1152,160C1248,139,1344,85,1392,58.7L1440,32L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>';
            break;
            case 'Valley 2':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,32L40,64C80,96,160,160,240,181.3C320,203,400,181,480,197.3C560,213,640,267,720,261.3C800,256,880,192,960,154.7C1040,117,1120,107,1200,85.3C1280,64,1360,32,1400,16L1440,0L1440,320L1400,320C1360,320,1280,320,1200,320C1120,320,1040,320,960,320C880,320,800,320,720,320C640,320,560,320,480,320C400,320,320,320,240,320C160,320,80,320,40,320L0,320Z"></path></svg>';
            break;
            case 'Valley 3':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,64L48,85.3C96,107,192,149,288,192C384,235,480,277,576,261.3C672,245,768,171,864,128C960,85,1056,75,1152,58.7C1248,43,1344,21,1392,10.7L1440,0L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>';
            break;
            case 'Cave 1':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,32L80,192L160,32L240,256L320,128L400,224L480,192L560,288L640,256L720,128L800,0L880,160L960,288L1040,32L1120,96L1200,256L1280,32L1360,160L1440,96L1440,320L1360,320L1280,320L1200,320L1120,320L1040,320L960,320L880,320L800,320L720,320L640,320L560,320L480,320L400,320L320,320L240,320L160,320L80,320L0,320Z"></path></svg>';
            break;
            case 'Cave 2':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,96L68.6,32L137.1,224L205.7,256L274.3,32L342.9,288L411.4,256L480,64L548.6,192L617.1,224L685.7,288L754.3,96L822.9,192L891.4,128L960,192L1028.6,96L1097.1,96L1165.7,0L1234.3,256L1302.9,320L1371.4,64L1440,64L1440,320L1371.4,320L1302.9,320L1234.3,320L1165.7,320L1097.1,320L1028.6,320L960,320L891.4,320L822.9,320L754.3,320L685.7,320L617.1,320L548.6,320L480,320L411.4,320L342.9,320L274.3,320L205.7,320L137.1,320L68.6,320L0,320Z"></path></svg>';
            break;
            case 'Cave 3':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,32L51.4,96L102.9,96L154.3,64L205.7,256L257.1,224L308.6,224L360,224L411.4,256L462.9,192L514.3,96L565.7,128L617.1,288L668.6,96L720,128L771.4,224L822.9,256L874.3,224L925.7,288L977.1,96L1028.6,160L1080,192L1131.4,128L1182.9,288L1234.3,256L1285.7,96L1337.1,32L1388.6,64L1440,96L1440,320L1388.6,320L1337.1,320L1285.7,320L1234.3,320L1182.9,320L1131.4,320L1080,320L1028.6,320L977.1,320L925.7,320L874.3,320L822.9,320L771.4,320L720,320L668.6,320L617.1,320L565.7,320L514.3,320L462.9,320L411.4,320L360,320L308.6,320L257.1,320L205.7,320L154.3,320L102.9,320L51.4,320L0,320Z"></path></svg>';
            break;
            case 'Curvy 1':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,160L120,181.3C240,203,480,245,720,224C960,203,1200,117,1320,74.7L1440,32L1440,320L1320,320C1200,320,960,320,720,320C480,320,240,320,120,320L0,320Z"></path></svg>';
            break;
            case 'Curvy 2':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,128L120,117.3C240,107,480,85,720,112C960,139,1200,213,1320,250.7L1440,288L1440,320L1320,320C1200,320,960,320,720,320C480,320,240,320,120,320L0,320Z"></path></svg>';
            break;
            case 'Curvy 3':
                $svg_shape = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320" preserveAspectRatio="none"><path fill="currentColor" fill-opacity="1" d="M0,128L80,154.7C160,181,320,235,480,261.3C640,288,800,288,960,240C1120,192,1280,96,1360,48L1440,0L1440,320L1360,320C1280,320,1120,320,960,320C800,320,640,320,480,320C320,320,160,320,80,320L0,320Z"></path></svg>';
            break;
            case 'Diamond 1':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Diamonds-Row" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1420,140 L1440,160 L1440,320 L0,320 L0,160 L20,140 L90,210 L160,140 L230,210 L300,140 L370,210 L440,140 L510,210 L580,140 L650,210 L720,140 L790,210 L860,140 L930,210 L1000,140 L1070,210 L1140,140 L1210,210 L1280,140 L1350,210 L1420,140 Z M650,120 L670,140 L650,160 L630,140 L650,120 Z M790,120 L810,140 L790,160 L770,140 L790,120 Z M90,120 L110,140 L90,160 L70,140 L90,120 Z M930,120 L950,140 L930,160 L910,140 L930,120 Z M230,120 L250,140 L230,160 L210,140 L230,120 Z M1070,120 L1090,140 L1070,160 L1050,140 L1070,120 Z M370,120 L390,140 L370,160 L350,140 L370,120 Z M1210,120 L1230,140 L1210,160 L1190,140 L1210,120 Z M510,120 L530,140 L510,160 L490,140 L510,120 Z M1350,120 L1370,140 L1350,160 L1330,140 L1350,120 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Diamond 2':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Diamonds-Row-V2" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1350,140 L1420,210 L1440,189.999 L1440,319.999 L0,319.999 L0,189.999 L20,210 L90,140 L160,210 L230,140 L300,210 L370,140 L440,210 L510,140 L580,210 L650,140 L720,210 L790,140 L860,210 L930,140 L1000,210 L1070,140 L1140,210 L1210,140 L1280,210 L1350,140 Z M160,80 L200.125,120 L160,160 L120,120 L160,80 Z M440,80 L480.125,120 L440,160 L400,120 L440,80 Z M720,80 L760.125,120 L720,160 L680,120 L720,80 Z M1280,80 L1320.125,120 L1280,160 L1240,120 L1280,80 Z M1000,80 L1040.125,120 L1000,160 L960,120 L1000,80 Z M860,120 L880,140 L860,160 L840,140 L860,120 Z M300,120 L320,140 L300,160 L280,140 L300,120 Z M1140,120 L1160,140 L1140,160 L1120,140 L1140,120 Z M580,120 L600,140 L580,160 L560,140 L580,120 Z M1420,120 L1440,140 L1420,160 L1400,140 L1420,120 Z M20,120 L40,140 L20,160 L0,140 L20,120 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Diamond 3':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Diamonds-Row-V4" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1420,140 L1440,160 L1440,320 L0,320 L0,160 L20,140 L90,210 L160,140 L230,210 L300,140 L370,210 L440,140 L510,210 L580,140 L650,210 L720,140 L790,210 L860,140 L930,210 L1000,140 L1070,210 L1140,140 L1210,210 L1280,140 L1350,210 L1420,140 Z M860,190 L840,210 L860,230 L880,210 L860,190 Z M720,190 L700,210 L720,230 L740,210 L720,190 Z M1280,190 L1260,210 L1280,230 L1300,210 L1280,190 Z M1420,190 L1400,210 L1420,230 L1440,210 L1420,190 Z M1000,190 L980,210 L1000,230 L1020,210 L1000,190 Z M1140,190 L1120,210 L1140,230 L1160,210 L1140,190 Z M440,190 L420,210 L440,230 L460,210 L440,190 Z M580,190 L560,210 L580,230 L600,210 L580,190 Z M160,190 L140,210 L160,230 L180,210 L160,190 Z M20,190 L0,210 L20,230 L40,210 L20,190 Z M300,190 L280,210 L300,230 L320,210 L300,190 Z M1350,120 L1370,140 L1350,160 L1330,140 L1350,120 Z M650,120 L670,140 L650,160 L630,140 L650,120 Z M790,120 L810,140 L790,160 L770,140 L790,120 Z M90,120 L110,140 L90,160 L70,140 L90,120 Z M930,120 L950,140 L930,160 L910,140 L930,120 Z M230,120 L250,140 L230,160 L210,140 L230,120 Z M1070,120 L1090,140 L1070,160 L1050,140 L1070,120 Z M370,120 L390,140 L370,160 L350,140 L370,120 Z M1210,120 L1230,140 L1210,160 L1190,140 L1210,120 Z M510,120 L530,140 L510,160 L490,140 L510,120 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Ocean 1':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none" >
                <g id="Ocean-Waves" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M60.0736562,199.999824 C74.730684,216.560111 96.1461381,227.000176 120,227.000176 C143.853862,227.000176 165.269316,216.560111 179.926344,199.999824 L180.073656,199.999824 C194.730684,216.560111 216.146138,227.000176 240,227.000176 C263.853862,227.000176 285.269316,216.560111 299.926344,199.999824 L300.073656,199.999824 C314.730684,216.560111 336.146138,227.000176 360,227.000176 C383.853862,227.000176 405.269316,216.560111 419.926344,199.999824 L420.073656,199.999824 C434.730684,216.560111 456.146138,227.000176 480,227.000176 C503.853862,227.000176 525.269316,216.560111 539.926344,199.999824 L540.073656,199.999824 C554.730684,216.560111 576.146138,227.000176 600,227.000176 C623.853862,227.000176 645.269316,216.560111 659.926344,199.999824 L660.073656,199.999824 C674.730684,216.559935 696.146138,227 720,227 C743.853862,227 765.269316,216.559935 779.926344,199.999824 L780.073656,199.999824 C794.730684,216.560111 816.146138,227.000176 840,227.000176 C863.853862,227.000176 885.269316,216.560111 899.926344,199.999824 L900.073656,199.999824 C914.730684,216.560111 936.146138,227.000176 960,227.000176 C983.853862,227.000176 1005.26932,216.560111 1019.92634,199.999824 L1020.07366,199.999824 C1034.73068,216.560111 1056.14614,227.000176 1080,227.000176 C1103.85386,227.000176 1125.26932,216.560111 1139.92634,199.999824 L1140.07366,199.999824 C1154.73068,216.560111 1176.14614,227.000176 1200,227.000176 C1223.85386,227.000176 1245.26932,216.560111 1259.92634,199.999824 L1260.07366,199.999824 C1274.73068,216.560111 1296.14614,227.000176 1320,227.000176 C1343.85386,227.000176 1365.26932,216.560111 1379.92634,199.999824 L1380.07366,199.999824 C1394.73068,216.560111 1416.14614,227.000176 1440,227.000176 L1440,319.999824 L0,319.999824 L0,227.000176 C23.8538619,227.000176 45.269316,216.560111 59.9263438,199.999824 L60.0736562,199.999824 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Ocean 2':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Ocean-Waves-V3" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M80.4498531,180.001982 C79.5061138,183.170363 79,186.526077 79,190 C79,209.329966 94.6700338,225 114,225 C116.017528,225 117.995186,224.829295 119.919317,224.50154 C135.639617,220.472153 149.49469,211.78606 159.926344,199.999824 L159.997066,199.999031 C169.013103,187.996324 183.305241,180.183257 199.430131,180.003181 L200,180 C200.150106,180 200.300058,180 200.449853,180.001982 C199.506114,183.170363 199,186.526077 199,190 C199,209.329966 214.670034,225 234,225 C236.017528,225 237.995186,224.829295 239.919317,224.50154 C255.639617,220.472153 269.49469,211.78606 279.926344,199.999824 L279.997066,199.999031 C289.013103,187.996324 303.305241,180.183257 319.430131,180.003181 L320,180 C320.150106,180 320.300058,180 320.449853,180.001982 C319.506114,183.170363 319,186.526077 319,190 C319,209.329966 334.670034,225 354,225 C356.017528,225 357.995186,224.829295 359.919317,224.50154 C375.639617,220.472153 389.49469,211.78606 399.926344,199.999824 L399.997066,199.999031 C409.013103,187.996324 423.305241,180.183257 439.430131,180.003181 L440,180 C440.150106,180 440.300058,180 440.449853,180.001982 C439.506114,183.170363 439,186.526077 439,190 C439,209.329966 454.670034,225 474,225 C476.017528,225 477.995186,224.829295 479.919317,224.50154 C495.639617,220.472153 509.49469,211.78606 519.926344,199.999824 L519.997066,199.999031 C529.013103,187.996324 543.305241,180.183257 559.430131,180.003181 L560,180 C560.150106,180 560.300058,180 560.449853,180.001982 C559.506114,183.170363 559,186.526077 559,190 C559,209.329966 574.670034,225 594,225 C596.017528,225 597.995186,224.829295 599.919317,224.50154 C615.639617,220.472153 629.49469,211.78606 639.926344,199.999824 L639.997066,199.999031 C649.013103,187.996324 663.305241,180.183257 679.430131,180.003181 L680,180 C680.150106,180 680.300058,180 680.449853,180.001982 C679.506114,183.170363 679,186.526077 679,190 C679,209.329966 694.670034,225 714,225 C716.017528,225 717.995186,224.829295 719.919317,224.50154 C735.639617,220.471991 749.49469,211.785934 759.926344,199.999824 L759.997066,199.999031 C769.013103,187.996324 783.305241,180.183257 799.430131,180.003181 L800,180 C800.150106,180 800.300058,180 800.449853,180.001982 C799.506114,183.170363 799,186.526077 799,190 C799,209.329966 814.670034,225 834,225 C836.017528,225 837.995186,224.829295 839.919317,224.50154 C855.639617,220.472153 869.49469,211.78606 879.926344,199.999824 L879.997066,199.999031 C889.013103,187.996324 903.305241,180.183257 919.430131,180.003181 L920,180 C920.150106,180 920.300058,180 920.449853,180.001982 C919.506114,183.170363 919,186.526077 919,190 C919,209.329966 934.670034,225 954,225 C956.017528,225 957.995186,224.829295 959.919317,224.50154 C975.639617,220.472153 989.49469,211.78606 999.926344,199.999824 L999.997066,199.999031 C1009.0131,187.996324 1023.30524,180.183257 1039.43013,180.003181 L1040,180 C1040.15011,180 1040.30006,180 1040.44985,180.001982 C1039.50611,183.170363 1039,186.526077 1039,190 C1039,209.329966 1054.67003,225 1074,225 C1076.01753,225 1077.99519,224.829295 1079.91932,224.50154 C1095.63962,220.472153 1109.49469,211.78606 1119.92634,199.999824 L1119.99707,199.999031 C1129.0131,187.996324 1143.30524,180.183257 1159.43013,180.003181 L1160,180 C1160.15011,180 1160.30006,180 1160.44985,180.001982 C1159.50611,183.170363 1159,186.526077 1159,190 C1159,209.329966 1174.67003,225 1194,225 C1196.01753,225 1197.99519,224.829295 1199.91932,224.50154 C1215.63962,220.472153 1229.49469,211.78606 1239.92634,199.999824 L1239.99707,199.999031 C1249.0131,187.996324 1263.30524,180.183257 1279.43013,180.003181 L1280,180 C1280.15011,180 1280.30006,180 1280.44985,180.001982 C1279.50611,183.170363 1279,186.526077 1279,190 C1279,209.329966 1294.67003,225 1314,225 C1316.01753,225 1317.99519,224.829295 1319.91932,224.50154 C1335.63962,220.472153 1349.49469,211.78606 1359.92634,199.999824 L1359.99707,199.999031 C1369.0131,187.996324 1383.30524,180.183257 1399.43013,180.003181 L1400,180 C1400.15011,180 1400.30006,180 1400.44985,180.001982 C1399.50611,183.170363 1399,186.526077 1399,190 C1399,209.329966 1414.67003,225 1434,225 C1436.04618,225 1438.05135,224.824412 1440.00126,224.487481 L1440.00126,320 L0,320 L0,224.47974 C15.6876595,220.442018 29.5127798,211.765621 39.9263438,199.999824 L39.9970658,199.999031 C49.0131027,187.996324 63.3052408,180.183257 79.4301308,180.003181 L80,180 C80.1501064,180 80.3000584,180 80.4498531,180.001982 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Ocean 3':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Ocean-Waves-V4" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M160.571131,180 C176.506317,180.177958 190.65162,187.810363 199.683798,199.573971 L200.004196,199.995851 L200.074918,199.996643 C210.320654,211.572818 223.868867,220.158371 239.243204,224.278489 L240.081945,224.498359 C242.006076,224.826114 244.03971,225.042703 246.001262,224.996819 L247.293481,224.958854 C260.076977,224.505055 268.699582,221.826983 273.161296,216.924636 L273.380916,216.677666 C276.577933,212.997385 276.255185,207.458673 272.701497,204.171769 L272.382603,203.890292 C268.127534,200.308276 266,196.843785 266,193.496819 C266,186.144529 271.877429,180.164985 279.190169,180 L280.571131,180 C296.506317,180.177958 310.65162,187.810363 319.683798,199.573971 L320.004196,199.995851 L320.074918,199.996643 C330.488616,211.762592 344.313959,220.439061 360.000784,224.477511 L360,224.480663 L360.081945,224.50154 C362.006076,224.829295 364.03971,225.045884 366.001262,225 L367.293481,224.962034 C380.076977,224.508236 388.699582,221.830163 393.161296,216.927817 L393.380916,216.680847 C396.577933,213.000565 396.255185,207.461853 392.701497,204.17495 L392.382603,203.893473 C388.127534,200.311456 386,196.846965 386,193.5 C386,186.147709 391.877429,180.168166 399.190169,180.003181 L400.571131,180.003181 C416.506317,180.181138 430.65162,187.813543 439.683798,199.577152 L440.004196,199.999031 L440.074918,199.999824 C450.488395,211.765522 464.31337,220.441871 479.999782,224.480433 L480,224.477482 L480.081945,224.498359 C482.006076,224.826114 484.03971,225.042703 486.001262,224.996819 L487.293481,224.958854 C500.076977,224.505055 508.699582,221.826983 513.161296,216.924636 L513.380916,216.677666 C516.577933,212.997385 516.255185,207.458673 512.701497,204.171769 L512.382603,203.890292 C508.127534,200.308276 506,196.843785 506,193.496819 C506,186.144529 511.877429,180.164985 519.190169,180 L520.571131,180 C536.506317,180.177958 550.65162,187.810363 559.683798,199.573971 L560.004196,199.995851 L560.074918,199.996643 C570.320654,211.572818 583.868867,220.158371 599.243204,224.278489 L600.081945,224.498359 C602.006076,224.826114 604.03971,225.042703 606.001262,224.996819 L607.293481,224.958854 C620.076977,224.505055 628.699582,221.826983 633.161296,216.924636 L633.380916,216.677666 C636.577933,212.997385 636.255185,207.458673 632.701497,204.171769 L632.382603,203.890292 C628.127534,200.308276 626,196.843785 626,193.496819 C626,186.144529 631.877429,180.164985 639.190169,180 L640.571131,180 C656.506317,180.177958 670.65162,187.810363 679.683798,199.573971 L680.004196,199.995851 L680.074918,199.996643 C690.488616,211.762592 704.313959,220.439061 720.000784,224.477511 L720,224.48 L720.081945,224.50154 C722.006076,224.829295 724.03971,225.045884 726.001262,225 L727.293481,224.962034 C740.076977,224.508236 748.699582,221.830163 753.161296,216.927817 L753.380916,216.680847 C756.577933,213.000565 756.255185,207.461853 752.701497,204.17495 L752.382603,203.893473 C748.127534,200.311456 746,196.846965 746,193.5 C746,186.147709 751.877429,180.168166 759.190169,180.003181 L760.571131,180.003181 C776.506317,180.181138 790.65162,187.813543 799.683798,199.577152 L800.004196,199.999031 L800.074918,199.999824 C810.488395,211.765522 824.31337,220.441871 839.999782,224.480433 L840,224.477482 L840.081945,224.498359 C842.006076,224.826114 844.03971,225.042703 846.001262,224.996819 L847.293481,224.958854 C860.076977,224.505055 868.699582,221.826983 873.161296,216.924636 L873.380916,216.677666 C876.577933,212.997385 876.255185,207.458673 872.701497,204.171769 L872.382603,203.890292 C868.127534,200.308276 866,196.843785 866,193.496819 C866,186.144529 871.877429,180.164985 879.190169,180 L880.571131,180 C896.506317,180.177958 910.65162,187.810363 919.683798,199.573971 L920.004196,199.995851 L920.074918,199.996643 C930.320654,211.572818 943.868867,220.158371 959.243204,224.278489 L960.081945,224.498359 C962.006076,224.826114 964.03971,225.042703 966.001262,224.996819 L967.293481,224.958854 C980.076977,224.505055 988.699582,221.826983 993.161296,216.924636 L993.380916,216.677666 C996.577933,212.997385 996.255185,207.458673 992.701497,204.171769 L992.382603,203.890292 C988.127534,200.308276 986,196.843785 986,193.496819 C986,186.144529 991.877429,180.164985 999.190169,180 L1000.57113,180 C1016.50632,180.177958 1030.65162,187.810363 1039.6838,199.573971 L1040.0042,199.995851 L1040.07492,199.996643 C1050.48862,211.762592 1064.31396,220.439061 1080.00078,224.477511 L1080,224.480663 L1080.08194,224.50154 C1082.00608,224.829295 1084.03971,225.045884 1086.00126,225 L1087.29348,224.962034 C1100.07698,224.508236 1108.69958,221.830163 1113.1613,216.927817 L1113.38092,216.680847 C1116.57793,213.000565 1116.25519,207.461853 1112.7015,204.17495 L1112.3826,203.893473 C1108.12753,200.311456 1106,196.846965 1106,193.5 C1106,186.147709 1111.87743,180.168166 1119.19017,180.003181 L1120.57113,180.003181 C1136.50632,180.181138 1150.65162,187.813543 1159.6838,199.577152 L1160.0042,199.999031 L1160.07492,199.999824 C1170.48839,211.765522 1184.31337,220.441871 1199.99978,224.480433 L1200,224.477482 L1200.08194,224.498359 C1202.00608,224.826114 1204.03971,225.042703 1206.00126,224.996819 L1207.29348,224.958854 C1220.07698,224.505055 1228.69958,221.826983 1233.1613,216.924636 L1233.38092,216.677666 C1236.57793,212.997385 1236.25519,207.458673 1232.7015,204.171769 L1232.3826,203.890292 C1228.12753,200.308276 1226,196.843785 1226,193.496819 C1226,186.144529 1231.87743,180.164985 1239.19017,180 L1240.57113,180 C1256.50632,180.177958 1270.65162,187.810363 1279.6838,199.573971 L1280.0042,199.995851 L1280.07492,199.996643 C1290.32065,211.572818 1303.86887,220.158371 1319.2432,224.278489 L1320.08194,224.498359 C1322.00608,224.826114 1324.03971,225.042703 1326.00126,224.996819 L1327.29348,224.958854 C1340.07698,224.505055 1348.69958,221.826983 1353.1613,216.924636 L1353.38092,216.677666 C1356.57793,212.997385 1356.25519,207.458673 1352.7015,204.171769 L1352.3826,203.890292 C1348.12753,200.308276 1346,196.843785 1346,193.496819 C1346,186.144529 1351.87743,180.164985 1359.19017,180 L1360.57113,180 C1376.50632,180.177958 1390.65162,187.810363 1399.6838,199.573971 L1400.0042,199.995851 L1400.07492,199.996643 C1410.48862,211.762592 1424.31396,220.439061 1440.00078,224.477511 L1440.00078,319.996819 L1200,319.996 L1200.00078,320 L1080,320 L1080.00078,319.996819 L840,319.996 L840.000784,320 L720,320 L719.999,319.996 L480,319.996 L480.000784,320 L360,320 L360.000784,319.996819 L120,319.996 L120.000784,320 L4.54747351e-13,320 L4.54747351e-13,224.480663 L0.0819447814,224.50154 C2.00607645,224.829295 4.0397102,225.045884 6.00126213,225 L7.29348133,224.962034 C20.076977,224.508236 28.699582,221.830163 33.1612964,216.927817 L33.3809156,216.680847 C36.5779329,213.000565 36.2551852,207.461853 32.7014967,204.17495 L32.3826031,203.893473 C28.1275344,200.311456 26,196.846965 26,193.5 C26,186.147709 31.8774286,180.168166 39.1901692,180.003181 L40.5711313,180.003181 C56.5063168,180.181138 70.6516202,187.813543 79.6837981,199.577152 L80.0041964,199.999031 L80.0749183,199.999824 C90.4883946,211.765522 104.31337,220.441871 119.999782,224.480433 L120,224.477482 L120.081945,224.498359 C122.006076,224.826114 124.03971,225.042703 126.001262,224.996819 L127.293481,224.958854 C140.076977,224.505055 148.699582,221.826983 153.161296,216.924636 L153.380916,216.677666 C156.577933,212.997385 156.255185,207.458673 152.701497,204.171769 L152.382603,203.890292 C148.127534,200.308276 146,196.843785 146,193.496819 C146,186.144529 151.877429,180.164985 159.190169,180 L160.571131,180 Z" id="Path" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Logs 1':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Round-Logs" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1440,204 L1440,320 L0,320 L0,204 C20.7415512,204 37.7958624,219.786951 39.8025451,240.000464 L40.1974549,240.000464 C42.2041376,219.786951 59.2584488,204 80,204 C100.741551,204 117.795862,219.786951 119.802545,240.000464 L120.197455,240.000464 C122.204138,219.786951 139.258449,204 160,204 C180.741551,204 197.795862,219.786951 199.802545,240.000464 L200.197455,240.000464 C202.204138,219.786951 219.258449,204 240,204 C260.741551,204 277.795862,219.786951 279.802545,240.000464 L280.197455,240.000464 C282.204138,219.786951 299.258449,204 320,204 C340.741551,204 357.795862,219.786951 359.802545,240.000464 L360.197455,240.000464 C362.204138,219.786951 379.258449,204 400,204 C420.741551,204 437.795862,219.786951 439.802545,240.000464 L440.197455,240.000464 C442.204138,219.786951 459.258449,204 480,204 C500.741551,204 517.795862,219.786951 519.802545,240.000464 L520.197455,240.000464 C522.204138,219.786951 539.258449,204 560,204 C580.741551,204 597.795862,219.786951 599.802545,240.000464 L600.197455,240.000464 C602.204138,219.786951 619.258449,204 640,204 C660.741551,204 677.795862,219.786951 679.802545,240.000464 L680.197455,240.000464 C682.204138,219.786951 699.258449,204 720,204 C740.741551,204 757.795862,219.786951 759.802545,240.000464 L760.197455,240.000464 C762.204138,219.786951 779.258449,204 800,204 C820.741551,204 837.795862,219.786951 839.802545,240.000464 L840.197455,240.000464 C842.204138,219.786951 859.258449,204 880,204 C900.741551,204 917.795862,219.786951 919.802545,240.000464 L920.197455,240.000464 C922.204138,219.786951 939.258449,204 960,204 C980.741551,204 997.795862,219.786951 999.802545,240.000464 L1000.19745,240.000464 C1002.20414,219.786951 1019.25845,204 1040,204 C1060.74155,204 1077.79586,219.786951 1079.80255,240.000464 L1080.19745,240.000464 C1082.20414,219.786951 1099.25845,204 1120,204 C1140.74155,204 1157.79586,219.786951 1159.80255,240.000464 L1160.19745,240.000464 C1162.20414,219.786951 1179.25845,204 1200,204 C1220.74155,204 1237.79586,219.786951 1239.80255,240.000464 L1240.19745,240.000464 C1242.20414,219.786951 1259.25845,204 1280,204 C1300.74155,204 1317.79586,219.786951 1319.80255,240.000464 L1320.19745,240.000464 C1322.20414,219.786951 1339.25845,204 1360,204 C1380.74155,204 1397.79586,219.786951 1399.80255,240.000464 L1400.19745,240.000464 C1402.20414,219.786951 1419.25845,204 1440,204 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Logs 2':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Round-Logs-V2" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1350,190 C1377.3381,190 1399.55176,211.940286 1399.9933,239.173159 L1400,240 L1400.19745,240.000464 C1402.20414,219.786951 1419.25845,204 1440,204 L1440,320 L0,320 L0,204 C20.7415512,204 37.7958624,219.786951 39.8025451,240.000464 L40,240 L40.0066986,239.173159 C40.4482381,211.940286 62.6619049,190 90,190 C117.338095,190 139.551762,211.940286 139.993301,239.173159 L140,240 L140.197455,240.000464 C142.204138,219.786951 159.258449,204 180,204 C200.741551,204 217.795862,219.786951 219.802545,240.000464 L220,240 L220.006699,239.173159 C220.448238,211.940286 242.661905,190 270,190 C297.338095,190 319.551762,211.940286 319.993301,239.173159 L320,240 L320.197455,240.000464 C322.204138,219.786951 339.258449,204 360,204 C380.741551,204 397.795862,219.786951 399.802545,240.000464 L400,240 L400.006699,239.173159 C400.448238,211.940286 422.661905,190 450,190 C477.338095,190 499.551762,211.940286 499.993301,239.173159 L500,240 L500.197455,240.000464 C502.204138,219.786951 519.258449,204 540,204 C560.741551,204 577.795862,219.786951 579.802545,240.000464 L580,240 L580.006699,239.173159 C580.448238,211.940286 602.661905,190 630,190 C657.338095,190 679.551762,211.940286 679.993301,239.173159 L680,240 L680.197455,240.000464 C682.204138,219.786951 699.258449,204 720,204 C740.741551,204 757.795862,219.786951 759.802545,240.000464 L760,240 L760.006699,239.173159 C760.448238,211.940286 782.661905,190 810,190 C837.338095,190 859.551762,211.940286 859.993301,239.173159 L860,240 L860.197455,240.000464 C862.204138,219.786951 879.258449,204 900,204 C920.741551,204 937.795862,219.786951 939.802545,240.000464 L940,240 L940.006699,239.173159 C940.448238,211.940286 962.661905,190 990,190 C1017.3381,190 1039.55176,211.940286 1039.9933,239.173159 L1040,240 L1040.19745,240.000464 C1042.20414,219.786951 1059.25845,204 1080,204 C1100.74155,204 1117.79586,219.786951 1119.80255,240.000464 L1120,240 L1120.0067,239.173159 C1120.44824,211.940286 1142.6619,190 1170,190 C1197.3381,190 1219.55176,211.940286 1219.9933,239.173159 L1220,240 L1220.19745,240.000464 C1222.20414,219.786951 1239.25845,204 1260,204 C1280.74155,204 1297.79586,219.786951 1299.80255,240.000464 L1300,240 L1300.0067,239.173159 C1300.44824,211.940286 1322.6619,190 1350,190 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Logs 3':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Round-Logs-V3" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1260.00016,180 C1292.80587,180 1319.46227,206.328343 1319.99212,239.00779 L1320,239.942 L1320.00686,239.173159 C1320.4484,211.940286 1342.66206,190 1370.00016,190 C1397.06487,190 1419.10714,211.503674 1419.9737,238.357777 L1419.99346,239.173159 L1420.00016,240 L1420.19761,240.000464 C1421.49943,226.887099 1429.1343,215.636727 1440.00044,209.351123 L1440,320 L-5.68434189e-13,320 L-5.48450174e-13,209.351196 C10.8660744,215.636814 18.5008887,226.88715 19.802704,240.000464 L20.0001589,240 L20.0068575,239.173159 C20.448397,211.940286 42.6620638,190 70.0001589,190 C97.338254,190 119.551921,211.940286 119.99346,239.173159 L120.000159,239.943 L120.008197,239.00779 C120.538045,206.328343 147.194445,180 180.000159,180 C212.805873,180 239.462273,206.328343 239.992121,239.00779 L240,239.942 L240.006857,239.173159 C240.448397,211.940286 262.662064,190 290.000159,190 C317.064873,190 339.107135,211.503674 339.973699,238.357777 L339.99346,239.173159 L340.000159,240 L340.197614,240.000464 C342.204297,219.786951 359.258608,204 380.000159,204 C400.534295,204 417.454566,219.472791 419.738001,239.395398 L419.802704,240.000464 L420.000159,240 L420.004178,239.503895 C420.269102,223.164172 433.597302,210 450.000159,210 C450.404673,210 450.807317,210.008006 451.207941,210.023869 L451.521229,210.037892 L452.537465,210.105785 L453.202231,210.168877 L454.055066,210.27171 L454.320401,210.308769 L454.749705,210.373866 L455.464836,210.496525 C455.71474,210.542517 455.963637,210.591623 456.211408,210.643786 L456.820938,210.778788 L457.556788,210.959766 L458.35114,211.177654 L458.566732,211.240893 L458.963842,211.362026 L459.668263,211.591947 L460.402698,211.852598 L461.264142,212.186353 L462.112673,212.545698 L462.644978,212.787148 L462.917245,212.915548 L463.251296,213.077708 L463.742155,213.325407 L464.296545,213.618994 L464.921058,213.967869 L465.166904,214.11064 L465.481782,214.2981 L466.098718,214.680772 L466.455689,214.911785 L467.042174,215.307206 L467.654913,215.74231 L467.952875,215.962359 L468.337567,216.254976 L468.55027,216.421008 C468.729785,216.562425 468.908133,216.706251 469.084784,216.852059 L469.386742,217.10463 L469.842174,217.498528 L470.380095,217.984858 L470.728638,218.312838 L471.219413,218.792849 L471.409535,218.984789 L471.682386,219.266361 L472.058668,219.666987 L472.49455,220.149964 L472.897313,220.615522 L473.329739,221.137582 L473.827494,221.769514 C474.057963,222.070283 474.282917,222.375613 474.502147,222.68528 L474.705449,222.97607 L475.199394,223.71464 L475.470416,224.140964 L475.908192,224.865106 L476.311374,225.575842 L476.418327,225.772257 L476.689824,226.287238 L477.03425,226.978034 L477.20182,227.331165 C477.341189,227.629897 477.475781,227.931306 477.605499,228.235293 L477.862926,228.85796 C478.059785,229.349772 478.244186,229.848556 478.415511,230.353377 L478.517219,230.658471 C478.735042,231.323836 478.930238,231.999491 479.101883,232.684485 L479.178775,232.998561 L479.264979,233.369611 C479.348078,233.737956 479.424401,234.10887 479.493809,234.482212 L479.59272,235.044031 C479.679481,235.565951 479.752768,236.092426 479.812213,236.623085 L479.859675,237.078002 C479.936989,237.877862 479.982894,238.686909 479.99614,239.503895 L480.000159,240 L480.197614,240.000464 C482.204297,219.786951 499.258608,204 520.000159,204 C540.74171,204 557.796021,219.786951 559.802704,240.000464 L560.000159,240 L560.006857,239.173159 C560.448397,211.940286 582.662064,190 610.000159,190 C637.338254,190 659.551921,211.940286 659.99346,239.173159 L660.000159,239.943 L660.008197,239.00779 C660.538045,206.328343 687.194445,180 720.000159,180 C752.805873,180 779.462273,206.328343 779.992121,239.00779 L780,239.942 L780.006857,239.173159 C780.448397,211.940286 802.662064,190 830.000159,190 C857.064873,190 879.107135,211.503674 879.973699,238.357777 L879.99346,239.173159 L880.000159,240 L880.197614,240.000464 C882.204297,219.786951 899.258608,204 920.000159,204 C940.534295,204 957.454566,219.472791 959.738001,239.395398 L959.802704,240.000464 L960.000159,240 L960.004178,239.503895 C960.269102,223.164172 973.597302,210 990.000159,210 C990.404673,210 990.807317,210.008006 991.207941,210.023869 L991.521229,210.037892 L992.537465,210.105785 L993.202231,210.168877 L994.055066,210.27171 L994.320401,210.308769 L994.749705,210.373866 L995.464836,210.496525 C995.71474,210.542517 995.963637,210.591623 996.211408,210.643786 L996.820938,210.778788 L997.556788,210.959766 L998.35114,211.177654 L998.566732,211.240893 L998.963842,211.362026 L999.668263,211.591947 L1000.4027,211.852598 L1001.26414,212.186353 L1002.11267,212.545698 L1002.64498,212.787148 L1002.91725,212.915548 L1003.2513,213.077708 L1003.74216,213.325407 L1004.29655,213.618994 L1004.92106,213.967869 L1005.1669,214.11064 L1005.48178,214.2981 L1006.09872,214.680772 L1006.45569,214.911785 L1006.84202,215.169995 L1007.37439,215.540253 L1007.65491,215.74231 L1007.95288,215.962359 L1008.33757,216.254976 L1008.55027,216.421008 C1008.72978,216.562425 1008.90813,216.706251 1009.08478,216.852059 L1009.38674,217.10463 L1009.84217,217.498528 L1010.3801,217.984858 L1010.72864,218.312838 L1011.21941,218.792849 L1011.40954,218.984789 L1011.68239,219.266361 L1012.05867,219.666987 L1012.49455,220.149964 L1012.89731,220.615522 L1013.32974,221.137582 L1013.82749,221.769514 C1014.05796,222.070283 1014.28292,222.375613 1014.50215,222.68528 L1014.70545,222.97607 L1015.19939,223.71464 L1015.47042,224.140964 L1015.90819,224.865106 L1016.31137,225.575842 L1016.41833,225.772257 L1016.68982,226.287238 L1017.03425,226.978034 L1017.20182,227.331165 C1017.34119,227.629897 1017.47578,227.931306 1017.6055,228.235293 L1017.86293,228.85796 C1018.05979,229.349772 1018.24419,229.848556 1018.41551,230.353377 L1018.51722,230.658471 C1018.73504,231.323836 1018.93024,231.999491 1019.10188,232.684485 L1019.17877,232.998561 L1019.26498,233.369611 C1019.34808,233.737956 1019.4244,234.10887 1019.49381,234.482212 L1019.59272,235.044031 C1019.67948,235.565951 1019.75277,236.092426 1019.81221,236.623085 L1019.85968,237.078002 C1019.93699,237.877862 1019.98289,238.686909 1019.99614,239.503895 L1020.00016,240 L1020.19761,240.000464 C1022.2043,219.786951 1039.25861,204 1060.00016,204 C1080.74171,204 1097.79602,219.786951 1099.8027,240.000464 L1100.00016,240 L1100.00686,239.173159 C1100.4484,211.940286 1122.66206,190 1150.00016,190 C1177.33825,190 1199.55192,211.940286 1199.99346,239.173159 L1200.00016,239.943 L1200.0082,239.00779 C1200.53804,206.328343 1227.19444,180 1260.00016,180 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Shark 1':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none" >
                <g id="Shark-Teeths" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <polygon fill="currentColor" points="1370 173 1380 253 1390 222 1400 253 1410 222 1420 253 1430 222 1440 253 1440 333 0 333 0 253 10 222 20 253 30 222 40 253 50 222 60 253 70 173 80 253 90 222 100 253 110 222 120 253 130 222 140 253 150 222 160 253 170 173 180 253 190 222 200 253 210 222 220 253 230 222 240 253 250 222 260 253 270 173 280 253 290 222 300 253 310 222 320 253 330 222 340 253 350 222 360 253 370 173 380 253 390 222 400 253 410 222 420 253 430 222 440 253 450 222 460 253 470 173 480 253 490 222 500 253 510 222 520 253 530 222 540 253 550 222 560 253 570 173 580 253 590 222 600 253 610 222 620 253 630 222 640 253 650 222 660 253 670 173 680 253 690 222 700 253 710 222 720 253 730 222 740 253 750 222 760 253 770 173 780 253 790 222 800 253 810 222 820 253 830 222 840 253 850 222 860 253 870 173 880 253 890 222 900 253 910 222 920 253 930 222 940 253 950 222 960 253 970 173 980 253 990 222 1000 253 1010 222 1020 253 1030 222 1040 253 1050 222 1060 253 1070 173 1080 253 1090 222 1100 253 1110 222 1120 253 1130 222 1140 253 1150 222 1160 253 1170 173 1180 253 1190 222 1200 253 1210 222 1220 253 1230 222 1240 253 1250 222 1260 253 1270 173 1280 253 1290 222 1300 253 1310 222 1320 253 1330 222 1340 253 1350 222 1360 253"></polygon>
                </g>
            </svg>';
            break;
            case 'Shark 2':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Shark-Teeths-V2" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <polygon fill="currentColor" points="1410 160 1420 240 1430 209 1440 240 1440 320 0 320 0 240 10 160 20 240 30 209 40 240 50 160 60 240 70 209 80 240 90 160 100 240 110 209 120 240 130 160 140 240 150 209 160 240 170 160 180 240 190 209 200 240 210 160 220 240 230 209 240 240 250 160 260 240 270 209 280 240 290 160 300 240 310 209 320 240 330 160 340 240 350 209 360 240 370 160 380 240 390 209 400 240 410 160 420 240 430 209 440 240 450 160 460 240 470 209 480 240 490 160 500 240 510 209 520 240 530 160 540 240 550 209 560 240 570 160 580 240 590 209 600 240 610 160 620 240 630 209 640 240 650 160 660 240 670 209 680 240 690 160 700 240 710 209 720 240 730 160 740 240 750 209 760 240 770 160 780 240 790 209 800 240 810 160 820 240 830 209 840 240 850 160 860 240 870 209 880 240 890 160 900 240 910 209 920 240 930 160 940 240 950 209 960 240 970 160 980 240 990 209 1000 240 1010 160 1020 240 1030 209 1040 240 1050 160 1060 240 1070 209 1080 240 1090 160 1100 240 1110 209 1120 240 1130 160 1140 240 1150 209 1160 240 1170 160 1180 240 1190 209 1200 240 1210 160 1220 240 1230 209 1240 240 1250 160 1260 240 1270 209 1280 240 1290 160 1300 240 1310 209 1320 240 1330 160 1340 240 1350 209 1360 240 1370 160 1380 240 1390 209 1400 240"></polygon>
                </g>
            </svg>';
            break;
            case 'Shark 3':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Shark-Teeths-V3" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <polygon fill="currentColor" points="0 320 0 240 10 209 20 240 30 209 40 240 50 209 60 240 70 209 80 240 90 209 100 240 110 209 120 240 130 209 140 240 150 209 160 240 170 209 180 240 190 209 200 240 210 209 220 240 230 209 240 240 250 209 260 240 270 209 280 240 290 209 300 240 310 209 320 240 330 209 340 240 350 209 360 240 370 209 380 240 390 209 400 240 410 209 420 240 430 209 440 240 450 209 460 240 470 209 480 240 490 209 500 240 510 209 520 240 530 209 540 240 550 209 560 240 570 209 580 240 590 209 600 240 610 209 620 240 630 209 640 240 650 209 660 240 670 209 680 240 690 209 700 240 710 209 720 240 730 209 740 240 750 209 760 240 770 209 780 240 790 209 800 240 810 209 820 240 830 209 840 240 850 209 860 240 870 209 880 240 890 209 900 240 910 209 920 240 930 209 940 240 950 209 960 240 970 209 980 240 990 209 1000 240 1010 209 1020 240 1030 209 1040 240 1050 209 1060 240 1070 209 1080 240 1090 209 1100 240 1110 209 1120 240 1130 209 1140 240 1150 209 1160 240 1170 209 1180 240 1190 209 1200 240 1210 209 1220 240 1230 209 1240 240 1250 209 1260 240 1270 209 1280 240 1290 209 1300 240 1310 209 1320 240 1330 209 1340 240 1350 209 1360 240 1370 209 1380 240 1390 209 1400 240 1410 209 1420 240 1430 209 1440 240 1440 320"></polygon>
                </g>
            </svg>';
            break;
            case 'Balance 1':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none" >
                <g id="Yin-Yang" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M1400,160 C1421.87048,160 1439.64141,177.552229 1440,199.338527 L1440,200 L1440,320 L0,320 L0,200 C0,222.09139 17.90861,240 40,240 C61.8704761,240 79.6414095,222.447771 79.9946411,200.661473 L80.0053589,199.338527 C80.3585905,177.552229 98.1295239,160 120,160 C141.870476,160 159.64141,177.552229 159.994641,199.338527 L160,200 C160,222.09139 177.90861,240 200,240 C221.870476,240 239.64141,222.447771 239.994641,200.661473 L240.005359,199.338527 C240.35859,177.552229 258.129524,160 280,160 C301.870476,160 319.64141,177.552229 319.994641,199.338527 L320,200 C320,222.09139 337.90861,240 360,240 C381.870476,240 399.64141,222.447771 399.994641,200.661473 L400.005359,199.338527 C400.35859,177.552229 418.129524,160 440,160 C461.870476,160 479.64141,177.552229 479.994641,199.338527 L480,200 C480,222.09139 497.90861,240 520,240 C541.870476,240 559.64141,222.447771 559.994641,200.661473 L560.005359,199.338527 C560.35859,177.552229 578.129524,160 600,160 C621.870476,160 639.64141,177.552229 639.994641,199.338527 L640,200 C640,222.09139 657.90861,240 680,240 C701.870476,240 719.64141,222.447771 719.994641,200.661473 L720.005359,199.338527 C720.35859,177.552229 738.129524,160 760,160 C781.870476,160 799.64141,177.552229 799.994641,199.338527 L800,200 C800,222.09139 817.90861,240 840,240 C861.870476,240 879.64141,222.447771 879.994641,200.661473 L880.005359,199.338527 C880.35859,177.552229 898.129524,160 920,160 C941.870476,160 959.64141,177.552229 959.994641,199.338527 L960,200 C960,222.09139 977.90861,240 1000,240 C1021.87048,240 1039.64141,222.447771 1039.99464,200.661473 L1040.00536,199.338527 C1040.35859,177.552229 1058.12952,160 1080,160 C1101.87048,160 1119.64141,177.552229 1119.99464,199.338527 L1120,200 C1120,222.09139 1137.90861,240 1160,240 C1181.87048,240 1199.64141,222.447771 1199.99464,200.661473 L1200.00536,199.338527 C1200.35859,177.552229 1218.12952,160 1240,160 C1261.87048,160 1279.64141,177.552229 1279.99464,199.338527 L1280,200 C1280,222.09139 1297.90861,240 1320,240 C1341.87048,240 1359.64141,222.447771 1359.99464,200.661473 L1360.00536,199.338527 C1360.35859,177.552229 1378.12952,160 1400,160 Z M440,190 C434.477153,190 430,194.477153 430,200 C430,205.522847 434.477153,210 440,210 C445.522847,210 450,205.522847 450,200 C450,194.477153 445.522847,190 440,190 Z M520,190 C525.522847,190 530,194.477153 530,200 C530,205.522847 525.522847,210 520,210 C514.477153,210 510,205.522847 510,200 C510,194.477153 514.477153,190 520,190 Z M280,190 C274.477153,190 270,194.477153 270,200 C270,205.522847 274.477153,210 280,210 C285.522847,210 290,205.522847 290,200 C290,194.477153 285.522847,190 280,190 Z M360,190 C365.522847,190 370,194.477153 370,200 C370,205.522847 365.522847,210 360,210 C354.477153,210 350,205.522847 350,200 C350,194.477153 354.477153,190 360,190 Z M40,190 C45.5228475,190 50,194.477153 50,200 C50,205.522847 45.5228475,210 40,210 C34.4771525,210 30,205.522847 30,200 C30,194.477153 34.4771525,190 40,190 Z M760,190 C754.477153,190 750,194.477153 750,200 C750,205.522847 754.477153,210 760,210 C765.522847,210 770,205.522847 770,200 C770,194.477153 765.522847,190 760,190 Z M840,190 C845.522847,190 850,194.477153 850,200 C850,205.522847 845.522847,210 840,210 C834.477153,210 830,205.522847 830,200 C830,194.477153 834.477153,190 840,190 Z M920,190 C914.477153,190 910,194.477153 910,200 C910,205.522847 914.477153,210 920,210 C925.522847,210 930,205.522847 930,200 C930,194.477153 925.522847,190 920,190 Z M1000,190 C1005.52285,190 1010,194.477153 1010,200 C1010,205.522847 1005.52285,210 1000,210 C994.477153,210 990,205.522847 990,200 C990,194.477153 994.477153,190 1000,190 Z M1080,190 C1074.47715,190 1070,194.477153 1070,200 C1070,205.522847 1074.47715,210 1080,210 C1085.52285,210 1090,205.522847 1090,200 C1090,194.477153 1085.52285,190 1080,190 Z M1160,190 C1165.52285,190 1170,194.477153 1170,200 C1170,205.522847 1165.52285,210 1160,210 C1154.47715,210 1150,205.522847 1150,200 C1150,194.477153 1154.47715,190 1160,190 Z M1240,190 C1234.47715,190 1230,194.477153 1230,200 C1230,205.522847 1234.47715,210 1240,210 C1245.52285,210 1250,205.522847 1250,200 C1250,194.477153 1245.52285,190 1240,190 Z M1320,190 C1325.52285,190 1330,194.477153 1330,200 C1330,205.522847 1325.52285,210 1320,210 C1314.47715,210 1310,205.522847 1310,200 C1310,194.477153 1314.47715,190 1320,190 Z M680,190 C685.522847,190 690,194.477153 690,200 C690,205.522847 685.522847,210 680,210 C674.477153,210 670,205.522847 670,200 C670,194.477153 674.477153,190 680,190 Z M600,190 C594.477153,190 590,194.477153 590,200 C590,205.522847 594.477153,210 600,210 C605.522847,210 610,205.522847 610,200 C610,194.477153 605.522847,190 600,190 Z M1400,190 C1394.47715,190 1390,194.477153 1390,200 C1390,205.522847 1394.47715,210 1400,210 C1405.52285,210 1410,205.522847 1410,200 C1410,194.477153 1405.52285,190 1400,190 Z M200,190 C205.522847,190 210,194.477153 210,200 C210,205.522847 205.522847,210 200,210 C194.477153,210 190,205.522847 190,200 C190,194.477153 194.477153,190 200,190 Z M120,190 C114.477153,190 110,194.477153 110,200 C110,205.522847 114.477153,210 120,210 C125.522847,210 130,205.522847 130,200 C130,194.477153 125.522847,190 120,190 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Balance 2':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Yin-Yang-V3" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M114.251045,170 L114.501038,170 C123.197653,170 131.237848,172.810471 137.761428,177.573358 C143.116763,182.501363 149.837208,185.9687 157.290871,187.343476 L158.001584,187.467836 L158.878334,187.602862 L159.820038,187.725 L160.374038,187.786 L161.082038,187.853 L162.145038,187.931 L162.560722,187.953177 L162.618038,187.955 L162.669038,187.958 L163.530038,187.987 L163.740682,187.992828 L164.501038,188 L164.881604,187.998205 L165.473038,187.987 L165.895038,187.975 L166.32846,187.958478 L167.078038,187.916 L167.845696,187.860391 L168.411038,187.808 L168.788038,187.769 L169.510038,187.684 L170.306696,187.576351 L171.10526,187.450347 C178.800604,186.155056 185.740575,182.634552 191.240649,177.573358 C197.764229,172.810471 205.804424,170 214.501038,170 L215.001419,170.003095 L215.251045,170 L215.501038,170 C224.197653,170 232.237848,172.810471 238.761428,177.573358 C244.116763,182.501363 250.837208,185.9687 258.290871,187.343476 L259.001584,187.467836 L259.878334,187.602862 L260.820038,187.725 L261.374038,187.786 L262.082038,187.853 L263.145038,187.931 L263.560722,187.953177 L263.618038,187.955 L263.669038,187.958 L264.530038,187.987 L264.740682,187.992828 L265.501038,188 L265.881604,187.998205 L266.473038,187.987 L266.895038,187.975 L267.32846,187.958478 L268.078038,187.916 L268.845696,187.860391 L269.411038,187.808 L269.788038,187.769 L270.510038,187.684 L271.306696,187.576351 L272.10526,187.450347 C279.800604,186.155056 286.740575,182.634552 292.240649,177.573358 C298.764229,172.810471 306.804424,170 315.501038,170 L316.001419,170.003095 L316.251045,170 L316.501038,170 C325.197653,170 333.237848,172.810471 339.761428,177.573358 C345.116763,182.501363 351.837208,185.9687 359.290871,187.343476 L360.001584,187.467836 L360.878334,187.602862 L361.820038,187.725 L362.374038,187.786 L363.082038,187.853 L364.145038,187.931 L364.560722,187.953177 L364.618038,187.955 L364.669038,187.958 L365.530038,187.987 L365.740682,187.992828 L366.501038,188 L366.881604,187.998205 L367.473038,187.987 L367.895038,187.975 L368.32846,187.958478 L369.078038,187.916 L369.845696,187.860391 L370.411038,187.808 L370.788038,187.769 L371.510038,187.684 L372.306696,187.576351 L373.10526,187.450347 C380.800604,186.155056 387.740575,182.634552 393.240649,177.573358 C399.764229,172.810471 407.804424,170 416.501038,170 L417.001419,170.003095 L417.251045,170 L417.501038,170 C426.197653,170 434.237848,172.810471 440.761428,177.573358 C446.116763,182.501363 452.837208,185.9687 460.290871,187.343476 L461.001584,187.467836 L461.878334,187.602862 L462.820038,187.725 L463.374038,187.786 L464.082038,187.853 L465.145038,187.931 L465.560722,187.953177 L465.618038,187.955 L465.669038,187.958 L466.530038,187.987 L466.740682,187.992828 L467.501038,188 L467.881604,187.998205 L468.473038,187.987 L468.895038,187.975 L469.32846,187.958478 L470.078038,187.916 L470.845696,187.860391 L471.411038,187.808 L471.788038,187.769 L472.510038,187.684 L473.306696,187.576351 L474.10526,187.450347 C481.800604,186.155056 488.740575,182.634552 494.240649,177.573358 C500.764229,172.810471 508.804424,170 517.501038,170 L518.001419,170.003095 L518.251045,170 L518.501038,170 C527.197653,170 535.237848,172.810471 541.761428,177.573358 C547.116763,182.501363 553.837208,185.9687 561.290871,187.343476 L562.001584,187.467836 L562.878334,187.602862 L563.820038,187.725 L564.374038,187.786 L565.082038,187.853 L566.145038,187.931 L566.560722,187.953177 L566.618038,187.955 L566.669038,187.958 L567.530038,187.987 L567.740682,187.992828 L568.501038,188 L568.881604,187.998205 L569.473038,187.987 L569.895038,187.975 L570.32846,187.958478 L571.078038,187.916 L571.845696,187.860391 L572.411038,187.808 L572.788038,187.769 L573.510038,187.684 L574.306696,187.576351 L575.10526,187.450347 C582.800604,186.155056 589.740575,182.634552 595.240649,177.573358 C601.764229,172.810471 609.804424,170 618.501038,170 L619.001419,170.003095 L619.251045,170 L619.501038,170 C628.197653,170 636.237848,172.810471 642.761428,177.573358 C648.116763,182.501363 654.837208,185.9687 662.290871,187.343476 L663.001584,187.467836 L663.878334,187.602862 L664.820038,187.725 L665.374038,187.786 L666.082038,187.853 L667.145038,187.931 L667.560722,187.953177 L667.618038,187.955 L667.669038,187.958 L668.530038,187.987 L668.740682,187.992828 L669.501038,188 L669.881604,187.998205 L670.473038,187.987 L670.895038,187.975 L671.32846,187.958478 L672.078038,187.916 L672.845696,187.860391 L673.411038,187.808 L673.788038,187.769 L674.510038,187.684 L675.306696,187.576351 L676.10526,187.450347 C683.800604,186.155056 690.740575,182.634552 696.240649,177.573358 C702.764229,172.810471 710.804424,170 719.501038,170 L720.001419,170.003095 L720.251045,170 L720.501038,170 C729.197653,170 737.237848,172.810471 743.761428,177.573358 C749.116763,182.501363 755.837208,185.9687 763.290871,187.343476 L764.001584,187.467836 L764.878334,187.602862 L765.820038,187.725 L766.374038,187.786 L767.082038,187.853 L768.145038,187.931 L768.560722,187.953177 L768.618038,187.955 L768.669038,187.958 L769.530038,187.987 L769.740682,187.992828 L770.501038,188 L770.881604,187.998205 L771.473038,187.987 L771.895038,187.975 L772.32846,187.958478 L773.078038,187.916 L773.845696,187.860391 L774.411038,187.808 L774.788038,187.769 L775.510038,187.684 L776.306696,187.576351 L777.10526,187.450347 C784.800604,186.155056 791.740575,182.634552 797.240649,177.573358 C803.764229,172.810471 811.804424,170 820.501038,170 L821.001419,170.003095 L821.251045,170 L821.501038,170 C830.197653,170 838.237848,172.810471 844.761428,177.573358 C850.116763,182.501363 856.837208,185.9687 864.290871,187.343476 L865.001584,187.467836 L865.878334,187.602862 L866.820038,187.725 L867.374038,187.786 L868.082038,187.853 L869.145038,187.931 L869.560722,187.953177 L869.618038,187.955 L869.669038,187.958 L870.530038,187.987 L870.740682,187.992828 L871.501038,188 L871.881604,187.998205 L872.473038,187.987 L872.895038,187.975 L873.32846,187.958478 L874.078038,187.916 L874.845696,187.860391 L875.411038,187.808 L875.788038,187.769 L876.510038,187.684 L877.306696,187.576351 L878.10526,187.450347 C885.800604,186.155056 892.740575,182.634552 898.240649,177.573358 C904.764229,172.810471 912.804424,170 921.501038,170 L922.001419,170.003095 L922.251045,170 L922.501038,170 C931.197653,170 939.237848,172.810471 945.761428,177.573358 C951.116763,182.501363 957.837208,185.9687 965.290871,187.343476 L966.001584,187.467836 L966.878334,187.602862 L967.820038,187.725 L968.374038,187.786 L969.082038,187.853 L970.145038,187.931 L970.560722,187.953177 L970.618038,187.955 L970.669038,187.958 L971.530038,187.987 L971.740682,187.992828 L972.501038,188 L972.881604,187.998205 L973.473038,187.987 L973.895038,187.975 L974.32846,187.958478 L975.078038,187.916 L975.845696,187.860391 L976.411038,187.808 L976.788038,187.769 L977.510038,187.684 L978.306696,187.576351 L979.10526,187.450347 C986.800604,186.155056 993.740575,182.634552 999.240649,177.573358 C1005.76423,172.810471 1013.80442,170 1022.50104,170 L1023.00142,170.003095 L1023.25105,170 L1023.50104,170 C1032.19765,170 1040.23785,172.810471 1046.76143,177.573358 C1052.11676,182.501363 1058.83721,185.9687 1066.29087,187.343476 L1067.00158,187.467836 L1067.87833,187.602862 L1068.82004,187.725 L1069.58304,187.807 L1070.33207,187.87473 L1071.14504,187.931 L1071.56072,187.953177 L1071.61804,187.955 L1071.66904,187.958 L1072.53004,187.987 L1072.74068,187.992828 L1073.50104,188 L1073.8816,187.998205 L1074.47304,187.987 L1074.89504,187.975 L1075.32846,187.958478 L1076.07804,187.916 L1076.8457,187.860391 L1077.41104,187.808 L1077.78804,187.769 L1078.51004,187.684 L1079.3067,187.576351 L1080.10526,187.450347 C1087.8006,186.155056 1094.74058,182.634552 1100.24065,177.573358 C1106.76423,172.810471 1114.80442,170 1123.50104,170 L1124.00142,170.003095 L1124.25105,170 L1124.50104,170 C1133.19765,170 1141.23785,172.810471 1147.76143,177.573358 C1153.11676,182.501363 1159.83721,185.9687 1167.29087,187.343476 L1168.00158,187.467836 L1168.87833,187.602862 L1169.82004,187.725 L1170.58304,187.807 L1171.33207,187.87473 L1172.14504,187.931 L1172.56072,187.953177 L1172.61804,187.955 L1172.66904,187.958 L1173.53004,187.987 L1173.74068,187.992828 L1174.50104,188 L1174.8816,187.998205 L1175.47304,187.987 L1175.89504,187.975 L1176.32846,187.958478 L1177.07804,187.916 L1177.8457,187.860391 L1178.41104,187.808 L1178.78804,187.769 L1179.51004,187.684 L1180.3067,187.576351 L1181.10526,187.450347 C1188.8006,186.155056 1195.74058,182.634552 1201.24065,177.573358 C1207.76423,172.810471 1215.80442,170 1224.50104,170 L1225.00142,170.003095 L1225.25105,170 L1225.50104,170 C1234.19765,170 1242.23785,172.810471 1248.76143,177.573358 C1254.11676,182.501363 1260.83721,185.9687 1268.29087,187.343476 L1269.00158,187.467836 L1269.87833,187.602862 L1270.82004,187.725 L1271.37404,187.786 L1272.08204,187.853 L1273.14504,187.931 L1273.56072,187.953177 L1273.61804,187.955 L1273.66904,187.958 L1274.53004,187.987 L1274.74068,187.992828 L1275.50104,188 L1275.8816,187.998205 L1276.47304,187.987 L1276.89504,187.975 L1277.32846,187.958478 L1278.07804,187.916 L1278.8457,187.860391 L1279.41104,187.808 L1279.78804,187.769 L1280.51004,187.684 L1281.3067,187.576351 L1282.10526,187.450347 C1289.8006,186.155056 1296.74058,182.634552 1302.24065,177.573358 C1308.76423,172.810471 1316.80442,170 1325.50104,170 L1326.00142,170.003095 L1326.25105,170 L1326.50104,170 C1335.19765,170 1343.23785,172.810471 1349.76143,177.573358 C1355.11676,182.501363 1361.83721,185.9687 1369.29087,187.343476 L1370.00158,187.467836 L1370.87833,187.602862 L1371.82004,187.725 L1372.58304,187.807 L1373.33207,187.87473 L1374.14504,187.931 L1374.56072,187.953177 L1374.61804,187.955 L1374.66904,187.958 L1375.53004,187.987 L1375.74068,187.992828 L1376.50104,188 L1376.8816,187.998205 L1377.47304,187.987 L1377.89504,187.975 L1378.32846,187.958478 L1379.07804,187.916 L1379.8457,187.860391 L1380.41104,187.808 L1380.78804,187.769 L1381.51004,187.684 L1382.3067,187.576351 L1383.10526,187.450347 C1390.8006,186.155056 1397.74058,182.634552 1403.24065,177.573358 C1409.76423,172.810471 1417.80442,170 1426.50104,170 L1427.00142,170.003095 L1427.25105,170 L1427.50104,170 C1431.86945,170 1436.07223,170.709129 1440.00036,172.018634 L1440.00036,320 L-1.63868918e-12,320 L-1.63868918e-12,172.367516 C4.21238432,170.835573 8.75913208,170 13.5010385,170 C22.1976534,170 30.2378475,172.810471 36.7614284,177.573358 C42.1167632,182.501363 48.8372081,185.9687 56.2908714,187.343476 L57.0015841,187.467836 L57.8783344,187.602862 L58.8200385,187.725 L59.3740385,187.786 L60.0820385,187.853 L61.1450385,187.931 L61.5607221,187.953177 L61.6180385,187.955 L61.6690385,187.958 L62.5300385,187.987 L62.7406821,187.992828 L63.5010385,188 L63.8816037,187.998205 L64.4730385,187.987 L64.8950385,187.975 L65.3284598,187.958478 L66.0780385,187.916 L66.8456964,187.860391 L67.4110385,187.808 L67.7880385,187.769 L68.5100385,187.684 L69.3066959,187.576351 L70.1052602,187.450347 C77.8006045,186.155056 84.740575,182.634552 90.2406486,177.573358 C96.7642295,172.810471 104.804424,170 113.501038,170 L114.001419,170.003095 L114.251045,170 Z M518.001038,190 C512.478191,190 508.001038,194.477153 508.001038,200 C508.001038,205.522847 512.478191,210 518.001038,210 C523.523886,210 528.001038,205.522847 528.001038,200 C528.001038,194.477153 523.523886,190 518.001038,190 Z M821.001038,190 C815.478191,190 811.001038,194.477153 811.001038,200 C811.001038,205.522847 815.478191,210 821.001038,210 C826.523886,210 831.001038,205.522847 831.001038,200 C831.001038,194.477153 826.523886,190 821.001038,190 Z M720.001038,190 C714.478191,190 710.001038,194.477153 710.001038,200 C710.001038,205.522847 714.478191,210 720.001038,210 C725.523886,210 730.001038,205.522847 730.001038,200 C730.001038,194.477153 725.523886,190 720.001038,190 Z M316.001038,190 C310.478191,190 306.001038,194.477153 306.001038,200 C306.001038,205.522847 310.478191,210 316.001038,210 C321.523886,210 326.001038,205.522847 326.001038,200 C326.001038,194.477153 321.523886,190 316.001038,190 Z M1023.00104,190 C1017.47819,190 1013.00104,194.477153 1013.00104,200 C1013.00104,205.522847 1017.47819,210 1023.00104,210 C1028.52389,210 1033.00104,205.522847 1033.00104,200 C1033.00104,194.477153 1028.52389,190 1023.00104,190 Z M922.001038,190 C916.478191,190 912.001038,194.477153 912.001038,200 C912.001038,205.522847 916.478191,210 922.001038,210 C927.523886,210 932.001038,205.522847 932.001038,200 C932.001038,194.477153 927.523886,190 922.001038,190 Z M1124.00104,190 C1118.47819,190 1114.00104,194.477153 1114.00104,200 C1114.00104,205.522847 1118.47819,210 1124.00104,210 C1129.52389,210 1134.00104,205.522847 1134.00104,200 C1134.00104,194.477153 1129.52389,190 1124.00104,190 Z M619.001038,190 C613.478191,190 609.001038,194.477153 609.001038,200 C609.001038,205.522847 613.478191,210 619.001038,210 C624.523886,210 629.001038,205.522847 629.001038,200 C629.001038,194.477153 624.523886,190 619.001038,190 Z M114.001038,190 C108.478191,190 104.001038,194.477153 104.001038,200 C104.001038,205.522847 108.478191,210 114.001038,210 C119.523886,210 124.001038,205.522847 124.001038,200 C124.001038,194.477153 119.523886,190 114.001038,190 Z M215.001038,190 C209.478191,190 205.001038,194.477153 205.001038,200 C205.001038,205.522847 209.478191,210 215.001038,210 C220.523886,210 225.001038,205.522847 225.001038,200 C225.001038,194.477153 220.523886,190 215.001038,190 Z M417.001038,190 C411.478191,190 407.001038,194.477153 407.001038,200 C407.001038,205.522847 411.478191,210 417.001038,210 C422.523886,210 427.001038,205.522847 427.001038,200 C427.001038,194.477153 422.523886,190 417.001038,190 Z M1326.00104,190 C1320.47819,190 1316.00104,194.477153 1316.00104,200 C1316.00104,205.522847 1320.47819,210 1326.00104,210 C1331.52389,210 1336.00104,205.522847 1336.00104,200 C1336.00104,194.477153 1331.52389,190 1326.00104,190 Z M1427.00104,190 C1421.47819,190 1417.00104,194.477153 1417.00104,200 C1417.00104,205.522847 1421.47819,210 1427.00104,210 C1432.52389,210 1437.00104,205.522847 1437.00104,200 C1437.00104,194.477153 1432.52389,190 1427.00104,190 Z M1225.00104,190 C1219.47819,190 1215.00104,194.477153 1215.00104,200 C1215.00104,205.522847 1219.47819,210 1225.00104,210 C1230.52389,210 1235.00104,205.522847 1235.00104,200 C1235.00104,194.477153 1230.52389,190 1225.00104,190 Z M13.0010385,190 C7.47819099,190 3.00103849,194.477153 3.00103849,200 C3.00103849,205.522847 7.47819099,210 13.0010385,210 C18.523886,210 23.0010385,205.522847 23.0010385,200 C23.0010385,194.477153 18.523886,190 13.0010385,190 Z M872.001038,148 C877.523886,148 882.001038,152.477153 882.001038,158 C882.001038,163.522847 877.523886,168 872.001038,168 C871.833353,168 871.666631,167.995873 871.50097,167.987714 C871.336115,167.995856 871.169061,168 871.001038,168 C865.478191,168 861.001038,163.522847 861.001038,158 C861.001038,152.477153 865.478191,148 871.001038,148 C871.169061,148 871.336115,148.004144 871.502105,148.012335 L871.721134,148.003842 L872.001038,148 Z M670.001038,148 C675.523886,148 680.001038,152.477153 680.001038,158 C680.001038,163.522847 675.523886,168 670.001038,168 C669.833353,168 669.666631,167.995873 669.50097,167.987714 C669.336115,167.995856 669.169061,168 669.001038,168 C663.478191,168 659.001038,163.522847 659.001038,158 C659.001038,152.477153 663.478191,148 669.001038,148 C669.169061,148 669.336115,148.004144 669.502105,148.012335 L669.721134,148.003842 L670.001038,148 Z M569.001038,148 C574.523886,148 579.001038,152.477153 579.001038,158 C579.001038,163.522847 574.523886,168 569.001038,168 C568.833353,168 568.666631,167.995873 568.50097,167.987714 C568.336115,167.995856 568.169061,168 568.001038,168 C562.478191,168 558.001038,163.522847 558.001038,158 C558.001038,152.477153 562.478191,148 568.001038,148 C568.169061,148 568.336115,148.004144 568.502105,148.012335 L568.721134,148.003842 L569.001038,148 Z M1175.00104,148 C1180.52389,148 1185.00104,152.477153 1185.00104,158 C1185.00104,163.522847 1180.52389,168 1175.00104,168 C1174.83335,168 1174.66663,167.995873 1174.50097,167.987714 C1174.33612,167.995856 1174.16906,168 1174.00104,168 C1168.47819,168 1164.00104,163.522847 1164.00104,158 C1164.00104,152.477153 1168.47819,148 1174.00104,148 C1174.16906,148 1174.33612,148.004144 1174.50211,148.012335 L1174.72113,148.003842 L1175.00104,148 Z M266.001038,148 C271.523886,148 276.001038,152.477153 276.001038,158 C276.001038,163.522847 271.523886,168 266.001038,168 C265.833353,168 265.666631,167.995873 265.50097,167.987714 C265.336115,167.995856 265.169061,168 265.001038,168 C259.478191,168 255.001038,163.522847 255.001038,158 C255.001038,152.477153 259.478191,148 265.001038,148 C265.169061,148 265.336115,148.004144 265.502105,148.012335 L265.721134,148.003842 L266.001038,148 Z M165.001038,148 C170.523886,148 175.001038,152.477153 175.001038,158 C175.001038,163.522847 170.523886,168 165.001038,168 C164.833353,168 164.666631,167.995873 164.50097,167.987714 C164.336115,167.995856 164.169061,168 164.001038,168 C158.478191,168 154.001038,163.522847 154.001038,158 C154.001038,152.477153 158.478191,148 164.001038,148 C164.169061,148 164.336115,148.004144 164.502105,148.012335 L164.721134,148.003842 L165.001038,148 Z M468.001038,148 C473.523886,148 478.001038,152.477153 478.001038,158 C478.001038,163.522847 473.523886,168 468.001038,168 C467.833353,168 467.666631,167.995873 467.50097,167.987714 C467.336115,167.995856 467.169061,168 467.001038,168 C461.478191,168 457.001038,163.522847 457.001038,158 C457.001038,152.477153 461.478191,148 467.001038,148 C467.169061,148 467.336115,148.004144 467.502105,148.012335 L467.721134,148.003842 L468.001038,148 Z M367.001038,148 C372.523886,148 377.001038,152.477153 377.001038,158 C377.001038,163.522847 372.523886,168 367.001038,168 C366.833353,168 366.666631,167.995873 366.50097,167.987714 C366.336115,167.995856 366.169061,168 366.001038,168 C360.478191,168 356.001038,163.522847 356.001038,158 C356.001038,152.477153 360.478191,148 366.001038,148 C366.169061,148 366.336115,148.004144 366.502105,148.012335 L366.721134,148.003842 L367.001038,148 Z M771.001038,148 C776.523886,148 781.001038,152.477153 781.001038,158 C781.001038,163.522847 776.523886,168 771.001038,168 C770.833353,168 770.666631,167.995873 770.50097,167.987714 C770.336115,167.995856 770.169061,168 770.001038,168 C764.478191,168 760.001038,163.522847 760.001038,158 C760.001038,152.477153 764.478191,148 770.001038,148 C770.169061,148 770.336115,148.004144 770.502105,148.012335 L770.721134,148.003842 L771.001038,148 Z M973.001038,148 C978.523886,148 983.001038,152.477153 983.001038,158 C983.001038,163.522847 978.523886,168 973.001038,168 C972.833353,168 972.666631,167.995873 972.50097,167.987714 C972.336115,167.995856 972.169061,168 972.001038,168 C966.478191,168 962.001038,163.522847 962.001038,158 C962.001038,152.477153 966.478191,148 972.001038,148 C972.169061,148 972.336115,148.004144 972.502105,148.012335 L972.721134,148.003842 L973.001038,148 Z M64.0010385,148 C69.523886,148 74.0010385,152.477153 74.0010385,158 C74.0010385,163.522847 69.523886,168 64.0010385,168 C63.833353,168 63.6666314,167.995873 63.5009699,167.987714 C63.3361151,167.995856 63.1690607,168 63.0010385,168 C57.478191,168 53.0010385,163.522847 53.0010385,158 C53.0010385,152.477153 57.478191,148 63.0010385,148 C63.1690607,148 63.3361151,148.004144 63.502105,148.012335 L63.7211336,148.003842 L64.0010385,148 Z M1276.00104,148 C1281.52389,148 1286.00104,152.477153 1286.00104,158 C1286.00104,163.522847 1281.52389,168 1276.00104,168 C1275.83335,168 1275.66663,167.995873 1275.50097,167.987714 C1275.33612,167.995856 1275.16906,168 1275.00104,168 C1269.47819,168 1265.00104,163.522847 1265.00104,158 C1265.00104,152.477153 1269.47819,148 1275.00104,148 C1275.16906,148 1275.33612,148.004144 1275.50211,148.012335 L1275.72113,148.003842 L1276.00104,148 Z M1074.00104,148 C1079.52389,148 1084.00104,152.477153 1084.00104,158 C1084.00104,163.522847 1079.52389,168 1074.00104,168 C1073.83335,168 1073.66663,167.995873 1073.50097,167.987714 C1073.33612,167.995856 1073.16906,168 1073.00104,168 C1067.47819,168 1063.00104,163.522847 1063.00104,158 C1063.00104,152.477153 1067.47819,148 1073.00104,148 C1073.16906,148 1073.33612,148.004144 1073.50211,148.012335 L1073.72113,148.003842 L1074.00104,148 Z M1377.00104,148 C1382.52389,148 1387.00104,152.477153 1387.00104,158 C1387.00104,163.522847 1382.52389,168 1377.00104,168 C1376.83335,168 1376.66663,167.995873 1376.50097,167.987714 C1376.33612,167.995856 1376.16906,168 1376.00104,168 C1370.47819,168 1366.00104,163.522847 1366.00104,158 C1366.00104,152.477153 1370.47819,148 1376.00104,148 C1376.16906,148 1376.33612,148.004144 1376.50211,148.012335 L1376.72113,148.003842 L1377.00104,148 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;
            case 'Balance 3':
                $svg_shape = '<svg viewBox="0 0 1440 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="none">
                <g id="Yin-Yang-V4" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path d="M114.251045,170 L114.501038,170 C123.197653,170 131.237848,172.810471 137.761428,177.573358 C143.116763,182.501363 149.837208,185.9687 157.290871,187.343476 L158.001584,187.467836 L158.878334,187.602862 L159.820038,187.725 L160.374038,187.786 L161.082038,187.853 L162.145038,187.931 L162.560722,187.953177 L162.618038,187.955 L162.669038,187.958 L163.530038,187.987 L163.740682,187.992828 L164.501038,188 L164.881604,187.998205 L165.473038,187.987 L165.895038,187.975 L166.32846,187.958478 L167.078038,187.916 L167.845696,187.860391 L168.411038,187.808 L168.788038,187.769 L169.510038,187.684 L170.306696,187.576351 L171.10526,187.450347 C178.800604,186.155056 185.740575,182.634552 191.240649,177.573358 C197.764229,172.810471 205.804424,170 214.501038,170 L215.001419,170.003095 L215.251045,170 L215.501038,170 C224.197653,170 232.237848,172.810471 238.761428,177.573358 C244.116763,182.501363 250.837208,185.9687 258.290871,187.343476 L259.001584,187.467836 L259.878334,187.602862 L260.820038,187.725 L261.374038,187.786 L262.082038,187.853 L263.145038,187.931 L263.560722,187.953177 L263.618038,187.955 L263.669038,187.958 L264.530038,187.987 L264.740682,187.992828 L265.501038,188 L265.881604,187.998205 L266.473038,187.987 L266.895038,187.975 L267.32846,187.958478 L268.078038,187.916 L268.845696,187.860391 L269.411038,187.808 L269.788038,187.769 L270.510038,187.684 L271.306696,187.576351 L272.10526,187.450347 C279.800604,186.155056 286.740575,182.634552 292.240649,177.573358 C298.764229,172.810471 306.804424,170 315.501038,170 L316.001419,170.003095 L316.251045,170 L316.501038,170 C325.197653,170 333.237848,172.810471 339.761428,177.573358 C345.116763,182.501363 351.837208,185.9687 359.290871,187.343476 L360.001584,187.467836 L360.878334,187.602862 L361.820038,187.725 L362.374038,187.786 L363.082038,187.853 L364.145038,187.931 L364.560722,187.953177 L364.618038,187.955 L364.669038,187.958 L365.530038,187.987 L365.740682,187.992828 L366.501038,188 L366.881604,187.998205 L367.473038,187.987 L367.895038,187.975 L368.32846,187.958478 L369.078038,187.916 L369.845696,187.860391 L370.411038,187.808 L370.788038,187.769 L371.510038,187.684 L372.306696,187.576351 L373.10526,187.450347 C380.800604,186.155056 387.740575,182.634552 393.240649,177.573358 C399.764229,172.810471 407.804424,170 416.501038,170 L417.001419,170.003095 L417.251045,170 L417.501038,170 C426.197653,170 434.237848,172.810471 440.761428,177.573358 C446.116763,182.501363 452.837208,185.9687 460.290871,187.343476 L461.001584,187.467836 L461.878334,187.602862 L462.820038,187.725 L463.374038,187.786 L464.082038,187.853 L465.145038,187.931 L465.560722,187.953177 L465.618038,187.955 L465.669038,187.958 L466.530038,187.987 L466.740682,187.992828 L467.501038,188 L467.881604,187.998205 L468.473038,187.987 L468.895038,187.975 L469.32846,187.958478 L470.078038,187.916 L470.845696,187.860391 L471.411038,187.808 L471.788038,187.769 L472.510038,187.684 L473.306696,187.576351 L474.10526,187.450347 C481.800604,186.155056 488.740575,182.634552 494.240649,177.573358 C500.764229,172.810471 508.804424,170 517.501038,170 L518.001419,170.003095 L518.251045,170 L518.501038,170 C527.197653,170 535.237848,172.810471 541.761428,177.573358 C547.116763,182.501363 553.837208,185.9687 561.290871,187.343476 L562.001584,187.467836 L562.878334,187.602862 L563.820038,187.725 L564.374038,187.786 L565.082038,187.853 L566.145038,187.931 L566.560722,187.953177 L566.618038,187.955 L566.669038,187.958 L567.530038,187.987 L567.740682,187.992828 L568.501038,188 L568.881604,187.998205 L569.473038,187.987 L569.895038,187.975 L570.32846,187.958478 L571.078038,187.916 L571.845696,187.860391 L572.411038,187.808 L572.788038,187.769 L573.510038,187.684 L574.306696,187.576351 L575.10526,187.450347 C582.800604,186.155056 589.740575,182.634552 595.240649,177.573358 C601.764229,172.810471 609.804424,170 618.501038,170 L619.001419,170.003095 L619.251045,170 L619.501038,170 C628.197653,170 636.237848,172.810471 642.761428,177.573358 C648.116763,182.501363 654.837208,185.9687 662.290871,187.343476 L663.001584,187.467836 L663.878334,187.602862 L664.820038,187.725 L665.374038,187.786 L666.082038,187.853 L667.145038,187.931 L667.560722,187.953177 L667.618038,187.955 L667.669038,187.958 L668.530038,187.987 L668.740682,187.992828 L669.501038,188 L669.881604,187.998205 L670.473038,187.987 L670.895038,187.975 L671.32846,187.958478 L672.078038,187.916 L672.845696,187.860391 L673.411038,187.808 L673.788038,187.769 L674.510038,187.684 L675.306696,187.576351 L676.10526,187.450347 C683.800604,186.155056 690.740575,182.634552 696.240649,177.573358 C702.764229,172.810471 710.804424,170 719.501038,170 L720.001419,170.003095 L720.251045,170 L720.501038,170 C729.197653,170 737.237848,172.810471 743.761428,177.573358 C749.116763,182.501363 755.837208,185.9687 763.290871,187.343476 L764.001584,187.467836 L764.878334,187.602862 L765.820038,187.725 L766.374038,187.786 L767.082038,187.853 L768.145038,187.931 L768.560722,187.953177 L768.618038,187.955 L768.669038,187.958 L769.530038,187.987 L769.740682,187.992828 L770.501038,188 L770.881604,187.998205 L771.473038,187.987 L771.895038,187.975 L772.32846,187.958478 L773.078038,187.916 L773.845696,187.860391 L774.411038,187.808 L774.788038,187.769 L775.510038,187.684 L776.306696,187.576351 L777.10526,187.450347 C784.800604,186.155056 791.740575,182.634552 797.240649,177.573358 C803.764229,172.810471 811.804424,170 820.501038,170 L821.001419,170.003095 L821.251045,170 L821.501038,170 C830.197653,170 838.237848,172.810471 844.761428,177.573358 C850.116763,182.501363 856.837208,185.9687 864.290871,187.343476 L865.001584,187.467836 L865.878334,187.602862 L866.820038,187.725 L867.374038,187.786 L868.082038,187.853 L869.145038,187.931 L869.560722,187.953177 L869.618038,187.955 L869.669038,187.958 L870.530038,187.987 L870.740682,187.992828 L871.501038,188 L871.881604,187.998205 L872.473038,187.987 L872.895038,187.975 L873.32846,187.958478 L874.078038,187.916 L874.845696,187.860391 L875.411038,187.808 L875.788038,187.769 L876.510038,187.684 L877.306696,187.576351 L878.10526,187.450347 C885.800604,186.155056 892.740575,182.634552 898.240649,177.573358 C904.764229,172.810471 912.804424,170 921.501038,170 L922.001419,170.003095 L922.251045,170 L922.501038,170 C931.197653,170 939.237848,172.810471 945.761428,177.573358 C951.116763,182.501363 957.837208,185.9687 965.290871,187.343476 L966.001584,187.467836 L966.878334,187.602862 L967.820038,187.725 L968.374038,187.786 L969.082038,187.853 L970.145038,187.931 L970.560722,187.953177 L970.618038,187.955 L970.669038,187.958 L971.530038,187.987 L971.740682,187.992828 L972.501038,188 L972.881604,187.998205 L973.473038,187.987 L973.895038,187.975 L974.32846,187.958478 L975.078038,187.916 L975.845696,187.860391 L976.411038,187.808 L976.788038,187.769 L977.510038,187.684 L978.306696,187.576351 L979.10526,187.450347 C986.800604,186.155056 993.740575,182.634552 999.240649,177.573358 C1005.76423,172.810471 1013.80442,170 1022.50104,170 L1023.00142,170.003095 L1023.25105,170 L1023.50104,170 C1032.19765,170 1040.23785,172.810471 1046.76143,177.573358 C1052.11676,182.501363 1058.83721,185.9687 1066.29087,187.343476 L1067.00158,187.467836 L1067.87833,187.602862 L1068.82004,187.725 L1069.58304,187.807 L1070.33207,187.87473 L1071.14504,187.931 L1071.56072,187.953177 L1071.61804,187.955 L1071.66904,187.958 L1072.53004,187.987 L1072.74068,187.992828 L1073.50104,188 L1073.8816,187.998205 L1074.47304,187.987 L1074.89504,187.975 L1075.32846,187.958478 L1076.07804,187.916 L1076.8457,187.860391 L1077.41104,187.808 L1077.78804,187.769 L1078.51004,187.684 L1079.3067,187.576351 L1080.10526,187.450347 C1087.8006,186.155056 1094.74058,182.634552 1100.24065,177.573358 C1106.76423,172.810471 1114.80442,170 1123.50104,170 L1124.00142,170.003095 L1124.25105,170 L1124.50104,170 C1133.19765,170 1141.23785,172.810471 1147.76143,177.573358 C1153.11676,182.501363 1159.83721,185.9687 1167.29087,187.343476 L1168.00158,187.467836 L1168.87833,187.602862 L1169.82004,187.725 L1170.58304,187.807 L1171.33207,187.87473 L1172.14504,187.931 L1172.56072,187.953177 L1172.61804,187.955 L1172.66904,187.958 L1173.53004,187.987 L1173.74068,187.992828 L1174.50104,188 L1174.8816,187.998205 L1175.47304,187.987 L1175.89504,187.975 L1176.32846,187.958478 L1177.07804,187.916 L1177.8457,187.860391 L1178.41104,187.808 L1178.78804,187.769 L1179.51004,187.684 L1180.3067,187.576351 L1181.10526,187.450347 C1188.8006,186.155056 1195.74058,182.634552 1201.24065,177.573358 C1207.76423,172.810471 1215.80442,170 1224.50104,170 L1225.00142,170.003095 L1225.25105,170 L1225.50104,170 C1234.19765,170 1242.23785,172.810471 1248.76143,177.573358 C1254.11676,182.501363 1260.83721,185.9687 1268.29087,187.343476 L1269.00158,187.467836 L1269.87833,187.602862 L1270.82004,187.725 L1271.37404,187.786 L1272.08204,187.853 L1273.14504,187.931 L1273.56072,187.953177 L1273.61804,187.955 L1273.66904,187.958 L1274.53004,187.987 L1274.74068,187.992828 L1275.50104,188 L1275.8816,187.998205 L1276.47304,187.987 L1276.89504,187.975 L1277.32846,187.958478 L1278.07804,187.916 L1278.8457,187.860391 L1279.41104,187.808 L1279.78804,187.769 L1280.51004,187.684 L1281.3067,187.576351 L1282.10526,187.450347 C1289.8006,186.155056 1296.74058,182.634552 1302.24065,177.573358 C1308.76423,172.810471 1316.80442,170 1325.50104,170 L1326.00142,170.003095 L1326.25105,170 L1326.50104,170 C1335.19765,170 1343.23785,172.810471 1349.76143,177.573358 C1355.11676,182.501363 1361.83721,185.9687 1369.29087,187.343476 L1370.00158,187.467836 L1370.87833,187.602862 L1371.82004,187.725 L1372.58304,187.807 L1373.33207,187.87473 L1374.14504,187.931 L1374.56072,187.953177 L1374.61804,187.955 L1374.66904,187.958 L1375.53004,187.987 L1375.74068,187.992828 L1376.50104,188 L1376.8816,187.998205 L1377.47304,187.987 L1377.89504,187.975 L1378.32846,187.958478 L1379.07804,187.916 L1379.8457,187.860391 L1380.41104,187.808 L1380.78804,187.769 L1381.51004,187.684 L1382.3067,187.576351 L1383.10526,187.450347 C1390.8006,186.155056 1397.74058,182.634552 1403.24065,177.573358 C1409.76423,172.810471 1417.80442,170 1426.50104,170 L1427.00142,170.003095 L1427.25105,170 L1427.50104,170 C1431.86945,170 1436.07223,170.709129 1440.00036,172.018634 L1440.00036,320 L-1.59161573e-12,320 L-1.59161573e-12,172.367516 C4.21238432,170.835573 8.75913208,170 13.5010385,170 C22.1976534,170 30.2378475,172.810471 36.7614284,177.573358 C42.1167632,182.501363 48.8372081,185.9687 56.2908714,187.343476 L57.0015841,187.467836 L57.8783344,187.602862 L58.8200385,187.725 L59.3740385,187.786 L60.0820385,187.853 L61.1450385,187.931 L61.5607221,187.953177 L61.6180385,187.955 L61.6690385,187.958 L62.5300385,187.987 L62.7406821,187.992828 L63.5010385,188 L63.8816037,187.998205 L64.4730385,187.987 L64.8950385,187.975 L65.3284598,187.958478 L66.0780385,187.916 L66.8456964,187.860391 L67.4110385,187.808 L67.7880385,187.769 L68.5100385,187.684 L69.3066959,187.576351 L70.1052602,187.450347 C77.8006045,186.155056 84.740575,182.634552 90.2406486,177.573358 C96.7642295,172.810471 104.804424,170 113.501038,170 L114.001419,170.003095 L114.251045,170 Z M1326,190 C1312.74517,190 1302,200.745166 1302,214 C1302,227.254834 1312.74517,238 1326,238 C1339.25483,238 1350,227.254834 1350,214 C1350,200.745166 1339.25483,190 1326,190 Z M923,190 C922.796491,190 922.593574,190.002533 922.391279,190.007569 C922.262417,190.002518 922.132022,190 922.001038,190 C921.388908,190 920.789623,190.055 920.207857,190.160328 C908.268593,191.543856 899,201.68953 899,214 C899,227.254834 909.745166,238 923,238 C936.254834,238 947,227.254834 947,214 C947,200.745166 936.254834,190 923,190 Z M114,190 C100.745166,190 90,200.745166 90,214 C90,227.254834 100.745166,238 114,238 C127.254834,238 138,227.254834 138,214 C138,200.745166 127.254834,190 114,190 Z M518,190 C504.745166,190 494,200.745166 494,214 C494,227.254834 504.745166,238 518,238 C531.254834,238 542,227.254834 542,214 C542,200.745166 531.254834,190 518,190 Z M316,190 C302.745166,190 292,200.745166 292,214 C292,227.254834 302.745166,238 316,238 C329.254834,238 340,227.254834 340,214 C340,200.745166 329.254834,190 316,190 Z M721,190 C720.796491,190 720.593574,190.002533 720.391279,190.007569 C720.262417,190.002518 720.132022,190 720.001038,190 C719.388908,190 718.789623,190.055 718.207857,190.160328 C706.268593,191.543856 697,201.68953 697,214 C697,227.254834 707.745166,238 721,238 C734.254834,238 745,227.254834 745,214 C745,200.745166 734.254834,190 721,190 Z M1125,190 C1124.79649,190 1124.59357,190.002533 1124.39128,190.007569 C1124.26242,190.002518 1124.13202,190 1124.00104,190 C1123.38891,190 1122.78962,190.055 1122.20786,190.160328 C1110.26859,191.543856 1101,201.68953 1101,214 C1101,227.254834 1111.74517,238 1125,238 C1138.25483,238 1149,227.254834 1149,214 C1149,200.745166 1138.25483,190 1125,190 Z M215.001038,190 C209.478191,190 205.001038,194.477153 205.001038,200 C205.001038,205.522847 209.478191,210 215.001038,210 C220.523886,210 225.001038,205.522847 225.001038,200 C225.001038,194.477153 220.523886,190 215.001038,190 Z M1023.00104,190 C1017.47819,190 1013.00104,194.477153 1013.00104,200 C1013.00104,205.522847 1017.47819,210 1023.00104,210 C1028.52389,210 1033.00104,205.522847 1033.00104,200 C1033.00104,194.477153 1028.52389,190 1023.00104,190 Z M821.001038,190 C815.478191,190 811.001038,194.477153 811.001038,200 C811.001038,205.522847 815.478191,210 821.001038,210 C826.523886,210 831.001038,205.522847 831.001038,200 C831.001038,194.477153 826.523886,190 821.001038,190 Z M619.001038,190 C613.478191,190 609.001038,194.477153 609.001038,200 C609.001038,205.522847 613.478191,210 619.001038,210 C624.523886,210 629.001038,205.522847 629.001038,200 C629.001038,194.477153 624.523886,190 619.001038,190 Z M417.001038,190 C411.478191,190 407.001038,194.477153 407.001038,200 C407.001038,205.522847 411.478191,210 417.001038,210 C422.523886,210 427.001038,205.522847 427.001038,200 C427.001038,194.477153 422.523886,190 417.001038,190 Z M1427.00104,190 C1421.47819,190 1417.00104,194.477153 1417.00104,200 C1417.00104,205.522847 1421.47819,210 1427.00104,210 C1432.52389,210 1437.00104,205.522847 1437.00104,200 C1437.00104,194.477153 1432.52389,190 1427.00104,190 Z M1225.00104,190 C1219.47819,190 1215.00104,194.477153 1215.00104,200 C1215.00104,205.522847 1219.47819,210 1225.00104,210 C1230.52389,210 1235.00104,205.522847 1235.00104,200 C1235.00104,194.477153 1230.52389,190 1225.00104,190 Z M13.0010385,190 C7.47819099,190 3.00103849,194.477153 3.00103849,200 C3.00103849,205.522847 7.47819099,210 13.0010385,210 C18.523886,210 23.0010385,205.522847 23.0010385,200 C23.0010385,194.477153 18.523886,190 13.0010385,190 Z M873,120 C886.254834,120 897,130.745166 897,144 C897,157.254834 886.254834,168 873,168 C872.796491,168 872.593574,167.997467 872.391279,167.992431 C872.262417,167.997482 872.132022,168 872.001038,168 C871.833353,168 871.666631,167.995873 871.50097,167.987714 C871.336115,167.995856 871.169061,168 871.001038,168 C869.760643,168 868.572995,167.774163 867.476969,167.361363 C856.884481,164.866762 849,155.354141 849,144 C849,130.745166 859.745166,120 873,120 Z M973.001038,148 C978.523886,148 983.001038,152.477153 983.001038,158 C983.001038,163.522847 978.523886,168 973.001038,168 C972.833353,168 972.666631,167.995873 972.50097,167.987714 C972.336115,167.995856 972.169061,168 972.001038,168 C966.478191,168 962.001038,163.522847 962.001038,158 C962.001038,152.477153 966.478191,148 972.001038,148 C972.169061,148 972.336115,148.004144 972.502105,148.012335 L972.721134,148.003842 L973.001038,148 Z M771.001038,148 C776.523886,148 781.001038,152.477153 781.001038,158 C781.001038,163.522847 776.523886,168 771.001038,168 C770.833353,168 770.666631,167.995873 770.50097,167.987714 C770.336115,167.995856 770.169061,168 770.001038,168 C764.478191,168 760.001038,163.522847 760.001038,158 C760.001038,152.477153 764.478191,148 770.001038,148 C770.169061,148 770.336115,148.004144 770.502105,148.012335 L770.721134,148.003842 L771.001038,148 Z M1377.00104,148 C1382.52389,148 1387.00104,152.477153 1387.00104,158 C1387.00104,163.522847 1382.52389,168 1377.00104,168 C1376.83335,168 1376.66663,167.995873 1376.50097,167.987714 C1376.33612,167.995856 1376.16906,168 1376.00104,168 C1370.47819,168 1366.00104,163.522847 1366.00104,158 C1366.00104,152.477153 1370.47819,148 1376.00104,148 C1376.16906,148 1376.33612,148.004144 1376.50211,148.012335 L1376.72113,148.003842 L1377.00104,148 Z M367.001038,148 C372.523886,148 377.001038,152.477153 377.001038,158 C377.001038,163.522847 372.523886,168 367.001038,168 C366.833353,168 366.666631,167.995873 366.50097,167.987714 C366.336115,167.995856 366.169061,168 366.001038,168 C360.478191,168 356.001038,163.522847 356.001038,158 C356.001038,152.477153 360.478191,148 366.001038,148 C366.169061,148 366.336115,148.004144 366.502105,148.012335 L366.721134,148.003842 L367.001038,148 Z M671,120 C684.254834,120 695,130.745166 695,144 C695,157.254834 684.254834,168 671,168 C670.796491,168 670.593574,167.997467 670.391279,167.992431 C670.262417,167.997482 670.132022,168 670.001038,168 C669.833353,168 669.666631,167.995873 669.50097,167.987714 C669.336115,167.995856 669.169061,168 669.001038,168 C667.760643,168 666.572995,167.774163 665.476969,167.361363 C654.884481,164.866762 647,155.354141 647,144 C647,130.745166 657.745166,120 671,120 Z M1175.00104,148 C1180.52389,148 1185.00104,152.477153 1185.00104,158 C1185.00104,163.522847 1180.52389,168 1175.00104,168 C1174.83335,168 1174.66663,167.995873 1174.50097,167.987714 C1174.33612,167.995856 1174.16906,168 1174.00104,168 C1168.47819,168 1164.00104,163.522847 1164.00104,158 C1164.00104,152.477153 1168.47819,148 1174.00104,148 C1174.16906,148 1174.33612,148.004144 1174.50211,148.012335 L1174.72113,148.003842 L1175.00104,148 Z M64,120 C77.254834,120 88,130.745166 88,144 C88,157.122286 77.4686628,167.784846 64.3968839,167.996785 L64.0030515,168 C63.7951526,168 63.5909045,167.997434 63.3872863,167.992331 L63.0010385,168 C62.388908,168 61.7896235,167.945 61.2078571,167.839672 C49.2685932,166.456144 40,156.31047 40,144 C40,130.745166 50.745166,120 64,120 Z M266,120 C279.254834,120 290,130.745166 290,144 C290,157.122286 279.468663,167.784846 266.396884,167.996785 L266.003052,168 C265.795153,168 265.590905,167.997434 265.387286,167.992331 L265.001038,168 C264.388908,168 263.789623,167.945 263.207857,167.839672 C251.268593,166.456144 242,156.31047 242,144 C242,130.745166 252.745166,120 266,120 Z M569.001038,148 C574.523886,148 579.001038,152.477153 579.001038,158 C579.001038,163.522847 574.523886,168 569.001038,168 C568.833353,168 568.666631,167.995873 568.50097,167.987714 C568.336115,167.995856 568.169061,168 568.001038,168 C562.478191,168 558.001038,163.522847 558.001038,158 C558.001038,152.477153 562.478191,148 568.001038,148 C568.169061,148 568.336115,148.004144 568.502105,148.012335 L568.721134,148.003842 L569.001038,148 Z M468,120 C481.254834,120 492,130.745166 492,144 C492,157.122286 481.468663,167.784846 468.396884,167.996785 L468.003052,168 C467.795153,168 467.590905,167.997434 467.387286,167.992331 L467.001038,168 C466.388908,168 465.789623,167.945 465.207857,167.839672 C453.268593,166.456144 444,156.31047 444,144 C444,130.745166 454.745166,120 468,120 Z M1075,120 C1088.25483,120 1099,130.745166 1099,144 C1099,157.254834 1088.25483,168 1075,168 C1074.79649,168 1074.59357,167.997467 1074.39128,167.992431 C1074.26242,167.997482 1074.13202,168 1074.00104,168 C1073.83335,168 1073.66663,167.995873 1073.50097,167.987714 C1073.33612,167.995856 1073.16906,168 1073.00104,168 C1071.76064,168 1070.573,167.774163 1069.47697,167.361363 C1058.88448,164.866762 1051,155.354141 1051,144 C1051,130.745166 1061.74517,120 1075,120 Z M165.001038,148 C170.523886,148 175.001038,152.477153 175.001038,158 C175.001038,163.522847 170.523886,168 165.001038,168 C164.833353,168 164.666631,167.995873 164.50097,167.987714 C164.336115,167.995856 164.169061,168 164.001038,168 C158.478191,168 154.001038,163.522847 154.001038,158 C154.001038,152.477153 158.478191,148 164.001038,148 C164.169061,148 164.336115,148.004144 164.502105,148.012335 L164.721134,148.003842 L165.001038,148 Z M1276,120 C1289.25483,120 1300,130.745166 1300,144 C1300,157.122286 1289.46866,167.784846 1276.39688,167.996785 L1276,168 C1275.79515,168 1275.5909,167.997434 1275.38729,167.992331 L1275.00104,168 C1274.38891,168 1273.78962,167.945 1273.20786,167.839672 C1261.26859,166.456144 1252,156.31047 1252,144 C1252,130.745166 1262.74517,120 1276,120 Z" fill="currentColor"></path>
                </g>
            </svg>';
            break;


        }

        if ( $options['custom_shape'] ) {
            $svg_shape = $options['custom_shape'];
        }

        // Get class based on position property.
        $svg_position = strtolower( $options['svg_position'] ); // should return "Top" or "Bottom"

        $transforms = "";

        if( $svg_position == 'top' ) {
            $classes .= ' oxy_shape_divider_top';
            $transforms .= ' scaleY(-1)';
        }

        // Get class based on flip property
        $svg_flip = strtolower( $options['svg_flip'] ); // should return "No" or "Yes"

        if( $svg_flip == "yes" ) {
            $transforms .= ' scaleX(-1)';
        }

        if( $transforms !== "" ) {
            $transforms = "style=\"transform: $transforms\"";
        }
        
        ?>
        
        <div class="<?php echo $classes; ?>" <?php echo $transforms; ?>>
            <?php echo $svg_shape; ?>
        </div>

        <?php

        $this->El->builderInlineJS(
            "
            jQuery('.ct-section').css({position: '', overflow: ''});
            jQuery('.ct-section:has(.oxy-shape-divider)').css({position: 'relative', overflow: 'hidden'});
            "
        );

        $this->El->footerJS(
            
            "
            jQuery(document).ready( function() {
                jQuery('.ct-section:has(.oxy-shape-divider)').css({position: 'relative', overflow: 'hidden'});
            })

            "
        );

    }

    function controls(){

        // Pick SVG for divider.
        $this->addOptionControl(
            array(
                "type" => 'dropdown',
                "name" => __("Divider Shape"),
                "slug" => 'svg_shape',
            )
        )->setValue(array(
            'Wavy 1',
            'Wavy 2',
            'Wavy 3',
            'Towers 1',
            'Towers 2',
            'Towers 3',
            'Curvy 1',
            'Curvy 2',
            'Curvy 3',
            'Angle 1',
            'Angle 2',
            'Angle 3',
            'Valley 1',
            'Valley 2',
            'Valley 3',
            'Cave 1',
            'Cave 2',
            'Cave 3',
            'Diamond 1',
            'Diamond 2',
            'Diamond 3',
            'Balance 1',
            'Balance 2',
            'Balance 3',
            'Shark 1',
            'Shark 2',
            'Shark 3',
            'Logs 1',
            'Logs 2',
            'Logs 3',
            'Ocean 1',
            'Ocean 2',
            'Ocean 3'
        ))->rebuildElementOnChange();

        // Custom SVG
        $this->addOptionControl(
            array(
                "type" => 'textfield',
                "name" => __("Custom Shape"),
                "slug" => 'custom_shape',
                "base64" => true,
            )
        )->rebuildElementOnChange();

        // Pick color for SVG
        $this->addStyleControls(
            array(
                array(
                    "control_type" => 'colorpicker',
                    "name" => __("Color"),
                    "property" => "color",
                    "selector" => ".oxy_shape_divider"
                )
            )
        );

        // Pick position, top or bottom.
        $this->addOptionControl(
            array(
                "type" => 'buttons-list',
                "name" => __("Position"),
                "slug" => 'svg_position',
            )
        )->setValue(array('Bottom', 'Top'))->rebuildElementOnChange();

        // Flip horizontally.
        $this->addOptionControl(
            array(
                "type" => 'buttons-list',
                "name" => __("Flip Horizontally"),
                "slug" => 'svg_flip',
            )
        )->setValue(array('No', 'Yes'))->rebuildElementOnChange();

        // Height
        $this->addStyleControls(
            array(
                array(
                    "name" => __("Height"),
                    "property" => "height",
                    "selector" => ".oxy_shape_divider svg",
                    "value" => "320"
                )
            )
        );

        // Width
        $this->addStyleControls(
            array(
                array(
                    "name" => __("Width"),
                    "property" => "width",
                    "selector" => ".oxy_shape_divider svg",
                    "value" => "100",
                    "unit" => "%"
                )
            )
        );

        // Center Horizontally
        $center_horizontally = $this->addOptionControl(
            array(
                "type" => "checkbox", 
                "slug" => "center_horizontally",
                "name" => __("Center Horizontally")
            ))->setValue("false");

		$center_horizontally->setValueCSS( array(

			"default" => "",

			"true" => "
                .oxy_shape_divider > svg {
                    left: auto;
                }

                .oxy_shape_divider {
                    display: flex;
                    justify-content: center;
                }
            ",

            "false" => ""
            
		));

        // Z Index
        $this->addStyleControls(
            array(
                array(
                    "control_type" => 'textfield',
                    "name" => __("Z-Index"),
                    "property" => "z-index",
                    "selector" => ".oxy_shape_divider"
                )
            )
        );

        /*$this->addApplyParamsButton();*/

    }
      
}

new Oxygen_Shape_Divider();
