<?php
/*
Plugin Name: OxyMonster Framework
Author: OxyMonster
Author URI: https://oxymonster.com
Description: Powerful utility classes based framework, tools & beautiful design kits for Oxygen Builder.
Version: 0.29
Text Domain: oxymonster-framework
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'OXYMONSTER_TITLE', 'OxyMonster Framework' );
define( 'OXYMONSTER_VERSION', '0.29' );
define( 'OXYMONSTER_STORE_URL', 'https://oxymonster.com' );
define( 'OXYMONSTER_ITEM_ID', 20 );
define('OXYMONSTER_ASSETS', 	plugin_dir_url( __FILE__ )  . 	'assets' );

if ( ! class_exists( 'OxyMonster_Plugin_Updater' ) ) {
  include( dirname( __FILE__ ) . '/access/OxyMonster_Plugin_Updater.php' );
}

require_once( 'access/OxyMonster_License.php' );

require( 'includes/functions.php' );
require( 'includes/scripts.php' );

class OxyMonster {
  const PREFIX = 'oxymonster_';
  const TITLE = 'OxyMonster Framework';
  
  static function init() {

    OxyMonsterLicense::init( self::PREFIX, self::TITLE, OXYMONSTER_STORE_URL, OXYMONSTER_ITEM_ID );
    add_action( 'activate_' . plugin_basename( __FILE__ ), array( __CLASS__, 'activate' ), 10, 2 );

    if ( OxyMonsterLicense::is_activated_license() === true ) {
      add_action( 'wp_enqueue_scripts', array( __CLASS__, 'scripts' ), 11 );
    }

    add_action( 'admin_menu', array(__CLASS__, 'admin_menu'), 11);
    add_action( 'admin_init', array(__CLASS__, 'plugin_updater'), 0 );
  }

  static function admin_menu() {
    add_menu_page( OXYMONSTER_TITLE, OXYMONSTER_TITLE, 'manage_options',  'oxymonster_menu' );
    add_submenu_page( 'oxymonster_menu', 'Welcome', 'Welcome', 'manage_options', self::PREFIX.'menu', array(__CLASS__, 'menu_item') );
    add_submenu_page( 'oxymonster_menu', 'Colors', 'Colors', 'manage_options', self::PREFIX.'menu&tab=colors', array(__CLASS__, 'menu_item') );
    add_submenu_page( 'oxymonster_menu', 'Modules', 'Modules', 'manage_options', self::PREFIX.'menu&tab=modules', array(__CLASS__, 'menu_item') );
    $oxymonster_gclasseseditr = get_option("oxymonster_global_classes_editor");
    if(isset($oxymonster_gclasseseditr) && $oxymonster_gclasseseditr == "Disable"){
    } else {
    add_submenu_page( 'oxymonster_menu', 'CSS classes', 'CSS classes', 'manage_options', self::PREFIX.'menu&tab=selectors', array(__CLASS__, 'menu_item') );
    }
    add_submenu_page( 'oxymonster_menu', 'License', 'License', 'manage_options', self::PREFIX.'menu&tab=license', array(__CLASS__, 'menu_item') );
  }


  static function menu_item() {
    $tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : false;
    ?>
    <div class="wrap">
      <h2 class="nav-tab-wrapper">
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=welcome" class="nav-tab<?php echo $tab == 'welcome'?' nav-tab-active':'';?>"">Welcome</a>
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=colors" class="nav-tab<?php echo $tab == 'colors'?' nav-tab-active':'';?>">Colors</a>
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=modules" class="nav-tab<?php echo $tab == 'modules'?' nav-tab-active':'';?>">Modules</a>
        <?php
        $oxymonster_gclasseseditr = get_option("oxymonster_global_classes_editor");
        if(isset($oxymonster_gclasseseditr) && $oxymonster_gclasseseditr == "Disable"){
        } else { ?>
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=selectors" class="nav-tab<?php echo $tab == 'selectors'?' nav-tab-active':'';?>">CSS classes</a>
        <?php } ?>
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=license" class="nav-tab<?php echo $tab == 'license'?' nav-tab-active':'';?>">License</a>
        </h2>
    <?php
    
    if ( OxyMonsterLicense::is_activated_license() === true ) {


      if($tab === 'license') {
        OxyMonsterLicense::license_page();
      } elseif($tab === 'info') {
        self::info_page();
      } elseif($tab === 'colors') {
        self::colors_page();
      } elseif($tab === 'modules') {
        self::modules_page();
      } elseif($tab === 'welcome') {
        self::welcome_page();
      } elseif($tab === 'selectors') {
        self::global_selectors_editor_page();
      } else {
          self::welcome_page();
      }
      
      } else {
        
        OxyMonsterLicense::license_page();
    }
    ?>
    </div>
    <?php
  }
  
  static function scripts() {
    if ( ! defined( 'SHOW_CT_BUILDER' ) ) {
      return;
    }
    if ( defined( 'OXYGEN_IFRAME' ) ) {
      $oxymonster_mergeClasses = get_option("oxymonster_mergeClasses");
      if(isset($oxymonster_mergeClasses) && $oxymonster_mergeClasses == "Disable"){
    
      } else {
        
      wp_register_script( self::PREFIX . 'merge', plugins_url( 'assets/js/merge.js', __FILE__ ), array( 'ct-angular-main' ), OXYMONSTER_VERSION );
      wp_localize_script(self::PREFIX . 'merge', self::PREFIX . 'options', array(
      ));
      wp_enqueue_script( self::PREFIX . 'merge' );
      }
    } else {
      wp_enqueue_style( self::PREFIX . 'style', plugins_url( 'assets/css/merge.css', __FILE__ ), array(), OXYMONSTER_VERSION );
    }
  }
  
  static function activate( $plugin ) {
    // require( 'includes/activate.php' );
    if ( ! defined( 'CT_FW_PATH' ) ) {
      die( '<p>\'Oxygen builder\' must be installed and activated, in order to activate \'' . self::TITLE . '\'</p>' );
     }
  }
  
  static function plugin_updater() {
    // require( 'includes/plugin_updater.php' );
    // retrieve our license key from the DB.
    $license_key = trim( get_option( self::PREFIX . 'license_key' ) );
    
    // setup the updater.
    $edd_updater = new OxyMonster_Plugin_Updater( OXYMONSTER_STORE_URL, __FILE__,
      array(
      'version' => OXYMONSTER_VERSION,    // current version number
      'license' => $license_key,             // license key (used get_option above to retrieve from DB)
      'item_id' => OXYMONSTER_ITEM_ID,    // ID of the product
      'item_name' => self::TITLE,
      'author'  => 'OxyMonster', // author of this plugin
      'url'     => home_url(),
      'beta'    => false,
      )
    );
  }

  static function global_selectors_editor_page() {
    require( 'pages/classes.php' );
  }
   
  static function colors_page() {
    require( 'pages/monster-colors.php' );
  }
   
  static function welcome_page() {
    require( 'pages/welcome.php' );
  }

  static function modules_page() {
    require( 'pages/modules.php' );
  }

  static function global_colors_editor_page() {
    require( 'pages/global-colors.php' );
  }

  static function please_activate_page() {
    require( 'pages/activate.php' );
  }

  static function framework_page() {
    require( 'pages/framework.php' );
  }

}

OxyMonster::init();
?>
