<?php
/*
Plugin Name: OxyMonster Framework
Author: OxyMonster
Author URI: https://oxymonster.com
Description: powerful utility classes based framework, tools & beautiful design kits for Oxygen Builder.
Version: 0.22
Text Domain: oxymonster-framework
*/


if ( ! defined( 'ABSPATH' ) ) exit;

define( 'OXYMONSTER_TITLE', 'OxyMonster Framework' );
define( 'OXYMONSTER_VERSION', '0.22' );
define( 'OXYMONSTER_STORE_URL', 'https://oxymonster.com' );
define( 'OXYMONSTER_ITEM_ID', 20 );
define("OXYMONSTER_ASSETS", 	plugin_dir_url( __FILE__ )  . 	"assets" );

if ( ! class_exists( 'OxyMonster_Plugin_Updater' ) ) {
	include( dirname( __FILE__ ) . '/access/OxyMonster_Plugin_Updater.php' );
}

add_action( 'oxygen_enqueue_ui_scripts', 'oxymonster_scripts' );
/**
 * Add stuff immediately after opening body tag (in both the Oxygen editor and the front end).
 */
function oxymonster_scripts() {
  if ( defined( 'SHOW_CT_BUILDER') ) {
    $oxymonster_copypaste = get_option("oxymonster_copypaste");
      if(isset($oxymonster_copypaste) && $oxymonster_copypaste == "Disable"){
    } else {
      wp_enqueue_script( 'oxymonster-paste', OXYMONSTER_ASSETS. '/js/paste.js', [], OXYMONSTER_VERSION, false );
    }
  }
}

require_once( 'access/OxyMonster_License.php' );

function oxymonster_styles_activate() {
  $monsterStyleSheet = get_option('oxymonster_stylesheet');
  if($monsterStyleSheet == "Installed"){
    update_option('oxymonster_stylesheet_info', 'step 1');
  } else {
    update_option('oxymonster_stylesheet_info', 'step 2');
    include "quick/install.php";
    $monster_styles = $default;
    $import_json = base64_decode($monster_styles);
    $style_sheets 		= get_option("ct_style_sheets", array() );
    if (!is_array($style_sheets)) {
      $style_sheets = array();
    }
    $import_json = sanitize_text_field( stripcslashes( $import_json ) );
    $import_array = json_decode( $import_json, true );
    if(isset($import_array['style_sheets']) && is_array($import_array['style_sheets'])) {
      foreach($import_array['style_sheets'] as $key => $item) {
        foreach($style_sheets as $existing) {
          if($existing['name'] == $item['name']) {
            unset($import_array['style_sheets'][$key]);
            break;
          }
        }
      }
      $style_sheets = array_merge( $style_sheets, $import_array['style_sheets'] );
      update_option("ct_style_sheets", $style_sheets);
    }
    add_option('oxymonster_stylesheet', 'Installed');
  }
}
register_activation_hook(__FILE__, 'oxymonster_styles_activate');

class OxyMonster {
	const PREFIX = 'oxymonster_';
	const TITLE = 'OxyMonster Framework';
  
	static function init() {

    // add_action('admin_init', array(__CLASS__, 'register_option'));
		OxyMonsterLicense::init( self::PREFIX, self::TITLE, OXYMONSTER_STORE_URL, OXYMONSTER_ITEM_ID );
		add_action( 'activate_' . plugin_basename( __FILE__ ), array( __CLASS__, 'activate' ), 10, 2 );

		if ( OxyMonsterLicense::is_activated_license() === true ) {
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'scripts' ), 11 );
		}

		add_action( 'admin_menu', array(__CLASS__, 'admin_menu'), 11);
		add_action( 'admin_init', array(__CLASS__, 'plugin_updater'), 0 );
  }

  static function admin_menu() {
    add_menu_page( OXYMONSTER_TITLE, OXYMONSTER_TITLE, 'manage_options',  'oxymonster_menu' );
    add_submenu_page( 'oxymonster_menu', 'Welcome', 'Welcome', 'manage_options', self::PREFIX.'menu', array(__CLASS__, 'menu_item') );
    add_submenu_page( 'oxymonster_menu', 'Framework', 'Framework', 'manage_options', self::PREFIX.'menu&tab=framework', array(__CLASS__, 'menu_item') );
    add_submenu_page( 'oxymonster_menu', 'Modules', 'Modules', 'manage_options', self::PREFIX.'menu&tab=modules', array(__CLASS__, 'menu_item') );
    add_submenu_page( 'oxymonster_menu', 'Design Kits', 'Design Kits', 'manage_options', self::PREFIX.'menu&tab=sets', array(__CLASS__, 'menu_item') );
    $oxymonster_gcolorseditr = get_option("oxymonster_global_colors_editor");
    if(isset($oxymonster_gcolorseditr) && $oxymonster_gcolorseditr == "Disable"){
    } else {
    add_submenu_page( 'oxymonster_menu', 'Global colors editor', 'Global colors editor', 'manage_options', self::PREFIX.'menu&tab=editor', array(__CLASS__, 'menu_item') );
    }
    $oxymonster_gclasseseditr = get_option("oxymonster_global_classes_editor");
    if(isset($oxymonster_gclasseseditr) && $oxymonster_gclasseseditr == "Disable"){
    } else {
    add_submenu_page( 'oxymonster_menu', 'Global classes editor', 'Global classes editor', 'manage_options', self::PREFIX.'menu&tab=selectors', array(__CLASS__, 'menu_item') );
    }
    add_submenu_page( 'oxymonster_menu', 'Info', 'Info', 'manage_options', self::PREFIX.'menu&tab=info', array(__CLASS__, 'menu_item') );
    add_submenu_page( 'oxymonster_menu', 'License', 'License', 'manage_options', self::PREFIX.'menu&tab=license', array(__CLASS__, 'menu_item') );
  }


  static function menu_item() {
		$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : false;
		?>
		<div class="wrap">
			<h2 class="nav-tab-wrapper">
		    <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=welcome" class="nav-tab<?php echo $tab == 'welcome'?' nav-tab-active':'';?>"">Welcome</a>
		    <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=framework" class="nav-tab<?php echo $tab == 'framework'?' nav-tab-active':'';?>"">Full framework</a>
		    <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=modules" class="nav-tab<?php echo $tab == 'modules'?' nav-tab-active':'';?>">Modules</a>
		    <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=sets" class="nav-tab<?php echo $tab == 'sets'?' nav-tab-active':'';?>">Design Kits</a>
        <?php $oxymonster_gcolorseditr = get_option("oxymonster_global_colors_editor");
        if(isset($oxymonster_gcolorseditr) && $oxymonster_gcolorseditr == "Disable"){
        } else { ?>
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=editor" class="nav-tab<?php echo $tab == 'editor'?' nav-tab-active':'';?>">Global colors editor</a> 
        <?php } 
        $oxymonster_gclasseseditr = get_option("oxymonster_global_classes_editor");
        if(isset($oxymonster_gclasseseditr) && $oxymonster_gclasseseditr == "Disable"){
        } else { ?>
        <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=selectors" class="nav-tab<?php echo $tab == 'selectors'?' nav-tab-active':'';?>">Global classes editor</a>
        <?php } ?>
		    <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=info" class="nav-tab<?php echo $tab == 'info'?' nav-tab-active':'';?>">Info</a>
		    <a href="?page=<?php echo self::PREFIX.'menu';?>&amp;tab=license" class="nav-tab<?php echo $tab == 'license'?' nav-tab-active':'';?>">License</a>
		    </h2>
		<?php
			if($tab === 'license') {
				OxyMonsterLicense::license_page();
			} elseif($tab === 'info') {
        self::info_page();
      } elseif($tab === 'sets') {
        self::design_sets_page();
      } elseif($tab === 'modules') {
        self::modules_page();
      } elseif($tab === 'welcome') {
        self::welcome_page();
      } elseif($tab === 'editor') {
        self::global_colors_editor_page();
      } elseif($tab === 'selectors') {
        self::global_selectors_editor_page();
      } elseif($tab === 'framework') {
        if ( OxyMonsterLicense::is_activated_license() === true ) {
          self::framework_page();
        } else {
          self::please_activate_page();
        }
      } else {
        if ( OxyMonsterLicense::is_activated_license() === true ) {
          self::welcome_page();
        } else {
          self::please_activate_page();
        }
      }
		?>
		</div>
		<?php
  }


   static function global_selectors_editor_page() {
     echo "<h2>Global classes Editor for Oxygen</h2>";
     echo "<h3>This is highly experimental feature and not advised to use on any live/production sites. This feature will be improved vastly in our future releases.</h3>";
     $classes  =  get_option("ct_components_classes", array() );
     $style_folders 		= get_option("ct_style_folders", array());
     $backup_ct_components_classes = get_option("backup_ct_components_classes");
     $backup_ct_style_folders = get_option("backup_ct_style_folders");
     $stylefols = array();
      foreach ($style_folders as $key => $stylefol) {
          array_push($stylefols,$key);
      }
      
     $selectors = array();
      foreach ($classes as $key => $value) {
        $parent = $value["parent"];
        
        if(isset($parent) && !empty($parent)){
            if(in_array(strtolower($parent), array_map('strtolower', $stylefols))) {
                // $selectors[$parent][$key] = $value;
            } else {
                $selectors["uncategorized"][$key] = $value;
            }
        } else {
            $selectors["uncategorized"][$key] = $value;
        }
        
      }
     
     if($_POST["delete_selectors"] == "damn_sure_delete") {
       $classes = array();
       $style_folders = array();
       update_option("ct_components_classes", $classes );
       update_option("ct_style_folders", $style_folders );
     }
     
     if($_POST["delete_cat_selectors"] == "yes_sure_delete") {
       $orphans = $selectors["uncategorized"];
       $style_folders = array();
       update_option("ct_components_classes", $orphans );
       update_option("ct_style_folders", $style_folders );
     }
     
     
     
     
            if(isset($_POST["gs_action"]) && $_POST["gs_action"] == "Delete") {
             delete_option("backup_ct_components_classes");
             delete_option("backup_ct_style_folders");
            }
     
           if(isset($_POST["gs_action"]) && $_POST["gs_action"] == "Backup") {
             if(isset($backup_ct_components_classes) && is_array($backup_ct_style_folders)) {
               update_option("backup_ct_components_classes", $classes); 
               update_option("backup_ct_style_folders", $style_folders); 
               ?>
           <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
             <p>Global classes & style folders backup updated successfully! 👍</p>
           <button type="button" class="notice-dismiss">
             <span class="screen-reader-text">
               Dismiss this notice.
             </span>
           </button>
         <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>
           <?php
             } else {
               add_option("backup_ct_components_classes", $classes);
               add_option("backup_ct_style_folders", $style_folders);
               ?>
             <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
             <p>Global classes & folders backup created successfully! 👍</p>
           <button type="button" class="notice-dismiss">
             <span class="screen-reader-text">
               Dismiss this notice.
             </span>
           </button>
         <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>
             <?php
             }
           }
     
           if(isset($_POST["gs_action"]) && $_POST["gs_action"] == "Restore") {
             update_option("ct_components_classes", $backup_ct_components_classes);
             update_option("ct_style_folders", $backup_ct_style_folders);
             ?>
            <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
             <p>Global classes & style folders backup restored successfully! 👍</p>
           <button type="button" class="notice-dismiss">
             <span class="screen-reader-text">
               Dismiss this notice.
             </span>
           </button>
         <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>
             <?php
           }
     
           $backup_ct_components_classes = get_option("backup_ct_components_classes");
           $backup_ct_style_folders = get_option("backup_ct_style_folders");
           
           $classes  =  get_option("ct_components_classes", array() );
           $style_folders 		= get_option("ct_style_folders", array());
           $backup_ct_components_classes = get_option("backup_ct_components_classes");
           $backup_ct_style_folders = get_option("backup_ct_style_folders");
           
           $stylefols = array();
           foreach ($style_folders as $key => $stylefol) {
               array_push($stylefols,$key);
           }
           ?>
     
            <h4>You have <?php echo count($classes); ?> classes saved/organized in <?php echo count($style_folders); ?> different style folders</h4>
            
            
     <form action="" method="post">
           <input class="button button-primary" type="submit" name="gs_action" value="Backup">
           <?php if(isset($backup_ct_components_classes) && is_array($backup_ct_components_classes)) { ?>
           <input name="gs_action" type="submit" value="Restore" class="button">
           <input name="gs_action" type="submit" value="Delete" class="button">
           <?php } ?>
         </form>
         <hr>
         
         <h4>Delete all global classes and style folders</h4>
         <p>This will remove/delete all the selectors you have in your style folders and this can't be reversed. Please proceed with caution. Only click on this button if you really know what you are doing.<br> Generally this will be helpful if you are using our OxyMonster framework and if we released a new update which might need to reinstall the framework with new optimized classes. Or to clean up all the classes you have in your custom selectors section.</p>
         <hr>
         <p>If you want to delete a particular category classes, you can do that by visiting selectors panel in Oxygen builder and disable/delete the folder/category.</p>
         <hr>
         <form method="post" action="">
           <button type="submit" class="button button-primary" name="delete_selectors" value="damn_sure_delete">Plese delete all classes including uncategorized</button>
           <button type="submit" class="button" name="delete_cat_selectors" value="yes_sure_delete">Keep uncategorized classes & delete classes from style folders</button>
         
         <hr>
         <?php
         $selectors = array();
         foreach ($classes as $key => $value) {
           $parent = $value["parent"];
           
           if(isset($parent)){
               if(in_array(strtolower($parent), array_map('strtolower', $stylefols))) {
                   $selectors[$parent][$key] = $value;
               } else {
                   $selectors["uncategorized"][$key] = $value;
               }
           } else {
               $selectors["uncategorized"][$key] = $value;
           }
           
         }
         
        ?>
        
        <style>
        @media all{.grid{display:grid}.gap-4{grid-gap:1rem;gap:1rem}.grid-cols-6{grid-template-columns:repeat(6,minmax(0,1fr))}.health-check-body h3{padding:0;font-weight:400}.site-health-issues-wrapper{margin-bottom:3rem;margin-top:2rem}.health-check-accordion{border:1px solid #ccd0d4;border-top:0;border-bottom:0}.health-check-accordion-heading{margin:0;border-top:1px solid #ccd0d4;font-size:inherit;line-height:inherit;font-weight:600;color:inherit}.health-check-accordion-trigger{background:#fff;border:0;color:#32373c;cursor:pointer;display:flex;font-weight:400;margin:0;padding:1em 3.5em 1em 1.5em;min-height:46px;position:relative;text-align:left;width:100%;align-items:center;justify-content:space-between}.health-check-accordion-trigger:active,.health-check-accordion-trigger:hover{background:#f8f9f9}.health-check-accordion-trigger:focus{color:#191e23;border:none;box-shadow:none;outline-offset:-1px;outline:2px solid #0071a1;background-color:#f8f9f9}.health-check-accordion-trigger .title{pointer-events:none;font-weight:600;flex-grow:1}.health-check-accordion-trigger .icon{border:solid #555d66;border-width:0 2px 2px 0;height:.5rem;pointer-events:none;position:absolute;right:1.5em;top:50%;transform:translateY(-70%) rotate(45deg);width:.5rem}.health-check-accordion:last-child{border-bottom:1px!important}.health-check-accordion-trigger .badge{padding:.1rem .5rem .15rem;color:#32373c;font-weight:600;margin-left:.5rem}.health-check-accordion-trigger .badge.blue{border:1px solid #bfe7f3}.health-check-accordion-panel{margin:0;padding:1em 1.5em;background:#fff}.health-check-accordion-panel[hidden]{display:none}@media screen and (max-width:782px){.site-health-issues-wrapper .health-check-accordion-trigger{flex-direction:column;align-items:flex-start}.health-check-accordion-trigger .badge{margin:1em 0 0}.md-grid-cols-3{grid-template-columns:repeat(3,minmax(0,1fr))}}}
        </style>
    
    
    
       <div class="health-check-body hide-if-no-js">
        <div class="site-status-has-issues">
          <h2>Global css classes browser</h2>
          <p>Browse your global css selectors you have in Oxygen Builder</p>
  
          <div class="site-health-issues-wrapper">
            <?php
             foreach($selectors as $key => $selector){
            ?>
               <div class="health-check-accordion">
                 <h4 class="health-check-accordion-heading">
                     <button class="health-check-accordion-trigger" type="button" data-cat="data-<?php echo $key; ?>">
                         <span class="title"><?php echo $key; ?></span>
                         <span class="badge blue"><?php echo count($selector); ?> classes</span>
                         <span class="icon"></span>
                     </button>
                 </h4>
                 
                 <div class="health-check-accordion-panel" id="data-<?php echo $key; ?>" style="display: none;">
                   <div class="grid grid-cols-6 md-grid-cols-3 gap-4">
                     <?php 
                     foreach($selector as $mykey => $myselector){ 
                     ?>
                      <div class="">
                          <?php echo $mykey; ?>
                      </div>
                    <?php  
                    }  
                    ?>
                   </div>
                 </div>
               </div>
            <?php
             }
            ?>
       
          </div>
        </div>
      </div>
             
       <script type="text/javascript">
        jQuery('button.health-check-accordion-trigger').on( "click", function(e) {
            var id = jQuery(this).attr('data-cat');
            console.log(id);
            jQuery("div.health-check-accordion-panel").each(function(){
                if(jQuery(this).attr('id') == id) {
                    jQuery(this).toggle();
                } else {
                jQuery(this).hide();
                }
            });
        });
      </script>
         
     <?php
   }
   
   static function welcome_page() {
     
      if($_POST["quick_install_framework"] == "yes_please") {
      $globalColors = $_POST["global_colors"];
      $full_base_framework_checkbox = $_POST["full_base_framework"];
      include "quick/install.php";
      
      if(isset($full_base_framework_checkbox) && $full_base_framework_checkbox == "on" && !empty($full_base_framework_checkbox)){
        $monster_quick_import = $full_base_framework;
      } else {
        $monster_quick_import = $base_framework;
      }
      
      $import_json = base64_decode($monster_quick_import);

      $classes 			= get_option("ct_components_classes", array() );
      $custom_selectors 	= get_option("ct_custom_selectors", array() );
      $style_sets 		= get_option("ct_style_sets", array());
      $style_folders 		= get_option("ct_style_folders", array());
      $style_sheets 		= get_option("ct_style_sheets", array() );
      $global_settings 	= get_option("ct_global_settings", array() );
      $element_presets 	= get_option("oxygen_vsb_element_presets", array());
      $global_colors 		= oxy_get_global_colors();

      // generate export JSON
      $export_json['classes'] 			= $classes;
      $export_json['custom_selectors'] 	= $custom_selectors;
      $export_json['style_sets'] 			= $style_sets;
      $export_json['style_folders'] 		= $style_folders;
      $export_json['style_sheets'] 		= $style_sheets;
      $export_json['global_settings'] 	= $global_settings;
      $export_json['global_colors'] 		= $global_colors;
      $export_json['element_presets'] 	= $element_presets;

      // generate JSON object
      $export_json = json_encode( $export_json );
      $export_backup = get_option("oxymonster_oxygen_settings_backup");

      if(isset($export_backup) && !empty($export_backup)){
        // update_option("oxymonster_oxygen_settings_backup", $export_json);
      } else {
        add_option("oxymonster_oxygen_settings_backup", $export_json);
      }

      if (!is_array($classes)) {
        $classes = array();
      }

      if (!is_array($custom_selectors)) {
        $custom_selectors = array();
      }

      if (!is_array($style_sets)) {
        $style_sets = array();
      }

      if (!is_array($style_folders)) {
        $style_folders = array();
      }

      if (!is_array($style_sheets)) {
        $style_sheets = array();
      }

        $import_json = sanitize_text_field( stripcslashes( $import_json ) );

        // check if empty
        if ( empty( $import_json ) ) {
          $import_errors[] = __("Empty Import");
        }
        else {
          // try to decode
          $import_array = json_decode( $import_json, true );

          // update options
          if ( $import_array ) {

            if(isset($import_array['classes']) && is_array($import_array['classes'])) {
              foreach($import_array['classes'] as $key => $item) {
                if(!is_string($key)) {
                  unset($import_array['classes'][$key]);
                }
              }

              $classes = array_merge( $classes, $import_array['classes'] );
              update_option("ct_components_classes", $classes );
            }

            // custom selectors
            if(isset($import_array['custom_selectors']) && is_array($import_array['custom_selectors'])) {
              $custom_selectors = array_merge( $custom_selectors, $import_array['custom_selectors'] );
              update_option("ct_custom_selectors", $custom_selectors );
            }

            // style sets
            if(isset($import_array['style_sets']) && is_array($import_array['style_sets'])) {
              $style_sets = array_merge( $style_sets, $import_array['style_sets'] );
              update_option("ct_style_sets", $style_sets );
            }

            // style folders
            if(isset($import_array['style_folders']) && is_array($import_array['style_folders'])) {
              $style_folders = array_merge( $style_folders, $import_array['style_folders'] );
              update_option("ct_style_folders", $style_folders );

            }

            // style sheets
            if(isset($import_array['style_sheets']) && is_array($import_array['style_sheets'])) {

              foreach($import_array['style_sheets'] as $key => $item) {
                foreach($style_sheets as $existing) {
                  if($existing['name'] == $item['name']) {
                    unset($import_array['style_sheets'][$key]);
                    break;
                  }
                }
              }
              $style_sheets = array_merge( $style_sheets, $import_array['style_sheets'] );
              update_option("ct_style_sheets", $style_sheets);
            }

            // global settings
            if(isset($import_array['global_settings']) && is_array($import_array['global_settings'])) {
              $global_settings = $import_array['global_settings'];
              update_option("ct_global_settings", $global_settings);
            }

            // global colors
            if(isset($globalColors) && $globalColors == "on" && !empty($globalColors)){
              if (is_array($import_array['global_colors'])) {
                $global_colors = $import_array['global_colors'];
                update_option("oxygen_vsb_global_colors", $global_colors);
                echo "global colors updated";
              }
            }

            // presets
            if(isset($import_array['element_presets']) && is_array($import_array['element_presets'])) {
              $element_presets = array_merge_recursive( $element_presets, $import_array['element_presets'] );
              update_option("oxygen_vsb_element_presets", $element_presets );
            }

            $import_success[] = __("Import success", "component-theme");
            add_option("oxymonster_imported_classes", array("colors", "global_settings", "grid", "font_size", "text", "margin", "padding", "height", "width"));
            update_option("oxymonster_imported_classes", array("colors", "global_settings", "grid", "font_size", "text", "margin", "padding", "height", "width"));
            add_option("oxymonster_quick_install", "installed");
            ?>

        <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Congratulations! OxyMonster Framework quick recommended classes has been installed successfully. 🥳</p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    </div>

      <?php
          }
          else {
            $import_errors[] = __("Wrong JSON Format", "component-theme");
          }
        }
      } ?>

<style>
.oxymonster-heading {
    padding-bottom: 8px!important;
  }

  .oxymonster-flex {
    display: flex;
    flex-direction: row;
    align-items: flex-start;
  }
  .oxymonster-leftside {
    background-color: #FFFFFF;
    width: 50%;
    max-width: 420px;
    padding: 30px;
    padding-top:12px;
    border-radius: 8px;
  }
  .oxymonster-rightside {
      background-color: #FFFFFF;
      padding: 30px;
      padding-top:12px;
      max-width: 420px;
      margin-left: 30px;
      width: 50%;
      border-radius: 8px;
  }


  .oxymonsterflex {
    display: flex;
    flex-direction: row;
    align-items: flex-start;
padding-top: 20px;
  }

  .oxymonsterleftside {
    width: 60%;
    max-width: 420px;
    padding:12px;
    border-radius: 8px;
  }
  .oxymonsterrightside {
      padding:12px;
      max-width: 420px;
      margin-left: 80px;
      margin-top: 20px;
      width: 40%;
      border-radius: 8px;
  }


  .oxymonster-section {
      margin-bottom: 30px;
  }

  .oxymonster-submit {
    background: #007cba;
    color: #fff;
    text-decoration: none;
    text-shadow: none;
    font-size: 16px!important;
    padding: 12px 24px;
    border-radius: 4px;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    border: 0;
    cursor: pointer;
    margin: 10px 0px 15px 0px;
  }

  .oxymonster-install-notice {
    margin: 20px 0px;
  }

  .oxymonster-subtext {
    font-size: 14px;
    margin-bottom: 20px;
  }
  p {
    font-size: 14px;
    line-height: 1.6;
  }

    .oxymonster-success {
    font-size: 18px;
    font-weight: 500;
    background: #F0FFF4;
    padding: 16px 0px;
    color: #276749;
    max-width: 990px;
    width: 100%;
    border-radius: 4px;
    text-align: center;
    }

    </style>

          <div class="oxymonsterflex">
      <div class="oxymonsterleftside">
        	<h2>OxyMonster Base Framework</h2>

    <div class="oxymonster-subtext">Mandatory base framework installation to use our design sets 🚀</div>
    </div><div class="oxymonsterrightside">
        <form action="" method="post">
          <input type="checkbox" id="global_colors" name="global_colors" value="on"> Import Global Colors (It will overwrite your existing Oxygen Global Colors, recommended in fresh installs & and sites where you are not going to use any design kits)
          </br><br>
          <input type="checkbox" id="full_base_framework" name="full_base_framework" value="on">
          Import styled selectors (This option will add a few global settings, cards, buttons, avatar classes. If you are going to use our ready made design sets, you don't need to check this option as our design kits will have it's own cards, buttons, and avatar styles. If you are going to design the entire website without any design kit, it is recommended to install the full base framework with all the necessary extra classes to speedup the flow)
          </br><br>
            <?php
              $quick_install = get_option("oxymonster_quick_install");
              if(isset($quick_install) && $quick_install == "installed") { ?>
                <button type="submit" class="oxymonster-submit button button-primary" name="quick_install_framework" disabled value="yes_please">Our base framework is installed</button>
                <button type="submit" class="button" name="quick_install_framework" value="yes_please">Want to Reinstall?</button>
              <?php } else { ?>
                <button type="submit" class="oxymonster-submit button button-primary" name="quick_install_framework" value="yes_please">Install the base framework</button>
              <?php } ?>

              </form>
</div></div>
    <br>
 <div class="wrap">
        <div class="oxymonster-flex">
      <div class="oxymonster-leftside">

        <div class="oxymonster-section">
          <h2>500 well planned utility classes</h2>
          <p>We have hand picked most useful and well planned 500 classes to work with our design sets easily.</p>
        </div>

        <div class="oxymonster-section">
          <h2>Responsive classes included</h2>
          <p>We have also included so many responsive classes you can use normally like any other class to quickly create responsive web pages. Now you don't need to write separate styles for each breakpoint.</p>
        </div>

        <div class="oxymonster-section">
          <h2>Light weight under 40KB</h2>
          <p>OxyMonster base framework is light as we hand picked a great selection of classes to get most out of it.</p>
        </div>

        <div class="oxymonster-section">
          <h2>Tailwind CSS inspired</h2>
          <p>The utility-first Tailwind CSS framework profoundly inspires OxyMonster. Tailwind CSS is a highly customizable, low-level CSS framework that gives you all of the building blocks.</p>
          <a href="https://tailwindcss.com">Learn more about Tailwind CSS</a>
        </div>
      </div>

    <div class="oxymonster-rightside">

      <div class="oxymonster-section">
        <h2>100% CSS grid support</h2>
        <p>Use our in-built CSS grid classes to kick-start designing columns and rows. CSS grid is must faster to work with and more powerful and all the browsers natively support it.</p>
      </div>

       <div class="oxymonster-section">
        <h2>Bulk classes Merger plugin</h2>
        <p>You can use our one click merge button to merge all the classes you have used to create a new class. With our plugin you don't need to write multiple bunch of class names everytime you are creating a repeated element.</p>
      </div>

		  <div class="oxymonster-section">
        <h2>Optimized for Oxygen Builder</h2>
        <p>We love Oxygen, we love Tailwind, and we love making websites faster & better. Our stack is highly optimized for Oxygen Builder, and all our classes show up in your editor whenever you try to use a CSS class.</p>
        <a href="https://oxygenbuilder.com">Oxygen Builder</a>
      </div>


      <div class="oxymonster-section">
        <h2>Categorized CSS Selectors</h2>
        <p>All our classes are categorized correctly in the Oxygen Builder selectors area to quickly lookup when you need something, and you want to change something to your preference.</p>
      </div>

  </div>



  <?php
   }

   static function modules_page() {
    echo "<h2>Modules Manager for OxyMonster</h2>";
    echo "<p>Enable/Disable special modules for Oxygen Builder</p>";

    $oxymonster_mergeClasses = get_option("oxymonster_mergeClasses");
    if($_POST["oxymonster_mergeClasses"]) {
      if(isset($oxymonster_mergeClasses) && !empty($oxymonster_mergeClasses)){
        if($_POST["oxymonster_mergeClasses"] == "Disable") {
          update_option("oxymonster_mergeClasses", "Disable");
        } elseif($_POST["oxymonster_mergeClasses"] == "Enable") {
          update_option("oxymonster_mergeClasses", "Enable");
        }
      } else {
        add_option("oxymonster_mergeClasses", "Disable");
      }
    }
    
    $oxymonster_copyPaste = get_option("oxymonster_copypaste");
    if($_POST["oxymonster_copypaste"]) {
      if(isset($oxymonster_copyPaste) && !empty($oxymonster_copyPaste)){
        if($_POST["oxymonster_copypaste"] == "Disable") {
          update_option("oxymonster_copypaste", "Disable");
        } elseif($_POST["oxymonster_copypaste"] == "Enable") {
          update_option("oxymonster_copypaste", "Enable");
        }
      } else {
        add_option("oxymonster_copypaste", "Disable");
      }
    }
    
    $oxymonster_global_colors_editor = get_option("oxymonster_global_colors_editor");
    if($_POST["oxymonster_global_colors_editor"]) {
      if(isset($oxymonster_global_colors_editor) && !empty($oxymonster_global_colors_editor)){
        if($_POST["oxymonster_global_colors_editor"] == "Disable") {
          update_option("oxymonster_global_colors_editor", "Disable");
        } elseif($_POST["oxymonster_global_colors_editor"] == "Enable") {
          update_option("oxymonster_global_colors_editor", "Enable");
        }
      } else {
        add_option("oxymonster_global_colors_editor", "Disable");
      }
    }
    
    $oxymonster_global_classes_editor = get_option("oxymonster_global_classes_editor");
    if($_POST["oxymonster_global_classes_editor"]) {
      if(isset($oxymonster_global_classes_editor) && !empty($oxymonster_global_classes_editor)){
        if($_POST["oxymonster_global_classes_editor"] == "Disable") {
          update_option("oxymonster_global_classes_editor", "Disable");
        } elseif($_POST["oxymonster_global_classes_editor"] == "Enable") {
          update_option("oxymonster_global_classes_editor", "Enable");
        }
      } else {
        add_option("oxymonster_global_classes_editor", "Disable");
      }
    }
    ?>

    <style>
      .activate_link {
        background: none;
        border: none;
        color: #0073aa;
        font-size: 13px;
        cursor: pointer;
        padding: 0px;
      }



      .activate_link:hover {
        color: #00a0d2;
      }

      .activated_link {
        color: #47525d;
      }

      .monster_text {
        color: #333;
      }

    </style>
    <form action="" method="post">
        <table class="wp-list-table widefat plugins">
          <thead>
            <tr>
              <th scope="col" id="name" class="manage-column column-name column-primary">Module Name</th>
              <th scope="col" id="description" class="manage-column column-description">Description</th>
            </tr>
          </thead>

          <tbody id="the-list">

                <?php
                $oxymonster_mergeClasses = get_option("oxymonster_mergeClasses");
                if(isset($oxymonster_mergeClasses) && $oxymonster_mergeClasses == "Disable") {
                  echo "<tr class='inactive'>";
                } elseif(isset($oxymonster_mergeClasses) && $oxymonster_mergeClasses == "Enable") {
                  echo "<tr class='active'>";
                } else {
                  echo "<tr class='active'>";
                } ?>
              <td class="plugin-title column-primary">
                <strong>Merge classes + Utility classes lock button in the editor</strong>
                <div class="row-actions visible">
                <?php
                $oxymonster_mergeClasses = get_option("oxymonster_mergeClasses");
                if(isset($oxymonster_mergeClasses) && $oxymonster_mergeClasses == "Disable") {
                  ?>
                  <span class="monster_text">Disabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_mergeClasses" value="Enable">
                <?php } elseif(isset($oxymonster_mergeClasses) && $oxymonster_mergeClasses == "Enable") { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_mergeClasses" value="Disable">
                <?php } else { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_mergeClasses" value="Disable">

                <?php } ?>
                </div>
              </td>
              <td class="column-description desc">
                <div class="plugin-description">
                <p>Merge classes button is useful to marge multiple classes and combine all other classes properties into one class. <br>It is useful when you are working with a utility framework like Tailwind based OxyMonster Framework.</p>
                </div>
              </td>
            </tr>
                <?php
                $oxymonster_copyPaste = get_option("oxymonster_copypaste");
                if(isset($oxymonster_copyPaste) && $oxymonster_copyPaste == "Disable") {
                  echo "<tr class='inactive'>";
                } elseif(isset($oxymonster_copyPaste) && $oxymonster_copyPaste == "Enable") {
                  echo "<tr class='active'>";
                } else {
                  echo "<tr class='active'>";
                } ?>
              <td class="plugin-title column-primary">
                <strong>Paste button in the editor</strong>
                <div class="row-actions visible">
                <?php
                $oxymonster_copyPaste = get_option("oxymonster_copypaste");
                if(isset($oxymonster_copyPaste) && $oxymonster_copyPaste == "Disable") {
                  ?>
                  <span class="monster_text">Disabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_copypaste" value="Enable">
                <?php } elseif(isset($oxymonster_copyPaste) && $oxymonster_copyPaste == "Enable") { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_copypaste" value="Disable">
                <?php } else { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_copypaste" value="Disable">

                <?php } ?>
                </div>
              </td>
              <td class="column-description desc">
                <div class="plugin-description">
                <p>Now copy and paste our sections from our design set with one click. <br>It is easy and quick way to get started with our design sets.</p>
                </div>
              </td>
            </tr>
                <?php
                $oxymonster_global_colors_editor = get_option("oxymonster_global_colors_editor");
                if(isset($oxymonster_global_colors_editor) && $oxymonster_global_colors_editor == "Disable") {
                  echo "<tr class='inactive'>";
                } elseif(isset($oxymonster_global_colors_editor) && $oxymonster_global_colors_editor == "Enable") {
                  echo "<tr class='active'>";
                } else {
                  echo "<tr class='active'>";
                } ?>
              <td class="plugin-title column-primary">
                <strong>Global colors editor</strong>
                <div class="row-actions visible">
                <?php
                $oxymonster_global_colors_editor = get_option("oxymonster_global_colors_editor");
                if(isset($oxymonster_global_colors_editor) && $oxymonster_global_colors_editor == "Disable") {
                  ?>
                  <span class="monster_text">Disabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_global_colors_editor" value="Enable">
                <?php } elseif(isset($oxymonster_global_colors_editor) && $oxymonster_global_colors_editor == "Enable") { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_global_colors_editor" value="Disable">
                <?php } else { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_global_colors_editor" value="Disable">

                <?php } ?>
                </div>
              </td>
              <td class="column-description desc">
                <div class="plugin-description">
                <p>You can edit global colors & global color sets ids, names and edit all the info related to your global colors.</p>
                </div>
              </td>
            </tr>
                <?php
                $oxymonster_global_classes_editor = get_option("oxymonster_global_classes_editor");
                if(isset($oxymonster_global_classes_editor) && $oxymonster_global_classes_editor == "Disable") {
                  echo "<tr class='inactive'>";
                } elseif(isset($oxymonster_global_classes_editor) && $oxymonster_global_classes_editor == "Enable") {
                  echo "<tr class='active'>";
                } else {
                  echo "<tr class='active'>";
                } ?>
              <td class="plugin-title column-primary">
                <strong>Global classes browser</strong>
                <div class="row-actions visible">
                <?php
                $oxymonster_global_classes_editor = get_option("oxymonster_global_classes_editor");
                if(isset($oxymonster_global_classes_editor) && $oxymonster_global_classes_editor == "Disable") {
                  ?>
                  <span class="monster_text">Disabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_global_classes_editor" value="Enable">
                <?php } elseif(isset($oxymonster_global_classes_editor) && $oxymonster_global_classes_editor == "Enable") { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_global_classes_editor" value="Disable">
                <?php } else { ?>
                <span class="monster_text">Enabled | </span>
                  <input class="activate_link" type="submit" name="oxymonster_global_classes_editor" value="Disable">

                <?php } ?>
                </div>
              </td>
              <td class="column-description desc">
                <div class="plugin-description">
                <p>Browse & delete your global classes and check the overview of your global selectors.</p>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
        </form>
  <?php
   }

  static function global_colors_editor_page() {
    echo "<h2>OxyMonster - Oxygen Global Colors Editor</h2>";
    echo "<p>Edit Oxygen's global colors without a hassle</p><hr>";
    ?>

    <div id="message" class="notice is-dismissible update-message notice inline notice-warning notice-alt" style="margin-top: 20px;">
        <p>Warning - Only change these settings if you really know what you are doing! - Backup global colors before making any changes below. 👇 </p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>

    <?php
    // echo "<p>Please backup Global colors before making any changes below";
    // echo "<br>";
    $global_colors 		= oxy_get_global_colors();
    $gcolors = $global_colors["colors"];
    $gsets = $global_colors["sets"];
    ?>


      <?php
       if(isset($_POST["gc_action"]) && $_POST["gc_action"] == "Delete") {
        delete_option("backup_oxygen_vsb_global_colors");
       }

      if(isset($_POST["gc_action"]) && $_POST["gc_action"] == "Backup") {
        if(isset($backup_global_colors) && is_array($backup_global_colors)) {
          update_option("backup_oxygen_vsb_global_colors", $global_colors); ?>
      <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Global colors backup updated successfully! 👍</p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>
      <?php
        } else {
          add_option("backup_oxygen_vsb_global_colors", $global_colors);
          ?>
        <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Global colors backup created successfully! 👍</p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>
        <?php
        }
      }

      if(isset($_POST["gc_action"]) && $_POST["gc_action"] == "Restore") {
        update_option("oxygen_vsb_global_colors", $backup_global_colors);
        ?>
       <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Global colors backup restored successfully! 👍</p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>
        <?php
      }

      $backup_global_colors = get_option("backup_oxygen_vsb_global_colors");
      ?>

<form action="" method="post">
      <input class="button button-primary" type="submit" name="gc_action" value="Backup">
      <?php if(isset($backup_global_colors) && is_array($backup_global_colors)) { ?>
      <input name="gc_action" type="submit" value="Restore" class="button">
      <input name="gc_action" type="submit" value="Delete" class="button">
      <?php } ?>
    </form>
    <hr>


    <?php
      if($_POST) {
        $post_data = $_POST;

        function recursive_sanitize_text_field($array) {
          foreach ( $array as $key => &$value ) {
              if ( is_array( $value ) ) {
                  $value = recursive_sanitize_text_field($value);
              }
              else {
                  $value = sanitize_text_field( $value );
              }
          }
          return $array;
        }

        recursive_sanitize_text_field($post_data);

        if(isset($backup_global_colors) && is_array($backup_global_colors)) {
          // update_option("backup_oxygen_vsb_global_colors", $global_colors);
        } else {
          add_option("backup_oxygen_vsb_global_colors", $global_colors);
        }

        if($_POST["global_colors"]){

        $gbcolors = array();
        unset($post_data["global_colors"]);
        foreach ($post_data as $key => $value) {

          $gbcolors[$key] = array(
            "id" => (int)$value["id"],
            "name" => $value["name"],
            "value" => $value["value"],
            "set" => (int)$value["set"]
          );

        }

        unset($global_colors["colors"]);
        $global_colors["colors"] = $gbcolors;
        update_option("oxygen_vsb_global_colors", $global_colors);
      ?>

      <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Global colors updated successfully! 👍 </p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>

      <?php
        } elseif($post_data["global_sets"]){

        $gbsets = array();
        unset($post_data["global_sets"]);
        foreach ($post_data as $key => $value) {
          $gbsets[$key] = array(
            "id" => (int)$value["id"],
            "name" => $value["name"]
          );

        }
        unset($global_colors["sets"]);
        $global_colors["sets"] = $gbsets;
        update_option("oxygen_vsb_global_colors", $global_colors);
        ?>

        <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Global color sets updated successfully! 👍</p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>

    <?php
      }
        $global_colors 		= oxy_get_global_colors();
      $gcolors = $global_colors["colors"];
      $gsets = $global_colors["sets"];

    }

      ?>
<style>
.monster_input {
  border: 1px solid #dadada!important;
}
.mb-3 {
  margin-bottom: 12px;
}
</style>

    <form method="post" action="" name="globalSets">
<h4>Edit Global Color Sets</h4>
    <table class="table table-striped mb-3" id="dataTable">
<thead>
<tr>
    <th>Set ID</th>
    <th>Set Name</th>
</tr>
</thead>
<tbody>


    <?php
    foreach ($gsets as $gskey => $gsvalue) { ?>

      <tr>
            <td><input class="monster_input" type="number" name='<?php echo $gskey; ?>[id]'
                       value="<?php echo $gsvalue["id"]; ?>"/></td>
            <td><input class="monster_input" type="text" name='<?php echo $gskey; ?>[name]'
                       value="<?php echo $gsvalue["name"]; ?>"/></td>
                       </tr>

    <?php
    }
    ?>
</tbody></table>
<input name="global_sets" type="Submit" value="Save Global Sets" class="button button-primary">

</form>

<br>
<hr>

 <form method="post" action="">
    <h4>Edit Global colors</h4>

       <table class="table table-striped mb-3" id="dataTable">
<thead>
<tr>
    <th>ID</th>
    <th>Name</th>
    <th>Value</th>
    <th>Set</th>
</tr>
</thead>
<tbody>


    <?php
    foreach ($gcolors as $key => $value) { ?>

      <tr>
            <td><input class="monster_input" type="number" name='<?php echo $key; ?>[id]'
                       value="<?php echo $value["id"]; ?>"/></td>
            <td><input class="monster_input" type="text" name='<?php echo $key; ?>[name]'
                       value="<?php echo $value["name"]; ?>"/></td>
            <td><input class="monster_input" type="text" name='<?php echo $key; ?>[value]'
                       value="<?php echo $value["value"]; ?>"/></td>
            <td><input class="monster_input" type="number" name='<?php echo $key; ?>[set]'
                       value="<?php echo $value["set"]; ?>"/></td>
                       </tr>

    <?php
    }
?>
</tbody></table>
<input name="global_colors" type="submit" class="button button-primary" value="Save Global Colors">
</form>

<?php

  }


  static function design_sets_page() {

    echo "<h2>OxyMonster Design Sets</h2>";
    echo "<p>Check our design kits specially made with our framework.</p>";
    echo '<div style="margin-bottom: 12px;"><a href="https://links.oxymonster.com/offer"><img src="https://oxymonster.com/plugin-offer.jpg"></a></div>';
    // $sets_url = "";

    // $d_sets = wp_remote_get($sets_url, array());
    // $design_sets = wp_remote_retrieve_body($d_sets);

    // $design_sets = json_decode($design_sets, true);
    // $design_sets_data = $design_sets["data"];
    ?>

    <!-- <div class="theme-browser rendered">
      <div class="themes wp-clearfix"> -->


    <?php
      // foreach($design_sets_data as $design_set) {
      //   $set_name = $design_set["name"];
      //   $set_description = $design_set["description"];
      //   $set_thumbnail = $design_set["thumbnail"];
      //   $set_link = $design_set["link"];
      //   $set_price = $design_set["price"];
      //   $set_buynowlink = $design_set["buynowlink"];
      //   $set_moreinfo = $design_set["moreinfo"];
      ?>

        <!-- <style>
            .nav-tab-wrapper {
              margin-bottom: 20px!important;
            }
            /* .theme-browser .theme .theme-actions {
              opacity: 1!important;
            } */
            .theme-browser .theme .theme-price {
              opacity: 1!important;
              padding: 0px 15px!important;
              border: none;
              background: none;
            }

            .theme-browser .theme:hover .theme-price {
              opacity: 0!important;
            }

            .displayflex {
              display: inline-flex;
            }

            .nowbtn {
              height: 32px!important;
              margin-top: 10px!important;
              margin-left: 6px!important;
            }
            .nowbtnleft {
              height: 32px!important;
              margin-top: 10px!important;
              margin-left: 12px!important;
            }
        </style>
    <div class="theme">
      <div class="theme-screenshot">
        <img src="<?php echo $set_thumbnail; ?>" alt="<?php echo $set_name; ?>">
      </div>
      <a href="<?php echo $set_link; ?>"><span class="more-details">
        <?php echo $set_description; ?>
      </span></a>

      <div class="theme-id-container">
        <h2 class="theme-name"><?php echo $set_name; ?></h2>
      <div class="theme-actions">
        <a class="button activate" href="<?php echo $set_link; ?>">More info</a>
        <a class="button button-primary" href="<?php echo $set_buynowlink; ?>">Buy now</a>
      </div>
      <div class="theme-price theme-actions displayflex">
        <h2><?php echo $set_price; ?></h2>
        <a class="button activate nowbtnleft" href="<?php echo $set_link; ?>">More info</a>
        <a class="button button-primary nowbtn" href="<?php echo $set_buynowlink; ?>">Buy now</a>
      </div>

	</div>
</div> -->

      <?php
    // }
    ?>
  <!-- </div>
</div> -->


   <?php
   }

   static function info_page(){ ?>

   <style>
.oxymonster-heading {
    padding-bottom: 8px!important;
  }

  .oxymonster-flex {
    display: flex;
    flex-direction: row;
    align-items: flex-start;
  }
  .oxymonster-leftside {
    background-color: #FFFFFF;
    width: 50%;
    max-width: 420px;
    padding: 30px;
    padding-top:12px;
    border-radius: 8px;
  }
  .oxymonster-rightside {
      background-color: #FFFFFF;
      padding: 30px;
      padding-top:12px;
      max-width: 420px;
      margin-left: 30px;
      width: 50%;
      border-radius: 8px;
  }

  .oxymonster-section {
      margin-bottom: 30px;
  }

  .oxymonster-submit {
    background: #007cba;
    color: #fff;
    text-decoration: none;
    text-shadow: none;
    font-size: 18px;
    padding: 12px 24px;
    border-radius: 4px;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    border: 0;
    cursor: pointer;
    margin: 10px 0px 15px 0px;
  }

  .oxymonster-install-notice {
    margin: 20px 0px;
  }

  .oxymonster-subtext {
    font-size: 14px;
    margin-bottom: 20px;
  }
  p {
    font-size: 14px;
    line-height: 1.6;
  }

    .oxymonster-success {
    font-size: 18px;
    font-weight: 500;
    background: #F0FFF4;
    padding: 16px 0px;
    color: #276749;
    max-width: 990px;
    width: 100%;
    border-radius: 4px;
    text-align: center;
    }

    </style>

<div class="wrap">
    <h2><?php echo OXYMONSTER_TITLE; ?></h2>
    <p>Power up your Oxygen website with OxyMonster Framework now 🚀</p>

    <div class="oxymonster-flex">
      <div class="oxymonster-leftside">

        <div class="oxymonster-section">
          <h2>1000+ utility classes</h2>
          <p>We have well over 1000 CSS classes to quickly pick and use them to speed up your website designing. Just use a CSS class whenever it is required. No more opinionated pre-designed components.</p>
          <!-- <a href="https://oxymonster.com/framework/classes">Browse all our classes</a> -->
        </div>

        <div class="oxymonster-section">
          <h2>Only install what you really want</h2>
          <p>You can select and install the classes you will use. We have a very robust selection panel with 30+ categories of css classes to choose from. Now it's very easy to kick start your project.</p>
          <!-- <a href="https://oxymonster.com/framework/categories">Check all our categories</a> -->
        </div>

        <div class="oxymonster-section">
          <h2>Responsive classes included</h2>
          <p>We have also included so many responsive classes you can use normally like any other class to quickly create responsive web pages. Now you don't need to write separate styles for each breakpoint.</p>
          <!-- <a href="https://oxymonster.com/framework/responsive">More about responsive classes</a> -->
        </div>

        <div class="oxymonster-section">
          <h2>Light weight installation</h2>
          <p>OxyMonster framework is very light as you can only install whatever you want. It's under 50KB if you use most of the classes. If you use a cache plugin, the size will be even smaller than that. You don't need to write another repeated class again.</p>
        </div>

        <div class="oxymonster-section">
          <h2>Tailwind CSS inspired</h2>
          <p>The utility-first Tailwind CSS framework profoundly inspires OxyMonster. Tailwind CSS is a highly customizable, low-level CSS framework that gives you all of the building blocks.</p>
          <a href="https://tailwindcss.com">Learn more about Tailwind CSS</a>
        </div>

        <div class="oxymonster-section">
          <h2>Very well documented</h2>
          <p>Read our documentation to know how and what to use when you need something. We have added all our classes by category to play with them.</p>
          <ul>
            <li>
              <!-- <a href="https://oxymonster.com/documentation">Read our documentation</a> -->
            </li>
            <li>
              <!-- <a href="https://oxymonster.com/cheatsheet">Download our cheatsheet</a> -->
            </li>
          </ul>


        </div>
      </div>

    <div class="oxymonster-rightside">

      <div class="oxymonster-section">
        <h2>100% CSS grid support</h2>
        <p>Use our in-built CSS grid classes to kick-start designing columns and rows. CSS grid is must faster to work with and more powerful and all the browsers natively support it.</p>
        <!-- <a href="https://oxymonster.com/framework/css-grid">Learn CSS Grid</a> -->
      </div>

       <div class="oxymonster-section">
        <h2>Bulk classes Merger plugin</h2>
        <p>You can use our one click merge button to merge all the classes you have used to create a new class. With our plugin you don't need to write multiple bunch of class names everytime you are creating a repeated element.</p>
        <!-- <a href="https://oxymonster.com/framework/merge-button">Learn more about our Merge button</a> -->
      </div>

       <div class="oxymonster-section">
        <h2>Hover styles included</h2>
        <p>We have included a few hover classes for most useful properties. You can just write our hover classes just like any other css class and apply special classes for hover state as well.</p>
        <!-- <a href="https://oxymonster.com/framework/hover-classes">Read about hover classes</a> -->
      </div>

		  <div class="oxymonster-section">
        <h2>Optimized for Oxygen Builder</h2>
        <p>We love Oxygen, we love Tailwind, and we love making websites faster & better. Our stack is highly optimized for Oxygen Builder, and all our classes show up in your editor whenever you try to use a CSS class.</p>
        <a href="https://oxygenbuilder.com">Oxygen Builder</a>
      </div>


      <div class="oxymonster-section">
        <h2>Categorized CSS Selectors</h2>
        <p>All our classes are categorized correctly in the Oxygen Builder selectors area to quickly lookup when you need something, and you want to change something to your preference.</p>
      </div>

      <div class="oxymonster-section">
        <h2>Help and tutorials</h2>
        <p>If you need any help, feedback to share or know how to use our framework, take a look at below resources.</p>
        <ul>
          <li>
            <a href="https://oxymonster.com/help">Help & feedback</a>
          </li>
          <li>
            <!-- <a href="https://oxymonster.com/tutorials">Tutorials</a> -->
            </li>
          </ul>
      </div>

  </div>


   <?php
   }

  static function please_activate_page() { ?>

  <style>

  .oxymonster-flex {
    display: flex;
    flex-direction: row;
    align-items: flex-start;
  }
  .oxymonster-leftside {
    background-color: #FFFFFF;
    width: 50%;
    max-width: 420px;
    padding: 30px;
    padding-top:12px;
    border-radius: 8px;
  }
  .oxymonster-rightside {
      background-color: #FFFFFF;
      padding: 30px;
      padding-top:12px;
      max-width: 420px;
      margin-left: 30px;
      width: 50%;
      border-radius: 8px;
  }

  .oxymonster-section {
      margin-bottom: 30px;
  }

  .whitebg {
    background: #fff;
    border-radius: 8px;
    padding: 12px;
    width: 960px;
    margin-top: 20px;
  }

    </style>

    <div class="oxymonster-section whitebg">

    <h2><?php echo OXYMONSTER_TITLE; ?> - <a href="admin.php?page=oxymonster_menu&tab=license">please activate</a></h2>

      <p>You need to get your license key from oxymonster.com and activate your license in the license tab</p>
      <p>Please activate your license <a href="admin.php?page=oxymonster_menu&tab=license">here</a></p>
      <p>Once you activate your license you can install our framework and use our class multiple merger plugin to speed up your website designing process</p>
    </div>

    <div class="oxymonster-flex">
      <div class="oxymonster-leftside">

        <div class="oxymonster-section">
          <h2>1000+ utility classes</h2>
          <p>We have well over 1000 CSS classes to quickly pick and use them to speed up your website designing. Just use a CSS class whenever it is required. No more opinionated pre-designed components.</p>
          <!-- <a href="https://oxymonster.com/framework/classes">Browse all our classes</a> -->
        </div>

        <div class="oxymonster-section">
          <h2>Only install what you really want</h2>
          <p>You can select and install the classes you will use. We have a very robust selection panel with 30+ categories of css classes to choose from. Now it's very easy to kick start your project.</p>
          <!-- <a href="https://oxymonster.com/framework/categories">Check all our categories</a> -->
        </div>

        <div class="oxymonster-section">
          <h2>Responsive classes included</h2>
          <p>We have also included so many responsive classes you can use normally like any other class to quickly create responsive web pages. Now you don't need to write separate styles for each breakpoint.</p>
          <!-- <a href="https://oxymonster.com/framework/responsive">More about responsive classes</a> -->
        </div>

        <div class="oxymonster-section">
          <h2>Light weight installation</h2>
          <p>OxyMonster framework is very light as you can only install whatever you want. It's under 50KB if you use most of the classes. If you use a cache plugin, the size will be even smaller than that. You don't need to write another repeated class again.</p>
        </div>

        <div class="oxymonster-section">
          <h2>Tailwind CSS inspired</h2>
          <p>The utility-first Tailwind CSS framework profoundly inspires OxyMonster. Tailwind CSS is a highly customizable, low-level CSS framework that gives you all of the building blocks.</p>
          <a href="https://tailwindcss.com">Learn more about Tailwind CSS</a>
        </div>

        <div class="oxymonster-section">
          <h2>Very well documented</h2>
          <p>Read our documentation to know how and what to use when you need something. We have added all our classes by category to play with them.</p>
          <ul>
            <li>
              <!-- <a href="https://oxymonster.com/documentation">Read our documentation</a> -->
            </li>
            <li>
              <!-- <a href="https://oxymonster.com/cheatsheet">Download our cheatsheet</a> -->
            </li>
          </ul>


        </div>
      </div>

    <div class="oxymonster-rightside">

      <div class="oxymonster-section">
        <h2>100% CSS grid support</h2>
        <p>Use our in-built CSS grid classes to kick-start designing columns and rows. CSS grid is must faster to work with and more powerful and all the browsers natively support it.</p>
        <!-- <a href="https://oxymonster.com/framework/css-grid">Learn CSS Grid</a> -->
      </div>

       <div class="oxymonster-section">
        <h2>Bulk classes Merger plugin</h2>
        <p>You can use our one click merge button to merge all the classes you have used to create a new class. With our plugin you don't need to write multiple bunch of class names everytime you are creating a repeated element.</p>
        <!-- <a href="https://oxymonster.com/framework/merge-button">Learn more about our Merge button</a> -->
      </div>

       <div class="oxymonster-section">
        <h2>Hover styles included</h2>
        <p>We have included a few hover classes for most useful properties. You can just write our hover classes just like any other css class and apply special classes for hover state as well.</p>
        <!-- <a href="https://oxymonster.com/framework/hover-classes">Read about hover classes</a> -->
      </div>

		  <div class="oxymonster-section">
        <h2>Optimized for Oxygen Builder</h2>
        <p>We love Oxygen, we love Tailwind, and we love making websites faster & better. Our stack is highly optimized for Oxygen Builder, and all our classes show up in your editor whenever you try to use a CSS class.</p>
        <!-- <a href="https://oxygenbuilder.com">Oxygen Builder</a> -->
      </div>


      <div class="oxymonster-section">
        <h2>Categorized CSS Selectors</h2>
        <p>All our classes are categorized correctly in the Oxygen Builder selectors area to quickly lookup when you need something, and you want to change something to your preference.</p>
      </div>

      <div class="oxymonster-section">
        <h2>Help and tutorials</h2>
        <p>If you need any help, feedback to share or know how to use our framework, take a look at below resources.</p>
        <ul>
          <li>
            <a href="https://oxymonster.com/help">Help & feedback</a>
          </li>
          <li>
            <!-- <a href="https://oxymonster.com/tutorials">Tutorials</a> -->
            </li>
          </ul>
      </div>

    </div>




 <?php }

  static function framework_page() {

    if(!empty($_POST)){
      // var_dump($_POST);

    if($_POST["global_settings"] == "on" || $_POST["global_settings"] == "Activate") {
      include "framework/global_settings.php";
      $monster_global_settings = $settings_data;
    }
    if($_POST["grid"] == "on" || $_POST["grid"] == "Activate") {
      include "framework/grid.php";
      $monster_style_sheets = $style_sheets;
    }

    foreach (glob(plugin_dir_path( __FILE__ ) . "framework/*.php") as $classfile){
      include $classfile;
      $basename = explode(".", basename($classfile))[0];
      $basenames[] = $basename;
    }

    $classes_array = $_POST;
    $imported_classes = get_option("oxymonster_imported_classes");

    $classes_array_keys = array_keys($classes_array);

    $classes_array_keys = array_intersect($basenames, $classes_array_keys);

    if($imported_classes){
      $classesArrayMerged = array_unique(array_merge($imported_classes, $classes_array_keys));
      update_option("oxymonster_imported_classes", $classesArrayMerged);
    } else {
      add_option("oxymonster_imported_classes", $classes_array_keys);
    }


    foreach ($classes_array_keys as $key) {
      include "framework/".$key.".php";
      if($stylefols){
        foreach ($stylefols as $stylefol) {
          $stylesheetfolders["style_folders"][$stylefol]["key"] = $stylefol;
          $stylesheetfolders["style_folders"][$stylefol]["status"] = 1;
        }
      }

      if($classes_data){
        foreach ($classes_data as $class_data) {
          $class_data = json_decode(base64_decode($class_data), true);
          $classesArray[] = $class_data["classes"];
        }
        $classesdata = $classesArray;
      }
    } ?>

      <div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
        <p>Congratulations! OxyMonster Framework classes has been installed successfully. 🥳</p>
      <button type="button" class="notice-dismiss">
        <span class="screen-reader-text">
          Dismiss this notice.
        </span>
      </button>
    </div>

  <?php
    $arraysMerged = array_merge([], ...$classesArray);
    $mergedClasses = (object)$arraysMerged;
    $allclassesdata["classes"] = $mergedClasses;
    $stylesheetfolders = stripslashes(json_encode($stylesheetfolders));
    $allclassesdata = stripslashes(json_encode($allclassesdata));

    $monster_css_classes = $allclassesdata;
    $monster_style_folders = $stylesheetfolders;
    $monster_style_sheets = base64_decode($monster_style_sheets);
    $monster_global_settings = base64_decode($monster_global_settings);
		if(!empty($monster_css_classes)){
			$monster_css_classes_array = json_decode($monster_css_classes, true);
			$monster_style_folders_array = json_decode($monster_style_folders, true);
      $monster_style_sheets_array = json_decode($monster_style_sheets, true);
			$monster_global_settings_array = json_decode($monster_global_settings, true);
      $classes 			= get_option("ct_components_classes", array() );
      $custom_selectors 	= get_option("ct_custom_selectors", array() );
      $style_sets 	    = get_option("ct_style_sets", array());
      $style_folders 	    = get_option("ct_style_folders", array());
      $style_sheets 		= get_option("ct_style_sheets", array() );
      $global_settings 	= get_option("ct_global_settings", array() );
      $global_colors 		= oxy_get_global_colors();

      if(!is_array($classes)) {
        $classes = array();
      }
      if(!is_array($custom_selectors)) {
        $custom_selectors = array();
      }
      if(!is_array($style_sets)) {
        $style_sets = array();
      }
      if(!is_array($style_folders)) {
        $style_folders = array();
      }
      if(!is_array($style_sheets)) {
        $style_sheets = array();
      }

      if(isset($monster_css_classes_array['classes']) && is_array($monster_css_classes_array['classes'])) {
        foreach($monster_css_classes_array['classes'] as $key => $item) {
          if(!is_string($key)) {
            unset($monster_css_classes_array['classes'][$key]);
          }
        }
        $classes = array_merge( $classes, $monster_css_classes_array['classes'] );
        update_option("ct_components_classes", $classes );
      }
      // custom selectors started
      if(isset($import_array['custom_selectors']) && is_array($import_array['custom_selectors'])) {
        $custom_selectors = array_merge( $custom_selectors, $import_array['custom_selectors'] );
        update_option("ct_custom_selectors", $custom_selectors );
      }
      // style sets started
      if(isset($import_array['style_sets']) && is_array($import_array['style_sets'])) {
        $style_sets = array_merge( $style_sets, $import_array['style_sets'] );
        update_option("ct_style_sets", $style_sets );
      }
      // style folders started
      if(isset($monster_style_folders_array['style_folders']) && is_array($monster_style_folders_array['style_folders'])) {
        $style_folders = array_merge( $style_folders, $monster_style_folders_array['style_folders'] );
        update_option("ct_style_folders", $style_folders );
      }
      // style sheets started
      if(isset($monster_style_sheets_array['style_sheets']) && is_array($monster_style_sheets_array['style_sheets'])) {
        foreach($monster_style_sheets_array['style_sheets'] as $key => $item) {
          foreach($style_sheets as $existing) {
            if($existing['name'] == $item['name']) {
              unset($monster_style_sheets_array['style_sheets'][$key]);
              break;
            }
          }
        }
        $style_sheets = array_merge( $style_sheets, $monster_style_sheets_array['style_sheets'] );
        update_option("ct_style_sheets", $style_sheets);
      }
      // global settings started
      if(isset($monster_global_settings_array['global_settings']) && is_array($monster_global_settings_array['global_settings'])) {
        $global_settings = $monster_global_settings_array['global_settings'];
        update_option("ct_global_settings", $global_settings);
      }
      // global colors started
      if (is_array($monster_global_settings_array['global_colors'])) {
        $global_colors = $monster_global_settings_array['global_colors'];
        update_option("oxygen_vsb_global_colors", $global_colors);
      }

		}
  }

		?>
		<h2><?php echo self::TITLE.' '.__('- Choose what to install'); ?></h2>
		<form method="post" action="">

			<?php settings_fields(self::PREFIX.'settings'); ?>

       <div class="wrap">
    <div class="oxymonster-subtext">If you already installed our base framework, you don't need to install any other below classes to work with our design kits. If you are looking for our base framework, please <a href="admin.php?page=oxymonster_menu">click here</a></div>
    <br>
    <div class="notice is-dismissible update-message notice inline notice-warning notice-alt" style="padding: 20px; font-size: 18px; line-height: 28px;">
      Installing all the classes below is not recommended 99% of the times. You will end up having around 1500+ classes, if you install the full framework. 99% of the cases, installing <a href="admin.php?page=oxymonster_menu">base framework</a> from the welcome screen is what you need. This full framework is here to give you the option to handpick the classes you really need. Only proceed with the below options if you really know what you are doing.<br>Chrome can't handle more than 1000 classes in our tests and throws "max call stack" error, so if you install the full framework, using Firefox or Safari is recommended.
    </div>
      <form action="" method="post">
              <input type="submit" class="button button-primary" name="submit_framework" value="Install the framework">
              <br></br>
        <table class="wp-list-table widefat plugins">
          <thead>
            <tr>
              <td id="cb" class="manage-column column-cb check-column">
                <label class="screen-reader-text" for="cb-select-all-1">
                  Select All
                </label>
                <input id="cb-select-all-1" type="checkbox">
              </td>
              <th scope="col" id="name" class="manage-column column-name column-primary">Desktop Classes</th>
              <th scope="col" id="description" class="manage-column column-description">More info</th>
            </tr>
          </thead>

          <tbody id="the-list">

    <?php
    $new_imported_classes = get_option("oxymonster_imported_classes");
    function countMyClasses($bname){
      include "framework/".$bname.".php";
      if($classes_data){
        foreach ($classes_data as $class_data) {
          $class_data = json_decode(base64_decode($class_data), true);
          $classesArray[] = $class_data["classes"];
        }
        $classesdata = $classesArray;
        $arraysMerged = array_merge([], ...$classesArray);
        $classesCount = count($arraysMerged);
        return $classesCount." Classes | ";
      }
    }

    function sizeOfClasses($bname){
      include "framework/".$bname.".php";
      if($classes_data){
        foreach ($classes_data as $class_data) {
          $class_data = json_decode(base64_decode($class_data), true);
          $classesArray[] = $class_data["classes"];
        }
        $classesdata = $classesArray;
        $arraysMerged = array_merge([], ...$classesArray);
        $bytesize = mb_strlen(serialize((array)$arraysMerged), '8bit');
        $bytesize = $bytesize / 2;
        if($bytesize < 1024){
          $classSize = round($bytesize)." bytes";
        } else {
          $classSize = round($bytesize/1024, 2)." KB";
        }
        return $classSize;
      }
    }
    ?>
    <style>
      .activate_link {
        background: none;
        border: none;
        color: #0073aa;
        font-size: 13px;
        cursor: pointer;
        padding: 0px;
      }



      .activate_link:hover {
        color: #00a0d2;
      }

      .activated_link {
        color: #47525d;
      }

    </style>
    <?php
      foreach (glob(plugin_dir_path( __FILE__ ) . "framework/*.php") as $classfile){
            include $classfile;
            $basename = explode(".", basename($classfile))[0];
            ?>

          <tr class="<?php if (in_array($basename, $new_imported_classes)) { echo "active"; } else { echo "inactive"; } ?>">
              <th scope="row" class="check-column">
              <input type="checkbox" name="<?php echo $basename; ?>" <?php if (in_array($basename, $new_imported_classes)) { echo 'disabled="disabled" checked="checked"'; } else { } ?>
              </th>
              <td class="plugin-title column-primary">
                <strong><?php echo $name; ?></strong>
                <div class="row-actions visible">

                  <?php
                    if (in_array($basename, $new_imported_classes)) {
                      echo '<span class="activated_link">Activated</span> | <input class="activate_link" type="submit" name="'.$basename.'" value="Reinstall">';
                    } else {
                      echo '<input class="activate_link" type="submit" name="'.$basename.'" value="Activate">';
                    }
                  ?>


                </div>
              </td>
              <td class="column-description desc">
                <div class="plugin-description">
                <p><?php echo $info; ?></p>
                </div>
                <div class="inactive second plugin-version-author-uri">
                <?php if($classes_data){
                  echo countMyClasses($basename);
                  echo sizeOfClasses($basename);
                } else {
                  echo $details;
                }
                  ?>
                </div>
              </td>
            </tr>

    <?php }    ?>

          </tbody>

          <tfoot>
            <tr>
              <td class="manage-column column-cb check-column">
                <label class="screen-reader-text" for="cb-select-all-2">Select All</label>
                <input id="cb-select-all-2" type="checkbox">
              </td>
              <th scope="col" class="manage-column column-name column-primary">
                Category
              </th>
              <th scope="col" class="manage-column column-description">
                More info
              </th>
            </tr>
          </tfoot>
        </table>

        <br>

        <input type="submit" name="submit_framework" class="button button-primary" value="Install the framework">
    </form>
  </div>

		</form>
		<?php
  }

  static function scripts() {
    if ( ! defined( 'SHOW_CT_BUILDER' ) ) {
      return;
    }
    if ( defined( 'OXYGEN_IFRAME' ) ) {
      $oxymonster_mergeClasses = get_option("oxymonster_mergeClasses");
      if(isset($oxymonster_mergeClasses) && $oxymonster_mergeClasses == "Disable"){

      } else {
        wp_register_script( self::PREFIX . 'merge', plugins_url( 'assets/js/merge.js', __FILE__ ), array( 'ct-angular-main' ), OXYMONSTER_VERSION );
        wp_localize_script(self::PREFIX . 'merge', self::PREFIX . 'options', array(
        ));
        wp_enqueue_script( self::PREFIX . 'merge' );
      }
    } else {
      wp_enqueue_style( self::PREFIX . 'style', plugins_url( 'style.css', __FILE__ ), array(), OXYMONSTER_VERSION );
    }
  }


  static function activate( $plugin ) {
		if ( ! defined( 'CT_FW_PATH' ) ) {
			die( '<p>\'Oxygen builder\' must be installed and activated, in order to activate \'' . self::TITLE . '\'</p>' );
	    }
	}

	static function plugin_updater() {
		// retrieve our license key from the DB.
		$license_key = trim( get_option( self::PREFIX . 'license_key' ) );

		// setup the updater.
		$edd_updater = new OxyMonster_Plugin_Updater( OXYMONSTER_STORE_URL, __FILE__,
			array(
				'version' => OXYMONSTER_VERSION,    // current version number
				'license' => $license_key,             // license key (used get_option above to retrieve from DB)
				'item_id' => OXYMONSTER_ITEM_ID,    // ID of the product
				'item_name' => self::TITLE,
				'author'  => 'OxyMonster', // author of this plugin
				'url'     => home_url(),
				'beta'    => false,
			)
		);
	}




}




OxyMonster::init();

?>
