window.addEventListener("load", function () {
	 
	  document.querySelector(".oxygen-toolbar-panels").insertAdjacentHTML(
		"afterend",
		`<div class="oxygen-dom-tree-button oxygen-toolbar-button" onClick="oxyMonsterPasteRouter();">
		<img></img>
		<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11 5C11 4.44772 11.4477 4 12 4C12.5523 4 13 4.44772 13 5V12.1578L16.2428 8.91501L17.657 10.3292L12.0001 15.9861L6.34326 10.3292L7.75748 8.91501L11 12.1575V5Z" fill="currentColor" /><path d="M4 14H6V18H18V14H20V18C20 19.1046 19.1046 20 18 20H6C4.89543 20 4 19.1046 4 18V14Z" fill="currentColor" /></svg>
	</div>`
	  );
	  
		
	  $scope.oxyMonsterPaste = function (arg) {
		  
		if (arg == undefined) {
		  return;
		}
		let copiedString;
		let copiedSet;
		 let y = atob(arg);
		 copiedString = JSON.parse(y);
		 copiedSet = copiedString.set;
		 copiedSections = copiedString.sections;
		 $scope.iframeScope.getComponentsListFromSource(copiedSet+"-0", copiedSet);
		
		try {
			  $scope.iframeScope.getComponentsListFromSource(copiedSet+"-0", copiedSet);
			} catch (err) {
			  alert("You have to insert "+copiedSet+" design set key inside Oxygen settings -> Library");
			}
			
		setTimeout(() => {
			if (arg.length > 0) {
				let copiedString;
				let copiedSet;
				 let y = atob(arg);
				 copiedString = JSON.parse(y);
				 copiedSet = copiedString.set;
				 copiedSections = copiedString.sections;
				 
			  for(j=0; j < copiedSections.length; j++ ) {
				pasteArr = copiedSections[j];
				  let x = $scope.iframeScope.experimental_components[copiedSet].items[pasteArr.title].contents;
				for (let i = 0; i < x.length; i++) {
				  if (x[i].url === pasteArr.url) {
					let id = x[i].id;
					let page = x[i].page;
					let source = x[i].source;
					let designSet = copiedSet;
					$scope.iframeScope.getComponentFromSource(
					  id,
					  source,
					  designSet,
					  page,
					  $scope.iframeScope.addComponentFromSource
					);
					// $scope.iframeScope.closeAllFolders();
					break;
				  }
				}
			  }
			}
		}, 3000);
	  };
	});
	
	function oxyMonsterPasteRouter() {
		if (navigator.userAgent.indexOf("Firefox") > 0) {
			$scope.oxyMonsterPaste(prompt())
		} else {
			pasteElement()
		}
	}
	
	function pasteElement(ev) {
	  if (location.protocol === "https:") {
		var txtClipboard = "";
		let temp = jQuery("<textarea id='oxymonster-pastearea' style='display:none'>");
		jQuery("body").append(temp);
		let pasteText = document.querySelector("#oxymonster-pastearea");
		pasteText.focus();
		if (iCanPaste()) {
		  navigator.clipboard
			.readText()
			.then(function (clipText) {
			  $scope.oxyMonsterPaste(clipText);
			  temp.remove();
			})
			.catch((err) => {
			  console.log("Something went wrong", err);
			});
		}
	  } else {
		$scope.oxyMonsterPaste(prompt());
	  }
	}
	
	function iCanPaste() {
	  return (
		navigator.clipboard &&
		typeof navigator.clipboard.readText === "function" &&
		(location.protocol == "https:" ||
		  location.hostname == "localhost" ||
		  location.hostname == "127.0.0.1")
	  );
	}