window.addEventListener("load", function () {
	
document.querySelector(".oxygen-toolbar-panels").insertAdjacentHTML(
	"afterend",
	`<div class="oxygen-dom-tree-button oxygen-toolbar-button MonsterColorsBtn" id="monsterColorsBtn">
	<img></img>
	<svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
	  <path fill-rule="evenodd" d="M4 2a2 2 0 00-2 2v11a3 3 0 106 0V4a2 2 0 00-2-2H4zm1 14a1 1 0 100-2 1 1 0 000 2zm5-1.757l4.9-4.9a2 2 0 000-2.828L13.485 5.1a2 2 0 00-2.828 0L10 5.757v8.486zM16 18H9.071l6-6H16a2 2 0 012 2v2a2 2 0 01-2 2z" clip-rule="evenodd" />
	</svg>
</div>`
  );
  
  
  var monsterColorsBtn = document.getElementById("monsterColorsBtn");
  
  var monsterDiv = document.createElement("div");
  monsterDiv.id = "monster-sidebar";
  monsterDiv.classList.add("sidebar-collapsed");
  document.body.appendChild(monsterDiv);

  monsterDiv.innerHTML = `
	 <button id="sidebar-closer" class="border-none mt-3 mr-3 bg-trans cursor-pointer"><svg class="w-4 h-4 text-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
	   <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
	 </svg></button>
	<div id="sidebardata" class="sidebar-hide">
	
	<div class="p-6">
	  <p class="text-xl font-semibold mb-2 text-white mt-0">Monster Color System</p>
		<p class="mb-4 flex-shrink min-w-0 text-sm text-white">Click on the color name to copy and paste it into the editor. <a href="/wp-admin/admin.php?page=oxymonster_menu&tab=editor" class="text-white" target="_blank">Edit these colors here</a>.</p>
	  <ul class="mt-3 grid grid-cols-1 gap-5 monstercolors">
	  
		<button type="button" style="background: var(--primary-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--primary-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Primary Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
	
		<button type="button" style="background: var(--dark-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--dark-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Dark Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--paragraph-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--paragraph-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Paragraph Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--border-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--border-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Border Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--placeholder-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--placeholder-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Placeholder Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--background-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--background-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Background Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--secondary-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--secondary-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Secondary Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--light-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--light-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Light Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--paragraph-alt-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--paragraph-alt-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Paragraph Alt Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--border-alt-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--border-alt-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Border Alt Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--placeholder-alt-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--placeholder-alt-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Placeholder Alt Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--background-alt-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--background-alt-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Background Alt Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--tertiary-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--tertiary-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Tertiary Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--black-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--black-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Black Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--white-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--white-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">White Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--success-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--success-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Success Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--warning-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--warning-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Warning Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--error-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--error-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Error Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--success-light-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--success-light-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Success Light Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--warning-light-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--warning-light-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Warning Light Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--error-light-color)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--error-light-color)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Error Light Color</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--extra-color-1)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--extra-color-1)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Extra Color 1</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--extra-color-2)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--extra-color-2)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Extra Color 2</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--extra-color-3)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--extra-color-3)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Extra Color 3</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
		<button type="button" style="background: var(--extra-color-4)" class="col-span-1 flex shadow-sm rounded-md cursor-pointer bg-pink-600 p-0 border-none monster-copy-btn shadow" data-clipboard-text="var(--extra-color-4)">
		  <div class="w-16">
		  </div>
		  <div class="flex-1 flex items-center justify-between border-t border-r border-b border-gray-200 bg-white rounded-r-md truncate">
			<div class="flex-1 px-4 py-2 text-sm truncate">
			  <div class="text-sm text-gray-900 font-medium hover:text-gray-600 cursor-pointer">Extra Color 4</div>
			</div>
			<div class="pr-2">
				<svg class="w-4 h-4 cursor-pointer text-white hover:text-gray-600" "xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
				  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
				</svg>
			</div>
		  </div>
		</button>
		
	   
	  </ul>
	</div>
	
	
	
	
	</div>
  `;

  
  monsterColorsBtn.addEventListener("click", _ => {
		document.getElementById("monster-sidebar").classList.toggle("sidebar-collapsed"); 
		document.getElementById("sidebardata").classList.toggle("sidebar-hide");
	});
	
  var monsterCloseBtn = document.getElementById("sidebar-closer");
  monsterCloseBtn.addEventListener("click", _ => {
		document.getElementById("monster-sidebar").classList.toggle("sidebar-collapsed"); 
		document.getElementById("sidebardata").classList.toggle("sidebar-hide");
	});
  
  new ClipboardJS('.monster-copy-btn');
  
});