<?php  
  function monster_admin_scripts(){
	// wp_enqueue_script('monster-admin-css', $this->urlpath  . '/your-script-filename.js', array('jquery'), '1.2.3', true);
	$current_screen = get_current_screen();

	if ( strpos($current_screen->base, 'oxymonster_menu') === false) {
		return;
	} else {
	wp_enqueue_style( 'monster-admin-css', OXYMONSTER_ASSETS. '/css/admin.css', false, OXYMONSTER_VERSION, 'all');
	}
  }
  add_action('admin_enqueue_scripts', "monster_admin_scripts");
  
  
  
  function monstercolors_styles() {
	if ( defined( 'SHOW_CT_BUILDER' ) ) {
	  wp_register_style( "monsterColorsSheet", OXYMONSTER_ASSETS. '/css/monster.css');
	  wp_enqueue_style( 'monsterColorsSheet' );
	  $upbasedir = wp_get_upload_dir();
	  $updir = $upbasedir["baseurl"]."/oxymade/";
	  $custom_css_file = $updir.'monstercolors.css';
	  wp_register_style( "OxyMonsterColors", $custom_css_file);
	  
	  wp_enqueue_style( 'OxyMonsterColors' );
	  wp_enqueue_script( 'oxymonster-clipboard', 'https://cdn.jsdelivr.net/npm/clipboard@2.0.6/dist/clipboard.min.js', [], OXYMONSTER_VERSION, false );
	} else {
	  wp_print_styles( 'monsterColorsSheet' );
	  wp_print_styles( 'OxyMonsterColors' );
	}
  }
  add_action( 'oxygen_enqueue_ui_scripts', 'monstercolors_styles' );
  
  function monster_enqueue_styles() {
	$upbasedir = wp_get_upload_dir();
	$updir = $upbasedir["baseurl"]."/oxymade/";
	$custom_css_file = $updir.'monstercolors.css';
	wp_register_style( "OxyMonsterColors", $custom_css_file);
	wp_enqueue_style( 'OxyMonsterColors' );
  }
  add_action( 'wp_enqueue_scripts', 'monster_enqueue_styles' );
  
  
  
  
  function oxymonster_styles_activate() {
	$monsterStyleSheet = get_option('oxymonster_stylesheet');
	if($monsterStyleSheet == "Installed"){
	} else {
	  // include "quick/install.php";
	  $framework_data = file_get_contents("https://oxymade.com/assets/json/framework_data.json");
	  $framework_data = json_decode($framework_data, true);
	  $monster_styles = $framework_data["default"];
	  
	  $monster_styles = $default;
	  $import_json = base64_decode($monster_styles);
	  $style_sheets 		= get_option("ct_style_sheets", array() );
	  if (!is_array($style_sheets)) {
		$style_sheets = array();
	  }
	  $import_json = sanitize_text_field( stripcslashes( $import_json ) );
	  $import_array = json_decode( $import_json, true );
	  if(isset($import_array['style_sheets']) && is_array($import_array['style_sheets'])) {
		foreach($import_array['style_sheets'] as $key => $item) {
		  foreach($style_sheets as $existing) {
			if($existing['name'] == $item['name']) {
			  unset($import_array['style_sheets'][$key]);
			  break;
			}
		  }
		}
		$style_sheets = array_merge( $style_sheets, $import_array['style_sheets'] );
		update_option("ct_style_sheets", $style_sheets);
	  }
	  add_option('oxymonster_stylesheet', 'Installed');
	}
  }
  register_activation_hook(__FILE__, 'oxymonster_styles_activate');
  
?>