<?php
if(isset($_POST["quick_install_framework"])){
  if($_POST["quick_install_framework"] == "yes_please") {

  $framework_data = file_get_contents("https://oxymonster.com/assets/json/framework_data.json");
  $framework_data = json_decode($framework_data, true);

	$monster_quick_import = $framework_data["base_framework"];

  
  $import_json = base64_decode($monster_quick_import);

  $classes 			= get_option("ct_components_classes", array() );
  $custom_selectors 	= get_option("ct_custom_selectors", array() );
  $style_sets 		= get_option("ct_style_sets", array());
  $style_folders 		= get_option("ct_style_folders", array());
  $style_sheets 		= get_option("ct_style_sheets", array() );
  $global_settings 	= get_option("ct_global_settings", array() );
  $element_presets 	= get_option("oxygen_vsb_element_presets", array());
  $global_colors 		= oxy_get_global_colors();

  // generate export JSON
  $export_json['classes'] 			= $classes;
  $export_json['custom_selectors'] 	= $custom_selectors;
  $export_json['style_sets'] 			= $style_sets;
  $export_json['style_folders'] 		= $style_folders;
  $export_json['style_sheets'] 		= $style_sheets;
  $export_json['global_settings'] 	= $global_settings;
  $export_json['global_colors'] 		= $global_colors;
  $export_json['element_presets'] 	= $element_presets;

  // generate JSON object
  $export_json = json_encode( $export_json );
  $export_backup = get_option("oxymonster_oxygen_settings_backup");

  if(isset($export_backup) && !empty($export_backup)){
	
  } else {
	add_option("oxymonster_oxygen_settings_backup", $export_json);
  }

  if (!is_array($classes)) {
	$classes = array();
  }

  if (!is_array($custom_selectors)) {
	$custom_selectors = array();
  }

  if (!is_array($style_sets)) {
	$style_sets = array();
  }

  if (!is_array($style_folders)) {
	$style_folders = array();
  }

  if (!is_array($style_sheets)) {
	$style_sheets = array();
  }

	$import_json = sanitize_text_field( stripcslashes( $import_json ) );

	// check if empty
	if ( empty( $import_json ) ) {
	  $import_errors[] = __("Empty Import");
	}
	else {
	  // try to decode
	  $import_array = json_decode( $import_json, true );

	  // update options
	  if ( $import_array ) {

		if(isset($import_array['classes']) && is_array($import_array['classes'])) {
		  foreach($import_array['classes'] as $key => $item) {
			if(!is_string($key)) {
			  unset($import_array['classes'][$key]);
			}
		  }

		  $classes = array_merge( $classes, $import_array['classes'] );
		  update_option("ct_components_classes", $classes );
		}

		// custom selectors
		if(isset($import_array['custom_selectors']) && is_array($import_array['custom_selectors'])) {
		  $custom_selectors = array_merge( $custom_selectors, $import_array['custom_selectors'] );
		  update_option("ct_custom_selectors", $custom_selectors );
		}

		// style sets
		if(isset($import_array['style_sets']) && is_array($import_array['style_sets'])) {
		  $style_sets = array_merge( $style_sets, $import_array['style_sets'] );
		  update_option("ct_style_sets", $style_sets );
		}

		// style folders
		if(isset($import_array['style_folders']) && is_array($import_array['style_folders'])) {
		  $style_folders = array_merge( $style_folders, $import_array['style_folders'] );
		  update_option("ct_style_folders", $style_folders );

		}

		// style sheets
		if(isset($import_array['style_sheets']) && is_array($import_array['style_sheets'])) {

		  foreach($import_array['style_sheets'] as $key => $item) {
			foreach($style_sheets as $existing) {
			  if($existing['name'] == $item['name']) {
				unset($import_array['style_sheets'][$key]);
				break;
			  }
			}
		  }
		  $style_sheets = array_merge( $style_sheets, $import_array['style_sheets'] );
		  update_option("ct_style_sheets", $style_sheets);
		}

		

		// presets
		if(isset($import_array['element_presets']) && is_array($import_array['element_presets'])) {
		  $element_presets = array_merge_recursive( $element_presets, $import_array['element_presets'] );
		  update_option("oxygen_vsb_element_presets", $element_presets );
		}

		$import_success[] = __("Import success", "component-theme");
		add_option("oxymonster_imported_classes", array("colors", "global_settings", "grid", "font_size", "text", "margin", "padding", "height", "width"));
		update_option("oxymonster_imported_classes", array("colors", "global_settings", "grid", "font_size", "text", "margin", "padding", "height", "width"));
		add_option("oxymonster_quick_install", "installed");
		?>

	<div id="message" class="updated notice is-dismissible" style="margin-top: 20px;">
	<p>Congratulations! OxyMonster Framework quick recommended classes has been installed successfully. 🥳</p>
  <button type="button" class="notice-dismiss">
	<span class="screen-reader-text">
	  Dismiss this notice.
	</span>
  </button>
</div>

  <?php
	  }
	  else {
		$import_errors[] = __("Wrong JSON Format", "component-theme");
	  }
	}
  } 
  }?>

	  <div class="oxymonsterflex">
<div class="oxymonsterleftside">
  <h2>OxyMonster Base Framework</h2>
  
  <div class="oxymonster-subtext">
	Mandatory base framework installation to use our design sets 🚀
  </div>
  
  <div class="join-updates">
  👉 &nbsp; Please join our <a href="https://facebook.com/groups/oxyfamily">Facebook group</a> to know more updates.
  </div><div class="join-updates">
  👉 &nbsp; Please subscribe to our <a href="https://www.youtube.com/channel/UCE0I0GTGgigAunelftg63Fg">Youtube channel</a> to watch video guides.
  </div><div class="join-updates">
  👉 &nbsp; Please read our <a href="https://oxymade.com/help/documentation/">documentation</a> to get started.
  </div><div class="join-updates">
	👉 &nbsp; Please check below get started guides.
	</div>
</div>

<div class="oxymonsterrightside">
  
  
  <form action="" method="post">
	  <?php
		$quick_install = get_option("oxymonster_quick_install");
		if(isset($quick_install) && $quick_install == "installed") { ?>
		  <button type="submit" class="oxymonster-submit button button-primary" name="quick_install_framework" disabled value="yes_please">Our base framework is installed</button>
		  <button type="submit" class="button" name="quick_install_framework" value="yes_please">Want to Reinstall?</button>
		<?php } else { ?>
		  <button type="submit" class="oxymonster-submit button button-primary" name="quick_install_framework" value="yes_please">Install the base framework</button>
		<?php } ?>

		</form>
  
		  
</div></div>
<br>
<div class="wrap">
	<div class="oxymonster-flex">
  <div class="oxymonster-leftside">

	<div class="oxymonster-section">
	  <h2>👉 &nbsp; Get started with our framework</h2>
	  
	  <h4>Step 1: Install the base framework above.</h4>
	  <p>Read the above info and <a href="/wp-admin/admin.php?page=oxymonster_menu&tab=welcome">install the base framework</a> to quickly start using our framework. Those checkboxes are !important, so please read carefully.</p>
  
	  <h4>Step 2: Install the Color palette.</h4>
	  <p>After you have installed the base framework, you need to <a href="wp-admin/admin.php?page=oxymonster_menu&tab=colors">install the color palette</a> of your choice from number of color palettes we have.</p>
   
	  <h4>Step 3: Check Framework Modules.</h4>
	  <p>We have <a href="/wp-admin/admin.php?page=oxymonster_menu&tab=modules">number of modules available</a> in Monster framework to speed up the desinging process. Please take a look at them.</p>
	
	  <h4>Step 4: Read the design system guide.</h4>
	  <p>We have an in-depthh, detailed video and an article on <a href="https://oxymade.com/design-system">our design system</a>. It's better to take a few minutes to read/watch it before you start the work!</p>
	  
	</div>
  </div>

<div class="oxymonster-rightside">

  <div class="oxymonster-section">
	<h2>👉 &nbsp; Get started with our design kits</h2>
	<h4>Step 1: Get a site key from our dashboard.</h4>
	<p>You can get your site key from our dashboards in <a href="https://oxymade.com/dashboard">OxyMade</a> & <a href="https://oxymonster.com/dashboard/">OxyMonster</a>. Add your domain and get a site key to add in your Oxygen library.</p>
	
	<h4>Step 2: Add the site key in your design library.</h4>
	<p>Go to your <a href="/wp-admin/admin.php?page=oxygen_vsb_settings&tab=library_manager">site library</a> in your oxygen settings and add the site key you got from the Step-1. Enable 3rd party design sets and click on + Add Design Set link to add the site key.</p>
	
	<h4>Step 3: Install & check the Color palette.</h4>
	<p>Check our color palettes area to quickly <a href="wp-admin/admin.php?page=oxymonster_menu&tab=colors">install color palettes</a> and design kit specific settings and extra classes for your website.</p>
	
	<h4>Step 4: Check our documentation & cheatsheet </h4>
	<p>We have prepared a detailed <a href="https://oxymade.com/help/documentation/">get started guide</a> & a <a href="https://oxymade.com/help/cheatsheet/">live cheatsheet</a> to quickly check all the classes we have in our framework. Give it a look and get started with our framework quickly.</p>
	
	<h4>Step 5: Start adding our blocks to the website.</h4>
	<p>Once you have our design set in your Oxygen library, you can visit our <a href="https://kit.oxymade.com/preview.php">Live preview</a> or <a href="https://oxymade.com/app.php">page builder</a> to copy our designs/templates & paste them with one click.</p>
  </div>

</div>
	</div>
<p><b>Happy crafting a beautiful website 😍 </b></p>

	</div>
