<?php
/**
 * @package Polylang-Pro
 */

/**
 * Interface PLL_Import_Export_File_Format
 *
 * @since 3.1
 *
 * Represents a supported format for the import / export feature.
 */
abstract class PLL_File_Format {
	/**
	 * @var string
	 */
	public $extension;

	/**
	 * @var string
	 */
	public $mime_type;

	/**
	 * Whether the file format is supported by the current environment or not.
	 *
	 * @since 3.1
	 *
	 * @return true|WP_Error
	 */
	abstract public function is_supported();

	/**
	 * Returns the associated import class.
	 *
	 * @since 3.1
	 *
	 * @return PLL_Import_File
	 */
	abstract public function get_import();

	/**
	 * Returns the associated export class.
	 *
	 * @since 3.1
	 *
	 * @return PLL_Export_File
	 */
	abstract public function get_export();
}
