(() => {
	'use strict';
	
	var external_plugins = window["wp"]["plugins"];
	var external_element = window["wp"]["element"];
	var external_blocks = window["wp"]["blocks"];
	var external_blockEditor = window["wp"]["blockEditor"];
	var external_i18n = window["wp"]["i18n"];
	var external_data = window["wp"]["data"];
	var external_compose = window["wp"]["compose"];
	var external_components = window["wp"]["components"];
	var external_primitives = window["wp"]["primitives"];
	var external_wc_blocksCheckout = window["wc"]["blocksCheckout"];
	var external_wc_priceFormat = window["wc"]["priceFormat"];
	var external_htmlEntities = window["wp"]["htmlEntities"];
	var external_wc_settings = window["wc"]["wcSettings"];
	var external_wc_BlocksRegistry = window["wc"]["wcBlocksRegistry"];

	const paymentMethod = external_wc_settings.getPaymentMethodData("_qts_quote_request"),
		label = external_htmlEntities.decodeEntities(null !== paymentMethod ? paymentMethod.title : ""),
		description = external_htmlEntities.decodeEntities(null !== paymentMethod ? paymentMethod.description : "");

	const content = function (e) {
		return external_element.createElement(external_element.RawHTML, null, description);
	};

	var callBack = {
		ourData: null,
		isOurs: function (e) {	
			// Bail out early.            
			if (undefined === e['quote-request-for-woocommerce']) {
				return false;
			}

			callBack.ourData = e['quote-request-for-woocommerce'];
			return true;
		},       
		cartBlocks: {
			convert_to_quote_init: function (e) {  		
				if (callBack.isOurs(e.extensions) && callBack.ourData.convert_to_quote_enabled) { 
					return external_element.createElement(callBack.cartBlocks.converttoQuote.init, e);
				}
				
				return null;
			},
			back_to_cart_init: function (e) {  
				if (callBack.isOurs(e.extensions) && callBack.ourData.back_to_cart_enabled) { 
					return external_element.createElement(callBack.cartBlocks.backtoCart.init, e);
				}
				
				return null;
			},
			converttoQuote: {              
				cartSchema: JSON.parse("{\"name\":\"woocommerce/cart-order-summary-qts-convert-to-quote-block\",\"icon\":\"welcome-write-blog\",\"keywords\":[\"convert\" , \"quote\"],\"version\":\"1.0.0\",\"title\":\"Convert to Quote\",\"description\":\"Shows the Convert to Quote Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/cart-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				checkoutSchema: JSON.parse("{\"name\":\"woocommerce/checkout-order-summary-qts-convert-to-quote-block\",\"icon\":\"welcome-write-blog\",\"keywords\":[\"convert\" , \"quote\"],\"version\":\"1.0.0\",\"title\":\"Convert to Quote\",\"description\":\"Shows the Convert to Quote Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/checkout-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				isLoading: false,
				setLoading: null,
				init: function (e) {    
					return external_element.createElement(external_element.Fragment, null,
						external_element.createElement(callBack.cartBlocks.converttoQuote.submit, null));
				},                
				submit: function () {          
					[ callBack.cartBlocks.converttoQuote.isLoading, callBack.cartBlocks.converttoQuote.setLoading ] = external_element.useState( false );
					return external_element.createElement(external_wc_blocksCheckout.TotalsWrapper, { className: "qts-convert-to-quote-wrapper" + (callBack.cartBlocks.converttoQuote.isLoading ? "qts-component--disabled" : "") },
						external_element.createElement(external_element.RawHTML, null, callBack.ourData.convert_to_quote_button));
				},
			},
			backtoCart: {              
				cartSchema: JSON.parse("{\"name\":\"woocommerce/cart-order-summary-qts-back-to-cart-block\",\"icon\":\"controls-back\",\"keywords\":[\"back\" , \"cart\"],\"version\":\"1.0.0\",\"title\":\"Back to Cart\",\"description\":\"Shows the Back to Cart Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/cart-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				checkoutSchema: JSON.parse("{\"name\":\"woocommerce/checkout-order-summary-qts-back-to-cart-block\",\"icon\":\"controls-back\",\"keywords\":[\"back\" , \"cart\"],\"version\":\"1.0.0\",\"title\":\"Back to Cart\",\"description\":\"Shows the Back to Cart Button.\",\"category\":\"woocommerce\",\"supports\":{\"align\":false,\"html\":false,\"multiple\":false,\"reusable\":false},\"attributes\":{\"className\":{\"type\":\"string\",\"default\":\"\"},\"lock\":{\"type\":\"object\",\"default\":{\"remove\":true,\"move\":false}}},\"parent\":[\"woocommerce/checkout-totals-block\"],\"textdomain\":\"quote-request-for-woocommerce\",\"apiVersion\":2}"),
				isLoading: false,
				setLoading: null,
				init: function (e) {    
					return external_element.createElement(external_element.Fragment, null,
						external_element.createElement(callBack.cartBlocks.backtoCart.undo, null));
				},                
				undo: function () {          
					[ callBack.cartBlocks.backtoCart.isLoading, callBack.cartBlocks.backtoCart.setLoading ] = external_element.useState( false );
					return external_element.createElement(external_wc_blocksCheckout.TotalsWrapper, { className: "qts-back-to-cart-wrapper" + (callBack.cartBlocks.backtoCart.isLoading ? "qts-component--disabled" : "") },
						external_element.createElement(external_element.RawHTML, null, callBack.ourData.back_to_cart_button));
				},
			}
		},
	};
	
	external_wc_blocksCheckout.registerCheckoutBlock({
		metadata: callBack.cartBlocks.converttoQuote.cartSchema,
		component: callBack.cartBlocks.convert_to_quote_init
	});

	external_wc_blocksCheckout.registerCheckoutBlock({
		metadata: callBack.cartBlocks.converttoQuote.checkoutSchema,
		component: callBack.cartBlocks.convert_to_quote_init
	});

	external_wc_blocksCheckout.registerCheckoutBlock({
		metadata: callBack.cartBlocks.backtoCart.cartSchema,
		component: callBack.cartBlocks.back_to_cart_init
	});

	external_wc_blocksCheckout.registerCheckoutBlock({
		metadata: callBack.cartBlocks.backtoCart.checkoutSchema,
		component: callBack.cartBlocks.back_to_cart_init
	});

	external_wc_BlocksRegistry.registerPaymentMethod({
		name: "_qts_quote_request",
		label: label,
		ariaLabel: label,
		content: external_element.createElement(content),
		edit: external_element.createElement(content),
		canMakePayment: (e) => {
			return null !== paymentMethod ? paymentMethod.is_available : false;
		},
		supports: {
			features: null !== paymentMethod ? paymentMethod.supports : []
		}
	});

})()
