/* global ajaxurl, qts_admin_settings_general, wp */

jQuery( function( $ ) {
    'use strict';

    // qts_admin_settings_general is required to continue, ensure the object exists
    if ( typeof qts_admin_settings_general === 'undefined' ) {
        return false;
    }

    var is_blocked = function( $node ) {
        return $node.is( '.processing' ) || $node.parents( '.processing' ).length;
    };

    /**
     * Block a node visually for processing.
     *
     * @param {JQuery Object} $node
     */
    var block = function( $node ) {
        $.blockUI.defaults.overlayCSS.cursor = 'wait';

        if ( ! is_blocked( $node ) ) {
            $node.addClass( 'processing' ).block( {
                message : null,
                overlayCSS : {
                    background : '#fff',
                    opacity : 0.6
                }
            } );
        }
    };

    /**
     * Unblock a node after processing is complete.
     *
     * @param {JQuery Object} $node
     */
    var unblock = function( $node ) {
        $node.removeClass( 'processing' ).unblock();
    };

    $( '#_qts_quote_request_enabled' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_get_product_select_type' ).trigger( 'change' ).closest( 'tr' ).show();
            $( '#_qts_min_quote_req_price_percentage' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_get_product_select_type' ).trigger( 'change' ).closest( 'tr' ).hide();
            $( '#_qts_min_quote_req_price_percentage' ).closest( 'tr' ).hide();
        }
    } ).change();

    $( '#_qts_display_add_to_quote_for_guests' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_when_guest_clicked_add_to_quote' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_when_guest_clicked_add_to_quote' ).closest( 'tr' ).hide();
        }
    } ).change();

    /*
     * Toggle the user selection.
     */
    $( '#_qts_get_user_select_type' ).change( function() {
        $( '#_qts_get_included_users,#_qts_get_excluded_users,#_qts_get_included_userroles,#_qts_get_excluded_userroles' ).closest( 'tr' ).hide();

        if ( 'include-users' === this.value || 'exclude-users' === this.value ) {
            if ( 'include-users' === this.value ) {
                $( '#_qts_get_included_users' ).closest( 'tr' ).show();
            } else {
                $( '#_qts_get_excluded_users' ).closest( 'tr' ).show();
            }
        } else if ( 'include-userroles' === this.value || 'exclude-userroles' === this.value ) {
            if ( 'include-userroles' === this.value ) {
                $( '#_qts_get_included_userroles' ).closest( 'tr' ).show();
            } else {
                $( '#_qts_get_excluded_userroles' ).closest( 'tr' ).show();
            }
        }
    } ).change();

    /*
     * Toggle the Products/Category selection.
     */
    $( '#_qts_get_product_select_type' ).change( function() {
        $( '#_qts_get_include_product_selector,#_qts_get_exclude_product_selector,#_qts_get_include_product_category_selector,#_qts_get_exclude_product_category_selector' ).closest( 'tr' ).hide();
        $( '#_qts_get_include_product_tag_selector,#_qts_get_exclude_product_tag_selector' ).closest( 'tr' ).hide();
        $( '#_qts_get_include_product_brand_selector,#_qts_get_exclude_product_brand_selector' ).closest( 'tr' ).hide();

        if ( $( '#_qts_quote_request_enabled' ).is( ':checked' ) ) {
            if ( 'include-products' === this.value || 'exclude-products' === this.value ) {
                if ( 'include-products' === this.value ) {
                    $( '#_qts_get_include_product_selector' ).closest( 'tr' ).show();
                } else {
                    $( '#_qts_get_exclude_product_selector' ).closest( 'tr' ).show();
                }
            } else if ( 'include-categories' === this.value || 'exclude-categories' === this.value ) {
                if ( 'include-categories' === this.value ) {
                    $( '#_qts_get_include_product_category_selector' ).closest( 'tr' ).show();
                } else {
                    $( '#_qts_get_exclude_product_category_selector' ).closest( 'tr' ).show();
                }
            } else if ( 'include-tags' === this.value || 'exclude-tags' === this.value ) {
                if ( 'include-tags' === this.value ) {
                    $( '#_qts_get_include_product_tag_selector' ).closest( 'tr' ).show();
                } else {
                    $( '#_qts_get_exclude_product_tag_selector' ).closest( 'tr' ).show();
                }
            } else if ( 'include-brands' === this.value || 'exclude-brands' === this.value ) {
                if ( 'include-brands' === this.value ) {
                    $( '#_qts_get_include_product_brand_selector' ).closest( 'tr' ).show();
                } else {
                    $( '#_qts_get_exclude_product_brand_selector' ).closest( 'tr' ).show();
                }
            } 
        }
    } ).change();

    $( '#_qts_hide_add_to_cart' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_hide_product_price' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_hide_product_price' ).closest( 'tr' ).hide();
        }
    } ).change();

    $( '#_qts_display_add_to_quote_for_out_of_stock' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_display_add_to_quote_only_for_out_of_stock' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_display_add_to_quote_only_for_out_of_stock' ).closest( 'tr' ).hide();
        }
    } ).change();

    $( '#_qts_allow_add_to_quote_more_than_available_inventory' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_make_payment_when_not_having_enough_stock' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_make_payment_when_not_having_enough_stock' ).closest( 'tr' ).hide();
        }
    } ).change();

    $( '#_qts_display_request_price_field' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_request_price_field_type' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_request_price_field_type' ).closest( 'tr' ).hide();
        }
    } ).change();

    $( '#_qts_display_convert_to_quote_button_in_cart_page' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_convert_to_quote_button_position_in_cart_page' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_convert_to_quote_button_position_in_cart_page' ).closest( 'tr' ).hide();
        }
    } );

    $( '#_qts_display_convert_to_quote_button_in_checkout_page' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_convert_to_quote_button_position_in_checkout_page' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_convert_to_quote_button_position_in_checkout_page' ).closest( 'tr' ).hide();
        }
    } );

    $( '#_qts_enable_convert_to_quote' ).change( function() {
        if ( this.checked ) {
            $( '#_qts_display_convert_to_quote_button_in_cart_page' ).trigger( 'change' ).closest( 'tr' ).show();
            $( '#_qts_display_convert_to_quote_button_in_checkout_page' ).trigger( 'change' ).closest( 'tr' ).show();
            $( '#_qts_display_back_to_cart_button_in_quote_page' ).closest( 'tr' ).show();
        } else {
            $( '#_qts_convert_to_quote_button_position_in_cart_page' ).closest( 'tr' ).hide();
            $( '#_qts_convert_to_quote_button_position_in_checkout_page' ).closest( 'tr' ).hide();
            $( '#_qts_display_convert_to_quote_button_in_cart_page' ).closest( 'tr' ).hide();
            $( '#_qts_display_convert_to_quote_button_in_checkout_page' ).closest( 'tr' ).hide();
            $( '#_qts_display_back_to_cart_button_in_quote_page' ).closest( 'tr' ).hide();
        }
    } ).change();
} );
